/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.cast.framework.media.widget.zzs;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzln;
import com.google.android.gms.internal.cast.zzr;

public class MiniControllerFragment
extends Fragment
implements ControlButtonsContainer {
    private static final Logger zza = new Logger("MiniControllerFragment");
    private boolean zzb;
    private int zzc;
    private int zzd;
    private TextView zze;
    private int zzf;
    private int zzg;
    @ColorInt
    private int zzh;
    private int zzi;
    private int[] zzj;
    private final ImageView[] zzk = new ImageView[3];
    private int zzl;
    @DrawableRes
    private int zzm;
    @DrawableRes
    private int zzn;
    @DrawableRes
    private int zzo;
    @DrawableRes
    private int zzp;
    @DrawableRes
    private int zzq;
    @DrawableRes
    private int zzr;
    @DrawableRes
    private int zzs;
    @DrawableRes
    private int zzt;
    @DrawableRes
    private int zzu;
    @DrawableRes
    private int zzv;
    @DrawableRes
    private int zzw;
    @DrawableRes
    private int zzx;
    @Nullable
    private UIMediaController zzy;

    @Override
    public final int getButtonSlotCount() {
        return 3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getButtonTypeAt(int slotIndex) throws IndexOutOfBoundsException {
        void var1_1;
        return this.zzj[var1_1];
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle object) {
        RelativeLayout relativeLayout;
        View view;
        this.zzy = new UIMediaController((Activity)this.getActivity());
        object = this.zzy;
        view = view.inflate(R.layout.cast_mini_controller, (ViewGroup)relativeLayout);
        view.setVisibility(8);
        ((UIMediaController)object).bindViewVisibilityToMediaSession(view, 8);
        relativeLayout = (RelativeLayout)view.findViewById(R.id.container_current);
        int n = this.zzf;
        if (n != 0) {
            relativeLayout.setBackgroundResource(n);
        }
        ImageView imageView = (ImageView)view.findViewById(R.id.icon_view);
        TextView textView = (TextView)view.findViewById(R.id.title_view);
        if (this.zzc != 0) {
            textView.setTextAppearance((Context)this.getActivity(), this.zzc);
        }
        this.zze = (TextView)view.findViewById(R.id.subtitle_view);
        if (this.zzd != 0) {
            this.zze.setTextAppearance((Context)this.getActivity(), this.zzd);
        }
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.progressBar);
        if (this.zzg != 0) {
            ((LayerDrawable)progressBar.getProgressDrawable()).setColorFilter(this.zzg, PorterDuff.Mode.SRC_IN);
        }
        ((UIMediaController)object).bindTextViewToMetadataOfCurrentItem(textView, "com.google.android.gms.cast.metadata.TITLE");
        ((UIMediaController)object).bindTextViewToSmartSubtitle(this.zze);
        ((UIMediaController)object).bindProgressBar(progressBar);
        ((UIMediaController)object).bindViewToLaunchExpandedController((View)relativeLayout);
        if (this.zzb) {
            int n2 = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_width);
            int n3 = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_height);
            ((UIMediaController)object).bindImageViewToImageOfCurrentItem(imageView, new ImageHints(2, n2, n3), R.drawable.cast_album_art_placeholder);
        } else {
            imageView.setVisibility(8);
        }
        this.zzk[0] = (ImageView)relativeLayout.findViewById(R.id.button_0);
        this.zzk[1] = (ImageView)relativeLayout.findViewById(R.id.button_1);
        this.zzk[2] = (ImageView)relativeLayout.findViewById(R.id.button_2);
        this.zza((UIMediaController)object, relativeLayout, R.id.button_0, 0);
        this.zza((UIMediaController)object, relativeLayout, R.id.button_1, 1);
        this.zza((UIMediaController)object, relativeLayout, R.id.button_2, 2);
        return view;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NonNull
    public final ImageView getButtonImageViewAt(int slotIndex) throws IndexOutOfBoundsException {
        void var1_1;
        return this.zzk[var1_1];
    }

    @Override
    @Nullable
    public UIMediaController getUIMediaController() {
        return this.zzy;
    }

    public void onDestroy() {
        UIMediaController uIMediaController = this.zzy;
        if (uIMediaController != null) {
            uIMediaController.dispose();
            this.zzy = null;
        }
        super.onDestroy();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void onInflate(@NonNull Context context, @NonNull AttributeSet attrs, @Nullable Bundle savedInstanceState) {
        void var3_4;
        TypedArray typedArray;
        Object[] objectArray;
        super.onInflate((Context)objectArray, (AttributeSet)typedArray, (Bundle)var3_4);
        if (this.zzj == null) {
            typedArray = objectArray.obtainStyledAttributes((AttributeSet)typedArray, R.styleable.CastMiniController, R.attr.castMiniControllerStyle, R.style.CastMiniController);
            this.zzb = typedArray.getBoolean(R.styleable.CastMiniController_castShowImageThumbnail, true);
            this.zzc = typedArray.getResourceId(R.styleable.CastMiniController_castTitleTextAppearance, 0);
            this.zzd = typedArray.getResourceId(R.styleable.CastMiniController_castSubtitleTextAppearance, 0);
            this.zzf = typedArray.getResourceId(R.styleable.CastMiniController_castBackground, 0);
            this.zzg = typedArray.getColor(R.styleable.CastMiniController_castProgressBarColor, 0);
            this.zzh = typedArray.getColor(R.styleable.CastMiniController_castMiniControllerLoadingIndicatorColor, this.zzg);
            this.zzi = typedArray.getResourceId(R.styleable.CastMiniController_castButtonColor, 0);
            this.zzm = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
            this.zzn = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
            this.zzo = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
            this.zzp = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
            this.zzq = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
            this.zzr = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
            this.zzs = typedArray.getResourceId(R.styleable.CastMiniController_castSkipPreviousButtonDrawable, 0);
            this.zzt = typedArray.getResourceId(R.styleable.CastMiniController_castSkipNextButtonDrawable, 0);
            this.zzu = typedArray.getResourceId(R.styleable.CastMiniController_castRewind30ButtonDrawable, 0);
            this.zzv = typedArray.getResourceId(R.styleable.CastMiniController_castForward30ButtonDrawable, 0);
            this.zzw = typedArray.getResourceId(R.styleable.CastMiniController_castMuteToggleButtonDrawable, 0);
            this.zzx = typedArray.getResourceId(R.styleable.CastMiniController_castClosedCaptionsButtonDrawable, 0);
            int n = typedArray.getResourceId(R.styleable.CastMiniController_castControlButtons, 0);
            if (n != 0) {
                TypedArray typedArray2 = objectArray.getResources().obtainTypedArray(n);
                int n2 = typedArray2.length() == 3 ? 1 : 0;
                Preconditions.checkArgument(n2 != 0);
                this.zzj = new int[typedArray2.length()];
                n2 = 0;
                while (n2 < typedArray2.length()) {
                    int n3 = n2++;
                    this.zzj[n3] = typedArray2.getResourceId(n3, 0);
                }
                typedArray2.recycle();
                if (this.zzb) {
                    this.zzj[0] = R.id.cast_button_type_empty;
                }
                this.zzl = 0;
                int[] nArray = this.zzj;
                int n4 = nArray.length;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (nArray[n2] == R.id.cast_button_type_empty) continue;
                    ++this.zzl;
                }
            } else {
                objectArray = new Object[]{};
                zza.w("Unable to read attribute castControlButtons.", objectArray);
                this.zzj = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
            }
            typedArray.recycle();
        }
        com.google.android.gms.internal.cast.zzr.zzd(zzln.zzd);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zza(UIMediaController uIMediaController, RelativeLayout relativeLayout, int n, int n2) {
        ImageView imageView;
        block13: {
            block12: {
                imageView = (ImageView)relativeLayout.findViewById(n);
                if ((n2 = this.zzj[n2]) == R.id.cast_button_type_empty) {
                    imageView.setVisibility(4);
                    return;
                }
                if (n2 == R.id.cast_button_type_custom) break block12;
                if (n2 == R.id.cast_button_type_play_pause_toggle) {
                    n2 = this.zzm;
                    int n3 = this.zzn;
                    int n4 = this.zzo;
                    if (this.zzl == 1) {
                        n2 = this.zzp;
                        n3 = this.zzq;
                        n4 = this.zzr;
                    }
                    Drawable drawable2 = com.google.android.gms.cast.framework.media.widget.zzs.zzc(this.getContext(), this.zzi, n2);
                    Drawable drawable3 = com.google.android.gms.cast.framework.media.widget.zzs.zzc(this.getContext(), this.zzi, n3);
                    Drawable drawable4 = com.google.android.gms.cast.framework.media.widget.zzs.zzc(this.getContext(), this.zzi, n4);
                    imageView.setImageDrawable(drawable3);
                    ProgressBar progressBar = new ProgressBar(this.getContext());
                    RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                    layoutParams.addRule(8, n);
                    layoutParams.addRule(6, n);
                    layoutParams.addRule(5, n);
                    layoutParams.addRule(7, n);
                    layoutParams.addRule(15);
                    progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    progressBar.setVisibility(8);
                    Drawable drawable5 = progressBar.getIndeterminateDrawable();
                    int n5 = this.zzh;
                    if (n5 != 0 && drawable5 != null) {
                        drawable5.setColorFilter(n5, PorterDuff.Mode.SRC_IN);
                    }
                    relativeLayout.addView((View)progressBar);
                    uIMediaController.bindImageViewToPlayPauseToggle(imageView, drawable2, drawable3, drawable4, (View)progressBar, true);
                    return;
                }
                if (n2 == R.id.cast_button_type_skip_previous) {
                    imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzc(this.getContext(), this.zzi, this.zzs));
                    imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
                    uIMediaController.bindViewToSkipPrev((View)imageView, 0);
                    return;
                }
                if (n2 == R.id.cast_button_type_skip_next) {
                    imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzc(this.getContext(), this.zzi, this.zzt));
                    imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
                    uIMediaController.bindViewToSkipNext((View)imageView, 0);
                    return;
                }
                if (n2 == R.id.cast_button_type_rewind_30_seconds) {
                    imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzc(this.getContext(), this.zzi, this.zzu));
                    imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
                    uIMediaController.bindViewToRewind((View)imageView, 30000L);
                    return;
                }
                if (n2 == R.id.cast_button_type_forward_30_seconds) {
                    imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzc(this.getContext(), this.zzi, this.zzv));
                    imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
                    uIMediaController.bindViewToForward((View)imageView, 30000L);
                    return;
                }
                if (n2 == R.id.cast_button_type_mute_toggle) {
                    imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzc(this.getContext(), this.zzi, this.zzw));
                    uIMediaController.bindImageViewToMuteToggle(imageView);
                    return;
                }
                if (n2 == R.id.cast_button_type_closed_caption) break block13;
            }
            return;
        }
        imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzc(this.getContext(), this.zzi, this.zzx));
        uIMediaController.bindViewToClosedCaption((View)imageView);
    }
}

