/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.framework.media.NotificationActionsProvider;
import com.google.android.gms.cast.framework.media.zzaa;
import com.google.android.gms.cast.framework.media.zze;
import com.google.android.gms.cast.framework.media.zzg;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.cast.zzfh;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="NotificationOptionsCreator")
public class NotificationOptions
extends AbstractSafeParcelable {
    public static final long SKIP_STEP_TEN_SECONDS_IN_MS = 10000L;
    public static final long SKIP_STEP_THIRTY_SECONDS_IN_MS = 30000L;
    @NonNull
    public static final Parcelable.Creator<NotificationOptions> CREATOR;
    private static final zzfh zza;
    private static final int[] zzb;
    @SafeParcelable.Field(id=2, getter="getActions")
    private final List zzc;
    @SafeParcelable.Field(id=3, getter="getCompatActionIndices")
    private final int[] zzd;
    @SafeParcelable.Field(id=4, getter="getSkipStepMs")
    private final long zze;
    @SafeParcelable.Field(id=5, getter="getTargetActivityClassName")
    private final String zzf;
    @SafeParcelable.Field(id=6, getter="getSmallIconDrawableResId")
    private final int zzg;
    @SafeParcelable.Field(id=7, getter="getStopLiveStreamDrawableResId")
    private final int zzh;
    @SafeParcelable.Field(id=8, getter="getPauseDrawableResId")
    private final int zzi;
    @SafeParcelable.Field(id=9, getter="getPlayDrawableResId")
    private final int zzj;
    @SafeParcelable.Field(id=10, getter="getSkipNextDrawableResId")
    private final int zzk;
    @SafeParcelable.Field(id=11, getter="getSkipPrevDrawableResId")
    private final int zzl;
    @SafeParcelable.Field(id=12, getter="getForwardDrawableResId")
    private final int zzm;
    @SafeParcelable.Field(id=13, getter="getForward10DrawableResId")
    private final int zzn;
    @SafeParcelable.Field(id=14, getter="getForward30DrawableResId")
    private final int zzo;
    @SafeParcelable.Field(id=15, getter="getRewindDrawableResId")
    private final int zzp;
    @SafeParcelable.Field(id=16, getter="getRewind10DrawableResId")
    private final int zzq;
    @SafeParcelable.Field(id=17, getter="getRewind30DrawableResId")
    private final int zzr;
    @SafeParcelable.Field(id=18, getter="getDisconnectDrawableResId")
    private final int zzs;
    @SafeParcelable.Field(id=19, getter="getImageSizeDimenResId")
    private final int zzt;
    @SafeParcelable.Field(id=20, getter="getCastingToDeviceStringResId")
    private final int zzu;
    @SafeParcelable.Field(id=21, getter="getStopLiveStreamTitleResId")
    private final int zzv;
    @SafeParcelable.Field(id=22, getter="getPauseTitleResId")
    private final int zzw;
    @SafeParcelable.Field(id=23, getter="getPlayTitleResId")
    private final int zzx;
    @SafeParcelable.Field(id=24, getter="getSkipNextTitleResId")
    private final int zzy;
    @SafeParcelable.Field(id=25, getter="getSkipPrevTitleResId")
    private final int zzz;
    @SafeParcelable.Field(id=26, getter="getForwardTitleResId")
    private final int zzA;
    @SafeParcelable.Field(id=27, getter="getForward10TitleResId")
    private final int zzB;
    @SafeParcelable.Field(id=28, getter="getForward30TitleResId")
    private final int zzC;
    @SafeParcelable.Field(id=29, getter="getRewindTitleResId")
    private final int zzD;
    @SafeParcelable.Field(id=30, getter="getRewind10TitleResId")
    private final int zzE;
    @SafeParcelable.Field(id=31, getter="getRewind30TitleResId")
    private final int zzF;
    @SafeParcelable.Field(id=32, getter="getDisconnectTitleResId")
    private final int zzG;
    @SafeParcelable.Field(id=33, getter="getNotificationActionsProviderAsBinder", type="android.os.IBinder")
    @Nullable
    private final zzg zzH;
    @SafeParcelable.Field(id=34, getter="isSkipToPrevSlotReserved")
    private final boolean zzI;
    @SafeParcelable.Field(id=35, getter="isSkipToNextSlotReserved")
    private final boolean zzJ;

    public int getCastingToDeviceStringResId() {
        return this.zzu;
    }

    public int getDisconnectDrawableResId() {
        return this.zzs;
    }

    public int getForward10DrawableResId() {
        return this.zzn;
    }

    public int getForward30DrawableResId() {
        return this.zzo;
    }

    public int getForwardDrawableResId() {
        return this.zzm;
    }

    public int getPauseDrawableResId() {
        return this.zzi;
    }

    public int getPlayDrawableResId() {
        return this.zzj;
    }

    public int getRewind10DrawableResId() {
        return this.zzq;
    }

    public int getRewind30DrawableResId() {
        return this.zzr;
    }

    public int getRewindDrawableResId() {
        return this.zzp;
    }

    public int getSkipNextDrawableResId() {
        return this.zzk;
    }

    public int getSkipPrevDrawableResId() {
        return this.zzl;
    }

    public int getSmallIconDrawableResId() {
        return this.zzg;
    }

    public int getStopLiveStreamDrawableResId() {
        return this.zzh;
    }

    public int getStopLiveStreamTitleResId() {
        return this.zzv;
    }

    public long getSkipStepMs() {
        return this.zze;
    }

    @NonNull
    public String getTargetActivityClassName() {
        return this.zzf;
    }

    @NonNull
    public List<String> getActions() {
        return this.zzc;
    }

    static {
        zza = zzfh.zzk((Object)"com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK", (Object)"com.google.android.gms.cast.framework.action.STOP_CASTING");
        zzb = new int[]{0, 1};
        CREATOR = new zzaa();
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public NotificationOptions(@SafeParcelable.Param(id=2) @NonNull List object, @SafeParcelable.Param(id=3) @NonNull int[] nArray, @SafeParcelable.Param(id=4) long l, @SafeParcelable.Param(id=5) @NonNull String string2, @SafeParcelable.Param(id=6) int n, @SafeParcelable.Param(id=7) int n2, @SafeParcelable.Param(id=8) int n3, @SafeParcelable.Param(id=9) int n4, @SafeParcelable.Param(id=10) int n5, @SafeParcelable.Param(id=11) int n6, @SafeParcelable.Param(id=12) int n7, @SafeParcelable.Param(id=13) int n8, @SafeParcelable.Param(id=14) int n9, @SafeParcelable.Param(id=15) int n10, @SafeParcelable.Param(id=16) int n11, @SafeParcelable.Param(id=17) int n12, @SafeParcelable.Param(id=18) int n13, @SafeParcelable.Param(id=19) int n14, @SafeParcelable.Param(id=20) int n15, @SafeParcelable.Param(id=21) int n16, @SafeParcelable.Param(id=22) int n17, @SafeParcelable.Param(id=23) int n18, @SafeParcelable.Param(id=24) int n19, @SafeParcelable.Param(id=25) int n20, @SafeParcelable.Param(id=26) int n21, @SafeParcelable.Param(id=27) int n22, @SafeParcelable.Param(id=28) int n23, @SafeParcelable.Param(id=29) int n24, @SafeParcelable.Param(id=30) int n25, @SafeParcelable.Param(id=31) int n26, @SafeParcelable.Param(id=32) int n27, @SafeParcelable.Param(id=33) @Nullable IBinder iBinder, @SafeParcelable.Param(id=34) boolean bl, @SafeParcelable.Param(id=35) boolean bl2) {
        this.zzc = new ArrayList(object);
        this.zzd = Arrays.copyOf(nArray, nArray.length);
        this.zze = l;
        this.zzf = string2;
        this.zzg = n;
        this.zzh = n2;
        this.zzi = n3;
        this.zzj = n4;
        this.zzk = n5;
        this.zzl = n6;
        this.zzm = n7;
        this.zzn = n8;
        this.zzo = n9;
        this.zzp = n10;
        this.zzq = n11;
        this.zzr = n12;
        this.zzs = n13;
        this.zzt = n14;
        this.zzu = n15;
        this.zzv = n16;
        this.zzw = n17;
        this.zzx = n18;
        this.zzy = n19;
        this.zzz = n20;
        this.zzA = n21;
        this.zzB = n22;
        this.zzC = n23;
        this.zzD = n24;
        this.zzE = n25;
        this.zzF = n26;
        this.zzG = n27;
        this.zzI = bl;
        this.zzJ = bl2;
        if (iBinder == null) {
            this.zzH = null;
            return;
        }
        object = iBinder.queryLocalInterface("com.google.android.gms.cast.framework.media.INotificationActionsProvider");
        object = object instanceof zzg ? (zzg)object : new zze(iBinder);
        this.zzH = object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeStringList((Parcel)var1_1, (int)2, this.getActions(), (boolean)false);
        SafeParcelWriter.writeIntArray((Parcel)var1_1, (int)3, (int[])this.getCompatActionIndices(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)4, (long)this.getSkipStepMs());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getTargetActivityClassName(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)6, (int)this.getSmallIconDrawableResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)7, (int)this.getStopLiveStreamDrawableResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)8, (int)this.getPauseDrawableResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)9, (int)this.getPlayDrawableResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)10, (int)this.getSkipNextDrawableResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)11, (int)this.getSkipPrevDrawableResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)12, (int)this.getForwardDrawableResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)13, (int)this.getForward10DrawableResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)14, (int)this.getForward30DrawableResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)15, (int)this.getRewindDrawableResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)16, (int)this.getRewind10DrawableResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)17, (int)this.getRewind30DrawableResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)18, (int)this.getDisconnectDrawableResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)19, (int)this.zzt);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)20, (int)this.getCastingToDeviceStringResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)21, (int)this.getStopLiveStreamTitleResId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)22, (int)this.zzw);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)23, (int)this.zzx);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)24, (int)this.zzy);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)25, (int)this.zzz);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)26, (int)this.zzA);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)27, (int)this.zzB);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)28, (int)this.zzC);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)29, (int)this.zzD);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)30, (int)this.zzE);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)31, (int)this.zzF);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)32, (int)this.zzG);
        zzg zzg2 = this.zzH;
        zzg2 = zzg2 == null ? null : zzg2.asBinder();
        SafeParcelWriter.writeIBinder((Parcel)var1_1, (int)33, (IBinder)zzg2, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)34, (boolean)this.zzI);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)35, (boolean)this.zzJ);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n2);
    }

    @NonNull
    public int[] getCompatActionIndices() {
        return Arrays.copyOf(this.zzd, this.zzd.length);
    }

    public final int zza() {
        return this.zzG;
    }

    public final int zzb() {
        return this.zzB;
    }

    public final int zzc() {
        return this.zzC;
    }

    public final int zzd() {
        return this.zzA;
    }

    public final int zze() {
        return this.zzt;
    }

    public final int zzf() {
        return this.zzw;
    }

    public final int zzg() {
        return this.zzx;
    }

    public final int zzh() {
        return this.zzE;
    }

    public final int zzi() {
        return this.zzF;
    }

    public final int zzj() {
        return this.zzD;
    }

    public final int zzk() {
        return this.zzy;
    }

    public final int zzl() {
        return this.zzz;
    }

    @Nullable
    public final zzg zzm() {
        return this.zzH;
    }

    public final boolean zzo() {
        return this.zzJ;
    }

    public final boolean zzp() {
        return this.zzI;
    }

    public static final class Builder {
        private String zza;
        private List zzb = NotificationOptions.zzn();
        private NotificationActionsProvider zzc;
        private int[] zzd = NotificationOptions.zzq();
        private int zze = Builder.zza("smallIconDrawableResId");
        private int zzf = Builder.zza("stopLiveStreamDrawableResId");
        private int zzg = Builder.zza("pauseDrawableResId");
        private int zzh = Builder.zza("playDrawableResId");
        private int zzi = Builder.zza("skipNextDrawableResId");
        private int zzj = Builder.zza("skipPrevDrawableResId");
        private int zzk = Builder.zza("forwardDrawableResId");
        private int zzl = Builder.zza("forward10DrawableResId");
        private int zzm = Builder.zza("forward30DrawableResId");
        private int zzn = Builder.zza("rewindDrawableResId");
        private int zzo = Builder.zza("rewind10DrawableResId");
        private int zzp = Builder.zza("rewind30DrawableResId");
        private int zzq = Builder.zza("disconnectDrawableResId");
        private long zzr = 10000L;
        private boolean zzs;
        private boolean zzt;

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder setActions(@Nullable List<String> actions, @Nullable int[] compatActionIndices) {
            void var1_1;
            void var2_2;
            if (actions == null && var2_2 != null) throw new IllegalArgumentException("When setting actions to null, you must also set compatActionIndices to null.");
            if (var1_1 != null && var2_2 == null) throw new IllegalArgumentException("When setting compatActionIndices to null, you must also set actions to null.");
            if (var1_1 != null && var2_2 != null) {
                Object[] objectArray;
                int n = ((void)var2_2).length;
                int n2 = var1_1.size();
                if (n <= n2) {
                    for (int i = 0; i < n; ++i) {
                        void var6_6 = var2_2[i];
                        if (var6_6 >= 0 && var6_6 < n2) continue;
                        objectArray = new Object[]{(int)var6_6, n2 + -1};
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "Index %d in compatActionIndices out of range: [0, %d]", objectArray));
                    }
                    objectArray.zzb = new ArrayList(var1_1);
                    void v0 = var2_2;
                    objectArray.zzd = Arrays.copyOf((int[])v0, ((void)v0).length);
                    return objectArray;
                }
                objectArray = new Object[]{n, n2};
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid number of compat actions: %d > %d.", objectArray));
            }
            objectArray.zzb = zza;
            objectArray.zzd = zzb;
            return objectArray;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setDisconnectDrawableResId(int resId) {
            void var1_1;
            this.zzq = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setForward10DrawableResId(int resId) {
            void var1_1;
            this.zzl = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setForward30DrawableResId(int resId) {
            void var1_1;
            this.zzm = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setForwardDrawableResId(int resId) {
            void var1_1;
            this.zzk = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setNotificationActionsProvider(@NonNull NotificationActionsProvider notificationActionsProvider) {
            void var1_1;
            if (notificationActionsProvider == null) {
                throw new IllegalArgumentException("notificationActionsProvider cannot be null.");
            }
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPauseDrawableResId(int resId) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPlayDrawableResId(int resId) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRewind10DrawableResId(int resId) {
            void var1_1;
            this.zzo = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRewind30DrawableResId(int resId) {
            void var1_1;
            this.zzp = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRewindDrawableResId(int resId) {
            void var1_1;
            this.zzn = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setSkipNextDrawableResId(int resId) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setSkipPrevDrawableResId(int resId) {
            void var1_1;
            this.zzj = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setSkipStepMs(long notificationSkipStepMs) {
            void var1_1;
            boolean bl = notificationSkipStepMs > 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"skipStepMs must be positive.");
            this.zzr = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setSkipToNextSlotReserved(boolean skipToNextSlotReserved) {
            void var1_1;
            this.zzt = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setSkipToPrevSlotReserved(boolean skipToPrevSlotReserved) {
            void var1_1;
            this.zzs = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setSmallIconDrawableResId(int resId) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setStopLiveStreamDrawableResId(int resId) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTargetActivityClassName(@NonNull String className) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public NotificationOptions build() {
            Object object = this.zzc;
            object = object == null ? null : ((NotificationActionsProvider)object).zza();
            String string2 = "disconnectStringResId";
            String string3 = "rewind30StringResId";
            String string4 = "rewind10StringResId";
            String string5 = "rewindStringResId";
            String string6 = "forward30StringResId";
            String string7 = "forward10StringResId";
            String string8 = "forwardStringResId";
            String string9 = "skipPrevStringResId";
            String string10 = "skipNextStringResId";
            String string11 = "playStringResId";
            String string12 = "pauseStringResId";
            String string13 = "stopLiveStreamStringResId";
            String string14 = "castingToDeviceStringResId";
            return new NotificationOptions(this.zzb, this.zzd, this.zzr, this.zza, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk, this.zzl, this.zzm, this.zzn, this.zzo, this.zzp, this.zzq, Builder.zza("notificationImageSizeDimenResId"), Builder.zza(string14), Builder.zza(string13), Builder.zza(string12), Builder.zza(string11), Builder.zza(string10), Builder.zza(string9), Builder.zza(string8), Builder.zza(string7), Builder.zza(string6), Builder.zza(string5), Builder.zza(string4), Builder.zza(string3), Builder.zza(string2), (IBinder)object, this.zzs, this.zzt);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static int zza(String object) {
            block6: {
                object = (Integer)Class.forName("com.google.android.gms.cast.framework.media.internal.ResourceProvider").getMethod("findResourceByName", String.class).invoke(null, object);
                if (object != null) break block6;
                return 0;
            }
            try {
                return (Integer)object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return 0;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return 0;
            }
            catch (IllegalAccessException illegalAccessException) {
                return 0;
            }
            catch (InvocationTargetException invocationTargetException) {
                return 0;
            }
        }
    }
}

