/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Handler;
import android.os.Looper;
import android.util.LruCache;
import android.util.SparseIntArray;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.zzo;
import com.google.android.gms.cast.framework.media.zzp;
import com.google.android.gms.cast.framework.media.zzq;
import com.google.android.gms.cast.framework.media.zzr;
import com.google.android.gms.cast.framework.media.zzs;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzdy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;

@MainThread
public class MediaQueue {
    private final Logger zzg;
    @VisibleForTesting
    long zza;
    private final RemoteMediaClient zzh;
    @VisibleForTesting
    List zzb;
    @VisibleForTesting
    final SparseIntArray zzc;
    @VisibleForTesting
    LruCache zzd;
    @VisibleForTesting
    final List zze;
    @VisibleForTesting
    final Deque zzf;
    private final int zzi;
    private final Handler zzj;
    private final TimerTask zzk;
    @Nullable
    private PendingResult zzl;
    @Nullable
    private PendingResult zzm;
    private final Set zzn = Collections.synchronizedSet(new HashSet());

    public int getItemCount() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzb.size();
    }

    /*
     * WARNING - void declaration
     */
    public int indexOfItemWithId(int itemId) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzc.get((int)var1_1, -1);
    }

    /*
     * WARNING - void declaration
     */
    public int itemIdAtIndex(int index) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 >= 0 && var1_1 < this.zzb.size()) {
            return (Integer)this.zzb.get((int)var1_1);
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public MediaQueueItem getItemAtIndex(int index) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.getItemAtIndex((int)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public MediaQueueItem getItemAtIndex(int index, boolean fetchIfNeeded) {
        void var2_2;
        int n;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (n < 0 || n >= this.zzb.size()) {
            return null;
        }
        Integer n2 = n = ((Integer)this.zzb.get(n)).intValue();
        MediaQueueItem mediaQueueItem = (MediaQueueItem)this.zzd.get((Object)n2);
        if (mediaQueueItem == null && var2_2 != false && !this.zzf.contains(n2)) {
            while (this.zzf.size() >= this.zzi) {
                this.zzf.removeFirst();
            }
            this.zzf.add(n);
            this.zzy();
        }
        return mediaQueueItem;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<RemoteMediaClient.MediaChannelResult> fetchMoreItemsRelativeToIndex(int index, int nextCount, int prevCount) {
        void var3_3;
        void var2_2;
        int n;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (this.zza == 0L) {
            return RemoteMediaClient.zzf(2100, "No active media session");
        }
        if ((n = this.itemIdAtIndex(n)) == 0) {
            return RemoteMediaClient.zzf(2001, "index out of bound");
        }
        return this.zzh.zzh(n, (int)var2_2, (int)var3_3);
    }

    @VisibleForTesting
    MediaQueue(RemoteMediaClient remoteMediaClient, int n, int n2) {
        this.zzg = new Logger("MediaQueue");
        this.zzh = remoteMediaClient;
        this.zzi = Math.max(20, 1);
        this.zzb = new ArrayList();
        this.zzc = new SparseIntArray();
        this.zze = new ArrayList();
        this.zzf = new ArrayDeque(20);
        this.zzj = new zzdy(Looper.getMainLooper());
        this.zzk = new zzq(this);
        remoteMediaClient.registerCallback(new zzs(this));
        this.zzt(20);
        this.zza = this.zzp();
        this.zzo();
    }

    /*
     * WARNING - void declaration
     */
    public void registerCallback(@NonNull Callback callback) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        this.zzn.add(var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void setCacheCapacity(int capacity) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        LruCache lruCache = this.zzd;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.zzt((int)var1_1);
        Iterator iterator = lruCache.snapshot().entrySet().iterator();
        int n = lruCache.size();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (n > var1_1) {
                int n2 = this.zzc.get(((Integer)entry.getKey()).intValue(), -1);
                if (n2 != -1) {
                    arrayList.add(n2);
                }
            } else {
                this.zzd.put((Object)((Integer)entry.getKey()), (Object)((MediaQueueItem)entry.getValue()));
            }
            --n;
        }
        if (arrayList.isEmpty()) {
            return;
        }
        Collections.sort(arrayList);
        this.zzx();
        this.zzw(CastUtils.zzf(arrayList));
        this.zzu();
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterCallback(@NonNull Callback callback) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        this.zzn.remove(var1_1);
    }

    @NonNull
    public int[] getItemIds() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return CastUtils.zzf((Collection)this.zzb);
    }

    static /* bridge */ /* synthetic */ long zza(MediaQueue mediaQueue) {
        return mediaQueue.zzp();
    }

    private final long zzp() {
        MediaQueue mediaQueue = mediaQueue.zzh.getMediaStatus();
        if (mediaQueue == null || mediaQueue.zzd()) {
            return 0L;
        }
        return mediaQueue.zzb();
    }

    static /* bridge */ /* synthetic */ Logger zzb(MediaQueue mediaQueue) {
        return mediaQueue.zzg;
    }

    static /* bridge */ /* synthetic */ void zzc(MediaQueue mediaQueue) {
        mediaQueue.zzu();
    }

    static /* bridge */ /* synthetic */ void zzd(MediaQueue mediaQueue) {
        mediaQueue.zzv();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ void zze(MediaQueue object, int n, int n2) {
        Set set = ((MediaQueue)object).zzn;
        synchronized (set) {
            boolean bl;
            object = ((MediaQueue)object).zzn.iterator();
            while (bl = object.hasNext()) {
                ((Callback)object.next()).itemsInsertedInRange(n, n2);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ void zzf(MediaQueue object, int[] nArray) {
        Set set = ((MediaQueue)object).zzn;
        synchronized (set) {
            boolean bl;
            object = ((MediaQueue)object).zzn.iterator();
            while (bl = object.hasNext()) {
                ((Callback)object.next()).itemsRemovedAtIndexes(nArray);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ void zzg(MediaQueue object, List list, int n) {
        Set set = ((MediaQueue)object).zzn;
        synchronized (set) {
            boolean bl;
            object = ((MediaQueue)object).zzn.iterator();
            while (bl = object.hasNext()) {
                ((Callback)object.next()).itemsReorderedAtIndexes(list, n);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    static /* bridge */ /* synthetic */ void zzh(MediaQueue mediaQueue, int[] nArray) {
        mediaQueue.zzw(nArray);
    }

    static /* bridge */ /* synthetic */ void zzi(MediaQueue mediaQueue) {
        mediaQueue.zzx();
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzj(MediaQueue mediaQueue) {
        if (mediaQueue.zzf.isEmpty() || mediaQueue.zzl != null || mediaQueue.zza == 0L) {
            return;
        }
        mediaQueue.zzl = mediaQueue.zzh.zzj(CastUtils.zzf((Collection)mediaQueue.zzf));
        mediaQueue.zzl.setResultCallback((ResultCallback)new zzp(mediaQueue));
        mediaQueue.zzf.clear();
    }

    static /* bridge */ /* synthetic */ void zzk(MediaQueue mediaQueue) {
        mediaQueue.zzc.clear();
        for (int i = 0; i < mediaQueue.zzb.size(); ++i) {
            int n = (Integer)mediaQueue.zzb.get(i);
            mediaQueue.zzc.put(n, i);
        }
    }

    private final void zzq() {
        this.zzj.removeCallbacks((Runnable)this.zzk);
    }

    private final void zzr() {
        PendingResult pendingResult = this.zzm;
        if (pendingResult != null) {
            pendingResult.cancel();
            this.zzm = null;
            return;
        }
    }

    private final void zzs() {
        PendingResult pendingResult = this.zzl;
        if (pendingResult != null) {
            pendingResult.cancel();
            this.zzl = null;
            return;
        }
    }

    public final void zzl() {
        this.zzx();
        this.zzb.clear();
        this.zzc.clear();
        this.zzd.evictAll();
        this.zze.clear();
        this.zzq();
        this.zzf.clear();
        this.zzr();
        this.zzs();
        this.zzv();
        this.zzu();
    }

    private final void zzt(int n) {
        this.zzd = new zzr(this, n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzu() {
        Set set = ((MediaQueue)((Object)iterator)).zzn;
        synchronized (set) {
            boolean bl;
            Iterator iterator = ((MediaQueue)((Object)iterator)).zzn.iterator();
            while (bl = iterator.hasNext()) {
                ((Callback)iterator.next()).mediaQueueChanged();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzv() {
        Set set = ((MediaQueue)((Object)iterator)).zzn;
        synchronized (set) {
            boolean bl;
            Iterator iterator = ((MediaQueue)((Object)iterator)).zzn.iterator();
            while (bl = iterator.hasNext()) {
                ((Callback)iterator.next()).itemsReloaded();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzw(int[] nArray) {
        Set set = ((MediaQueue)((Object)iterator)).zzn;
        synchronized (set) {
            boolean bl;
            Iterator iterator = ((MediaQueue)((Object)iterator)).zzn.iterator();
            while (bl = iterator.hasNext()) {
                ((Callback)iterator.next()).itemsUpdatedAtIndexes(nArray);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzx() {
        Set set = ((MediaQueue)((Object)iterator)).zzn;
        synchronized (set) {
            boolean bl;
            Iterator iterator = ((MediaQueue)((Object)iterator)).zzn.iterator();
            while (bl = iterator.hasNext()) {
                ((Callback)iterator.next()).mediaQueueWillChange();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @VisibleForTesting
    final void zzm(RemoteMediaClient.MediaChannelResult mediaChannelResult) {
        int n = (mediaChannelResult = mediaChannelResult.getStatus()).getStatusCode();
        if (n != 0) {
            Object[] objectArray = new Object[]{n, mediaChannelResult.getStatusMessage()};
            this.zzg.w(String.format("Error fetching queue item ids, statusCode=%s, statusMessage=%s", objectArray), new Object[0]);
        }
        this.zzm = null;
        if (!this.zzf.isEmpty()) {
            this.zzy();
            return;
        }
    }

    @VisibleForTesting
    final void zzn(RemoteMediaClient.MediaChannelResult mediaChannelResult) {
        int n = (mediaChannelResult = mediaChannelResult.getStatus()).getStatusCode();
        if (n != 0) {
            Object[] objectArray = new Object[]{n, mediaChannelResult.getStatusMessage()};
            this.zzg.w(String.format("Error fetching queue items, statusCode=%s, statusMessage=%s", objectArray), new Object[0]);
        }
        this.zzl = null;
        if (!this.zzf.isEmpty()) {
            this.zzy();
            return;
        }
    }

    @VisibleForTesting
    public final void zzo() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (this.zza == 0L) {
            return;
        }
        if (this.zzm != null) {
            return;
        }
        this.zzr();
        this.zzs();
        this.zzm = this.zzh.zzi();
        this.zzm.setResultCallback((ResultCallback)new zzo(this));
    }

    private final void zzy() {
        this.zzq();
        this.zzj.postDelayed((Runnable)this.zzk, 500L);
    }

    public static abstract class Callback {
        public void itemsInsertedInRange(int n, int n2) {
        }

        public void itemsReloaded() {
        }

        public void itemsRemovedAtIndexes(@NonNull int[] nArray) {
        }

        public void itemsReorderedAtIndexes(@NonNull List<Integer> list, int n) {
        }

        public void itemsUpdatedAtIndexes(@NonNull int[] nArray) {
        }

        public void mediaQueueChanged() {
        }

        public void mediaQueueWillChange() {
        }
    }
}

