/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.IBinder;
import android.os.Parcelable;
import android.support.v4.media.session.MediaSessionCompat;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.app.TaskStackBuilder;
import androidx.media.app.NotificationCompat;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.NotificationAction;
import com.google.android.gms.cast.framework.media.NotificationActionsProvider;
import com.google.android.gms.cast.framework.media.NotificationOptions;
import com.google.android.gms.cast.framework.media.internal.zzb;
import com.google.android.gms.cast.framework.media.internal.zzw;
import com.google.android.gms.cast.framework.media.zzg;
import com.google.android.gms.cast.framework.media.zzk;
import com.google.android.gms.cast.framework.media.zzl;
import com.google.android.gms.cast.framework.media.zzm;
import com.google.android.gms.cast.framework.media.zzn;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.cast.zzdx;
import com.google.android.gms.internal.cast.zzln;
import com.google.android.gms.internal.cast.zzr;
import java.util.ArrayList;
import java.util.List;

public class MediaNotificationService
extends Service {
    @NonNull
    public static final String ACTION_UPDATE_NOTIFICATION = "com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION";
    private static final Logger zza = new Logger("MediaNotificationService");
    @Nullable
    private static Runnable zzb;
    private NotificationOptions zzc;
    @Nullable
    private ImagePicker zzd;
    private ComponentName zze;
    @Nullable
    private ComponentName zzf;
    private List zzg = new ArrayList();
    @Nullable
    private int[] zzh;
    private long zzi;
    private zzb zzj;
    private ImageHints zzk;
    private Resources zzl;
    private zzm zzm;
    private zzn zzn;
    private NotificationManager zzo;
    private Notification zzp;
    private CastContext zzq;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public int onStartCommand(@NonNull Intent intent, int n, int startId) {
        void var3_6;
        Object object;
        MediaInfo mediaInfo = (MediaInfo)Preconditions.checkNotNull((Object)((MediaInfo)intent.getParcelableExtra("extra_media_info")));
        MediaMetadata mediaMetadata = (MediaMetadata)Preconditions.checkNotNull((Object)mediaInfo.getMetadata());
        Object object2 = "extra_cast_device";
        CastDevice castDevice = (CastDevice)Preconditions.checkNotNull((Object)((CastDevice)object.getParcelableExtra((String)object2)));
        int n2 = mediaInfo.getStreamType();
        String string2 = mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE");
        String string3 = castDevice.getFriendlyName();
        MediaSessionCompat.Token token = (MediaSessionCompat.Token)object.getParcelableExtra("extra_media_session_token");
        boolean bl = object.getIntExtra("extra_remote_media_client_player_state", 0) == 2;
        object2 = new zzm(bl, n2, string2, string3, token, object.getBooleanExtra("extra_can_skip_next", false), object.getBooleanExtra("extra_can_skip_prev", false));
        if (object.getBooleanExtra("extra_media_notification_force_update", false) || (object = this.zzm) == null || ((zzm)object2).zzb != ((zzm)object).zzb || ((zzm)object2).zzc != ((zzm)object).zzc || !CastUtils.zze((Object)((zzm)object2).zzd, (Object)((zzm)object).zzd) || !CastUtils.zze((Object)((zzm)object2).zze, (Object)((zzm)object).zze) || ((zzm)object2).zzf != ((zzm)object).zzf || ((zzm)object2).zzg != ((zzm)object).zzg) {
            this.zzm = object2;
            this.zzd();
        }
        object = (object = this.zzd) != null ? ((ImagePicker)object).onPickImage(mediaMetadata, this.zzk) : (mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null);
        zzn zzn2 = new zzn((WebImage)object);
        object = this.zzn;
        if (object == null || !CastUtils.zze((Object)zzn2.zza, (Object)((zzn)object).zza)) {
            this.zzj.zzc(new zzl(this, zzn2));
            this.zzj.zzd(zzn2.zza);
        }
        MediaNotificationService mediaNotificationService = this;
        mediaNotificationService.startForeground(1, mediaNotificationService.zzp);
        zzb = new zzk(this, (int)var3_6);
        return 2;
    }

    @Nullable
    public IBinder onBind(@NonNull Intent intent) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onCreate() {
        int n;
        this.zzo = (NotificationManager)this.getSystemService("notification");
        this.zzq = CastContext.getSharedInstance((Context)this);
        CastMediaOptions castMediaOptions = (CastMediaOptions)((Object)Preconditions.checkNotNull((Object)((Object)this.zzq.getCastOptions().getCastMediaOptions())));
        this.zzc = (NotificationOptions)((Object)Preconditions.checkNotNull((Object)((Object)castMediaOptions.getNotificationOptions())));
        this.zzd = castMediaOptions.getImagePicker();
        this.zzl = this.getResources();
        this.zze = new ComponentName(this.getApplicationContext(), castMediaOptions.getMediaIntentReceiverClassName());
        this.zzf = !TextUtils.isEmpty((CharSequence)this.zzc.getTargetActivityClassName()) ? new ComponentName(this.getApplicationContext(), this.zzc.getTargetActivityClassName()) : null;
        this.zzi = this.zzc.getSkipStepMs();
        int n2 = n = this.zzl.getDimensionPixelSize(this.zzc.zze());
        this.zzk = new ImageHints(1, n2, n2);
        this.zzj = new zzb(this.getApplicationContext(), this.zzk);
        if (PlatformVersion.isAtLeastO()) {
            String string2 = this.getResources().getString(R.string.media_notification_channel_name);
            NotificationChannel notificationChannel = new NotificationChannel("cast_media_notification", (CharSequence)string2, 2);
            notificationChannel.setShowBadge(false);
            this.zzo.createNotificationChannel(notificationChannel);
        }
        zzr.zzd(zzln.zzX);
    }

    public void onDestroy() {
        zzb zzb2 = this.zzj;
        if (zzb2 != null) {
            zzb2.zza();
        }
        zzb = null;
        this.zzo.cancel(1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static boolean isNotificationOptionsValid(@NonNull CastOptions options) {
        int n;
        CastMediaOptions castMediaOptions = options.getCastMediaOptions();
        if (castMediaOptions == null) {
            return false;
        }
        NotificationOptions notificationOptions = castMediaOptions.getNotificationOptions();
        if (notificationOptions == null) {
            return false;
        }
        zzg zzg2 = notificationOptions.zzm();
        if (zzg2 == null) {
            return true;
        }
        List list = zzw.zzf(zzg2);
        int[] nArray = zzw.zzg(zzg2);
        if (list == null) {
            boolean bl = false;
        } else {
            int n2 = list.size();
        }
        if (list == null || list.isEmpty()) {
            Class<NotificationActionsProvider> clazz = NotificationActionsProvider.class;
            Object[] objectArray = new Object[]{};
            zza.e(String.valueOf(clazz.getSimpleName()).concat(" doesn't provide any action."), objectArray);
            return false;
        }
        if (list.size() > 5) {
            Class<NotificationActionsProvider> clazz = NotificationActionsProvider.class;
            Object[] objectArray = new Object[]{};
            zza.e(String.valueOf(clazz.getSimpleName()).concat(" provides more than 5 actions."), objectArray);
            return false;
        }
        if (nArray == null || (n = nArray.length) == 0) {
            Class<NotificationActionsProvider> clazz = NotificationActionsProvider.class;
            Object[] objectArray = new Object[]{};
            zza.e(String.valueOf(clazz.getSimpleName()).concat(" doesn't provide any actions for compact view."), objectArray);
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            void var0_5;
            int n4 = nArray[n3];
            if (n4 < 0 || n4 >= var0_5) {
                Class<NotificationActionsProvider> clazz = NotificationActionsProvider.class;
                Object[] objectArray = new Object[]{};
                zza.e(String.valueOf(clazz.getSimpleName()).concat("provides a compact view action whose index is out of bounds."), objectArray);
                return false;
            }
            ++n3;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    private final NotificationCompat.Action zzc(String var1_1) {
        switch (var1_1.hashCode()) lbl-1000:
        // 7 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    var2_3 = -1;
lbl5:
                    // 8 sources

                    while (true) {
                        switch (var2_3) {
                            case 5: {
                                v0 = new Intent("com.google.android.gms.cast.framework.action.STOP_CASTING");
                                v0.setComponent(this /* !! */ .zze);
                                var1_1 = PendingIntent.getBroadcast((Context)this /* !! */ , (int)0, (Intent)v0, (int)zzdx.zza);
                                return new NotificationCompat.Action.Builder(this /* !! */ .zzc.getDisconnectDrawableResId(), (CharSequence)this /* !! */ .zzl.getString(this /* !! */ .zzc.zza()), (PendingIntent)var1_1).build();
                            }
                            case 6: {
                                v1 = new Intent("com.google.android.gms.cast.framework.action.DISCONNECT");
                                v1.setComponent(this /* !! */ .zze);
                                var1_1 = PendingIntent.getBroadcast((Context)this /* !! */ , (int)0, (Intent)v1, (int)zzdx.zza);
                                this /* !! */  = "";
                                return new NotificationCompat.Action.Builder(this /* !! */ .zzc.getDisconnectDrawableResId(), (CharSequence)this /* !! */ .zzl.getString(this /* !! */ .zzc.zza(), new Object[]{this /* !! */ }), (PendingIntent)var1_1).build();
                            }
                            case 4: {
                                var3_4 = this /* !! */ .zzi;
                                v2 = new Intent("com.google.android.gms.cast.framework.action.REWIND");
                                v2.setComponent(this /* !! */ .zze);
                                v2.putExtra("googlecast-extra_skip_step_ms", var3_4);
                                var1_1 = PendingIntent.getBroadcast((Context)this /* !! */ , (int)0, (Intent)v2, (int)(zzdx.zza | 0x8000000));
                                var2_3 = zzw.zzc(this /* !! */ .zzc, var3_4);
                                var5_6 = zzw.zzd(this /* !! */ .zzc, var3_4);
                                return new NotificationCompat.Action.Builder(var2_3, (CharSequence)this /* !! */ .zzl.getString(var5_6), (PendingIntent)var1_1).build();
                            }
                            case 3: {
                                var3_5 = this /* !! */ .zzi;
                                v3 = new Intent("com.google.android.gms.cast.framework.action.FORWARD");
                                v3.setComponent(this /* !! */ .zze);
                                v3.putExtra("googlecast-extra_skip_step_ms", var3_5);
                                var1_1 = PendingIntent.getBroadcast((Context)this /* !! */ , (int)0, (Intent)v3, (int)(zzdx.zza | 0x8000000));
                                var2_3 = zzw.zza(this /* !! */ .zzc, var3_5);
                                var5_7 = zzw.zzb(this /* !! */ .zzc, var3_5);
                                return new NotificationCompat.Action.Builder(var2_3, (CharSequence)this /* !! */ .zzl.getString(var5_7), (PendingIntent)var1_1).build();
                            }
                            case 2: {
                                if (this /* !! */ .zzm.zzg) {
                                    v4 = new Intent("com.google.android.gms.cast.framework.action.SKIP_PREV");
                                    v4.setComponent(this /* !! */ .zze);
                                    var1_1 = PendingIntent.getBroadcast((Context)this /* !! */ , (int)0, (Intent)v4, (int)zzdx.zza);
lbl48:
                                    // 2 sources

                                    return new NotificationCompat.Action.Builder(this /* !! */ .zzc.getSkipPrevDrawableResId(), (CharSequence)this /* !! */ .zzl.getString(this /* !! */ .zzc.zzl()), (PendingIntent)var1_1).build();
                                }
                                var1_1 = null;
                                ** continue;
                            }
                            case 1: {
                                if (this /* !! */ .zzm.zzf) {
                                    v5 = new Intent("com.google.android.gms.cast.framework.action.SKIP_NEXT");
                                    v5.setComponent(this /* !! */ .zze);
                                    var1_1 = PendingIntent.getBroadcast((Context)this /* !! */ , (int)0, (Intent)v5, (int)zzdx.zza);
lbl58:
                                    // 2 sources

                                    return new NotificationCompat.Action.Builder(this /* !! */ .zzc.getSkipNextDrawableResId(), (CharSequence)this /* !! */ .zzl.getString(this /* !! */ .zzc.zzk()), (PendingIntent)var1_1).build();
                                }
                                var1_1 = null;
                                ** continue;
                            }
                            case 0: {
                                var1_1 = this /* !! */ .zzm;
                                var5_8 = var1_1.zzb;
                                if (var1_1.zzc == 2) {
                                    var1_2 = this /* !! */ .zzc.getStopLiveStreamDrawableResId();
                                    var2_3 = this /* !! */ .zzc.getStopLiveStreamTitleResId();
lbl68:
                                    // 2 sources

                                    while (true) {
                                        if (!var5_8) {
                                            var1_2 = this /* !! */ .zzc.getPlayDrawableResId();
                                        }
                                        if (!var5_8) {
                                            var2_3 = this /* !! */ .zzc.zzg();
                                        }
                                        v6 = new Intent("com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK");
                                        v6.setComponent(this /* !! */ .zze);
                                        var5_9 = PendingIntent.getBroadcast((Context)this /* !! */ , (int)0, (Intent)v6, (int)zzdx.zza);
                                        return new NotificationCompat.Action.Builder(var1_2, (CharSequence)this /* !! */ .zzl.getString(var2_3), var5_9).build();
                                    }
                                }
                                var1_2 = this /* !! */ .zzc.getPauseDrawableResId();
                                var2_3 = this /* !! */ .zzc.zzf();
                                ** continue;
                            }
                        }
                        this /* !! */  = new Object[]{var1_1};
                        MediaNotificationService.zza.e("Action: %s is not a pre-defined action.", this /* !! */ );
                        return null;
                    }
                    break;
                }
            }
            case 1362116196: {
                if (!var1_1.equals("com.google.android.gms.cast.framework.action.FORWARD")) ** GOTO lbl-1000
                var2_3 = 3;
                ** GOTO lbl5
            }
            case 235550565: {
                if (!var1_1.equals("com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK")) ** GOTO lbl-1000
                var2_3 = 0;
                ** GOTO lbl5
            }
            case -124479363: {
                if (!var1_1.equals("com.google.android.gms.cast.framework.action.DISCONNECT")) ** GOTO lbl-1000
                var2_3 = 6;
                ** GOTO lbl5
            }
            case -668151673: {
                if (!var1_1.equals("com.google.android.gms.cast.framework.action.STOP_CASTING")) ** GOTO lbl-1000
                var2_3 = 5;
                ** GOTO lbl5
            }
            case -945080078: {
                if (!var1_1.equals("com.google.android.gms.cast.framework.action.SKIP_PREV")) ** GOTO lbl-1000
                var2_3 = 2;
                ** GOTO lbl5
            }
            case -945151566: {
                if (!var1_1.equals("com.google.android.gms.cast.framework.action.SKIP_NEXT")) ** GOTO lbl-1000
                var2_3 = 1;
                ** GOTO lbl5
            }
            case -1699820260: 
        }
        ** while (!var1_1.equals((Object)"com.google.android.gms.cast.framework.action.REWIND"))
lbl110:
        // 1 sources

        var2_3 = 4;
        ** while (true)
    }

    static /* bridge */ /* synthetic */ void zza(MediaNotificationService mediaNotificationService, zzn zzn2) {
        mediaNotificationService.zzn = zzn2;
    }

    static /* bridge */ /* synthetic */ void zzb(MediaNotificationService mediaNotificationService) {
        mediaNotificationService.zzd();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void zzd() {
        block14: {
            if (this.zzm == null) {
                return;
            }
            var1_1 /* !! */  = this.zzn;
            if (var1_1 /* !! */  != null) break block14;
            var1_1 /* !! */  = null;
lbl6:
            // 2 sources

            while (true) {
                block15: {
                    var2_2 = "cast_media_notification";
                    var2_2 = new NotificationCompat.Builder((Context)this, var2_2).setLargeIcon((Bitmap)var1_1 /* !! */ ).setSmallIcon(this.zzc.getSmallIconDrawableResId()).setContentTitle((CharSequence)this.zzm.zzd).setContentText((CharSequence)this.zzl.getString(this.zzc.getCastingToDeviceStringResId(), new Object[]{this.zzm.zze})).setOngoing(true).setShowWhen(false).setVisibility(1);
                    var1_1 /* !! */  = this.zzf;
                    if (var1_1 /* !! */  != null) break block15;
                    var1_1 /* !! */  = null;
lbl12:
                    // 2 sources

                    while (true) {
                        block16: {
                            block17: {
                                if (var1_1 /* !! */  != null) {
                                    var2_2.setContentIntent((PendingIntent)var1_1 /* !! */ );
                                }
                                if ((var3_3 /* !! */  = this.zzc.zzm()) == null) break block16;
                                var1_1 /* !! */  = new Object[]{};
                                MediaNotificationService.zza.i("actionsProvider != null", (Object[])var1_1 /* !! */ );
                                var1_1 /* !! */  = (ComponentName)zzw.zzg((zzg)var3_3 /* !! */ );
                                if (var1_1 /* !! */  != null) break block17;
                                var1_1 /* !! */  = null;
lbl22:
                                // 2 sources

                                while (true) {
                                    this.zzh = (int[])var1_1 /* !! */ ;
                                    var1_1 /* !! */  = zzw.zzf((zzg)var3_3 /* !! */ );
                                    this.zzg = new ArrayList<E>();
                                    if (var1_1 /* !! */  == null) lbl-1000:
                                    // 3 sources

                                    {
                                        while (true) {
                                            var1_1 /* !! */  = this.zzg.iterator();
                                            while (var1_1 /* !! */ .hasNext()) {
                                                var2_2.addAction((NotificationCompat.Action)var1_1 /* !! */ .next());
                                            }
                                            if (Build.VERSION.SDK_INT >= 21) {
                                                var1_1 /* !! */  = new NotificationCompat.MediaStyle();
                                                var3_3 /* !! */  = (Intent)this.zzh;
                                                if (var3_3 /* !! */  != null) {
                                                    var1_1 /* !! */ .setShowActionsInCompactView((int[])var3_3 /* !! */ );
                                                }
                                                if ((var3_3 /* !! */  = this.zzm.zza) != null) {
                                                    var1_1 /* !! */ .setMediaSession((MediaSessionCompat.Token)var3_3 /* !! */ );
                                                }
                                                var2_2.setStyle((NotificationCompat.Style)var1_1 /* !! */ );
                                            }
                                            this.zzp = var2_2.build();
                                            v0 = this;
                                            v0.startForeground(1, v0.zzp);
                                            return;
                                        }
                                    }
                                    var3_3 /* !! */  = var1_1 /* !! */ .iterator();
                                    block5: while (true) {
                                        if (!var3_3 /* !! */ .hasNext()) ** GOTO lbl-1000
                                        var1_1 /* !! */  = (NotificationAction)var3_3 /* !! */ .next();
                                        var4_4 = var1_1 /* !! */ .getAction();
                                        if (!var4_4.equals("com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK") && !var4_4.equals("com.google.android.gms.cast.framework.action.SKIP_NEXT") && !var4_4.equals("com.google.android.gms.cast.framework.action.SKIP_PREV") && !var4_4.equals("com.google.android.gms.cast.framework.action.FORWARD") && !var4_4.equals("com.google.android.gms.cast.framework.action.REWIND") && !var4_4.equals("com.google.android.gms.cast.framework.action.STOP_CASTING") && !var4_4.equals("com.google.android.gms.cast.framework.action.DISCONNECT")) break;
                                        var1_1 /* !! */  = this.zzc(var1_1 /* !! */ .getAction());
lbl55:
                                        // 2 sources

                                        while (true) {
                                            if (var1_1 /* !! */  == null) continue block5;
                                            this.zzg.add(var1_1 /* !! */ );
                                            continue block5;
                                            break;
                                        }
                                        break;
                                    }
                                    v1 = new Intent(var1_1 /* !! */ .getAction());
                                    v1.setComponent(this.zze);
                                    var4_4 = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)v1, (int)zzdx.zza);
                                    var1_1 /* !! */  = new NotificationCompat.Action.Builder(var1_1 /* !! */ .getIconResId(), (CharSequence)var1_1 /* !! */ .getContentDescription(), (PendingIntent)var4_4).build();
                                    ** continue;
                                    break;
                                }
                            }
                            var1_1 /* !! */  = (ComponentName)((int[])var1_1 /* !! */ .clone());
                            ** continue;
                        }
                        var1_1 /* !! */  = new Object[]{};
                        MediaNotificationService.zza.i("actionsProvider == null", (Object[])var1_1 /* !! */ );
                        this.zzg = new ArrayList<E>();
                        var1_1 /* !! */  = this.zzc.getActions().iterator();
                        while (var1_1 /* !! */ .hasNext()) {
                            var3_3 /* !! */  = this.zzc((String)var1_1 /* !! */ .next());
                            if (var3_3 /* !! */  == null) continue;
                            this.zzg.add(var3_3 /* !! */ );
                        }
                        this.zzh = (int[])this.zzc.getCompatActionIndices().clone();
                        ** continue;
                        break;
                    }
                }
                var3_3 /* !! */  = new Intent();
                var3_3 /* !! */ .putExtra("targetActivity", (Parcelable)var1_1 /* !! */ );
                var3_3 /* !! */ .setAction(var1_1 /* !! */ .flattenToString());
                var3_3 /* !! */ .setComponent(var1_1 /* !! */ );
                v2 = TaskStackBuilder.create((Context)this);
                v2.addNextIntentWithParentStack(var3_3 /* !! */ );
                var1_1 /* !! */  = v2.getPendingIntent(1, zzdx.zza | 0x8000000);
                ** continue;
                break;
            }
        }
        var1_1 /* !! */  = var1_1 /* !! */ .zzb;
        ** while (true)
    }
}

