/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.NotificationOptions;
import com.google.android.gms.cast.framework.media.zza;
import com.google.android.gms.cast.framework.media.zzb;
import com.google.android.gms.cast.framework.media.zzd;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="CastMediaOptionsCreator")
public class CastMediaOptions
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<CastMediaOptions> CREATOR;
    private static final Logger zza;
    @SafeParcelable.Field(id=2, getter="getMediaIntentReceiverClassName")
    private final String zzb;
    @SafeParcelable.Field(id=3, getter="getExpandedControllerActivityClassName")
    private final String zzc;
    @SafeParcelable.Field(id=4, getter="getImagePickerAsBinder", type="android.os.IBinder")
    @Nullable
    private final zzd zzd;
    @SafeParcelable.Field(id=5, getter="getNotificationOptions")
    @Nullable
    private final NotificationOptions zze;
    @SafeParcelable.Field(id=6, getter="getDisableRemoteControlNotification")
    private final boolean zzf;
    @SafeParcelable.Field(id=7, getter="getMediaSessionEnabled")
    private final boolean zzg;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public ImagePicker getImagePicker() {
        zzd this_ = ((CastMediaOptions)((Object)this_)).zzd;
        if (this_ == null) return null;
        try {
            return (ImagePicker)ObjectWrapper.unwrap((IObjectWrapper)this_.zzg());
        }
        catch (RemoteException remoteException) {
            String string2 = "getWrappedClientObject";
            Object[] objectArray = new Object[]{string2, zzd.class.getSimpleName()};
            zza.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return null;
        }
    }

    @Nullable
    public NotificationOptions getNotificationOptions() {
        return this.zze;
    }

    @NonNull
    public String getExpandedControllerActivityClassName() {
        return this.zzc;
    }

    @NonNull
    public String getMediaIntentReceiverClassName() {
        return this.zzb;
    }

    static {
        zza = new Logger("CastMediaOptions");
        CREATOR = new zza();
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    CastMediaOptions(@SafeParcelable.Param(id=2) String object, @SafeParcelable.Param(id=3) String string2, @Nullable @SafeParcelable.Param(id=4) IBinder iBinder, @Nullable @SafeParcelable.Param(id=5) NotificationOptions notificationOptions, @SafeParcelable.Param(id=6) boolean bl, @SafeParcelable.Param(id=7) boolean bl2) {
        this.zzb = object;
        this.zzc = string2;
        object = iBinder == null ? null : ((object = iBinder.queryLocalInterface("com.google.android.gms.cast.framework.media.IImagePicker")) instanceof zzd ? (zzd)object : new zzb(iBinder));
        this.zzd = object;
        this.zze = notificationOptions;
        this.zzf = bl;
        this.zzg = bl2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getMediaIntentReceiverClassName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getExpandedControllerActivityClassName(), (boolean)false);
        zzd zzd2 = this.zzd;
        zzd2 = zzd2 == null ? null : zzd2.asBinder();
        SafeParcelWriter.writeIBinder((Parcel)var1_1, (int)4, (IBinder)zzd2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)5, (Parcelable)this.getNotificationOptions(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)6, (boolean)this.zzf);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)7, (boolean)this.getMediaSessionEnabled());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean getMediaSessionEnabled() {
        return this.zzg;
    }

    @ShowFirstParty
    public final boolean zza() {
        return this.zzf;
    }

    public static final class Builder {
        private String zza = "com.google.android.gms.cast.framework.media.MediaIntentReceiver";
        private String zzb;
        @Nullable
        private ImagePicker zzc;
        @Nullable
        private NotificationOptions zzd = new NotificationOptions.Builder().build();
        private boolean zze = true;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setExpandedControllerActivityClassName(@NonNull String className) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setImagePicker(@Nullable ImagePicker imagePicker) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMediaIntentReceiverClassName(@NonNull String className) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMediaSessionEnabled(boolean enabled) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setNotificationOptions(@Nullable NotificationOptions notificationOptions) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public CastMediaOptions build() {
            Object object = this.zzc;
            if (object == null) {
                object = null;
                return new CastMediaOptions(this.zza, this.zzb, (IBinder)object, this.zzd, false, this.zze);
            }
            object = ((ImagePicker)object).zza();
            return new CastMediaOptions(this.zza, this.zzb, (IBinder)object, this.zzd, false, this.zze);
        }
    }
}

