/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.internal.cast.zzek;

class InnerZoneDrawable
extends Drawable {
    private final Paint zza = new Paint();
    private final Paint zzb = new Paint();
    private final Rect zzc = new Rect();
    private final int zzd;
    private final int zze;
    private float zzf;
    private float zzg = 1.0f;
    private float zzh;
    private float zzi;
    private float zzj;
    private float zzk;

    public final int getOpacity() {
        return -3;
    }

    public InnerZoneDrawable(Context context) {
        InnerZoneDrawable innerZoneDrawable = this;
        Resources resources = context.getResources();
        innerZoneDrawable.zzd = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        innerZoneDrawable.zze = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.zza.setAntiAlias(true);
        this.zza.setStyle(Paint.Style.FILL);
        this.zza.setColor(-1);
        this.zzb.setAntiAlias(true);
        this.zzb.setStyle(Paint.Style.FILL);
        this.zzb.setColor(-1);
    }

    public final void draw(Canvas canvas) {
        float f = this.zzk;
        if (f > 0.0f) {
            float f2 = this.zzf * this.zzj;
            this.zzb.setAlpha((int)((float)this.zze * f));
            canvas.drawCircle(this.zzh, this.zzi, f2, this.zzb);
        }
        canvas.drawCircle(this.zzh, this.zzi, this.zzf * this.zzg, this.zza);
    }

    public final void setAlpha(int n) {
        this.zza.setAlpha(n);
        this.invalidateSelf();
    }

    public final void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.zza.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void setPulseAlpha(float pulseAlpha) {
        void var1_1;
        this.zzk = var1_1;
        this.invalidateSelf();
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void setPulseScale(float pulseScale) {
        void var1_1;
        this.zzj = var1_1;
        this.invalidateSelf();
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void setScale(float scale) {
        void var1_1;
        this.zzg = var1_1;
        this.invalidateSelf();
    }

    public final Animator zza() {
        Object object = new float[]{0.0f};
        object = PropertyValuesHolder.ofFloat((String)"scale", (float[])object);
        Object object2 = new int[]{0};
        object2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])object2);
        Object object3 = new float[]{0.0f};
        object3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])object3);
        Object[] objectArray = new float[]{0.0f};
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])objectArray);
        objectArray = new PropertyValuesHolder[4];
        objectArray[0] = (float)object;
        objectArray[1] = (float)object2;
        objectArray[2] = (float)object3;
        objectArray[3] = (float)propertyValuesHolder;
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])objectArray);
        objectAnimator.setInterpolator((TimeInterpolator)zzek.zza());
        return objectAnimator.setDuration(200L);
    }

    public final void zzb(Rect rect) {
        this.zzc.set(rect);
        this.zzh = this.zzc.exactCenterX();
        this.zzi = this.zzc.exactCenterY();
        float f = this.zzc.height();
        this.zzf = Math.max((float)this.zzd, Math.max((float)this.zzc.width() / 2.0f, f / 2.0f));
        this.invalidateSelf();
    }
}

