/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.KeyEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import com.google.android.gms.cast.CredentialsData;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastButtonFactory;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastReasonCodes;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.MediaNotificationManager;
import com.google.android.gms.cast.framework.ModuleUnavailableException;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.PrecacheManager;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.SessionTransferCallback;
import com.google.android.gms.cast.framework.zzag;
import com.google.android.gms.cast.framework.zzao;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.cast.framework.zzc;
import com.google.android.gms.cast.framework.zzd;
import com.google.android.gms.cast.framework.zze;
import com.google.android.gms.cast.framework.zzs;
import com.google.android.gms.cast.framework.zzz;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.internal.zzh;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.cast.zzax;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.cast.zzab;
import com.google.android.gms.internal.cast.zzae;
import com.google.android.gms.internal.cast.zzaf;
import com.google.android.gms.internal.cast.zzah;
import com.google.android.gms.internal.cast.zzay;
import com.google.android.gms.internal.cast.zzbf;
import com.google.android.gms.internal.cast.zzbm;
import com.google.android.gms.internal.cast.zzcx;
import com.google.android.gms.internal.cast.zzf;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class CastContext {
    @NonNull
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static final Logger zzb = new Logger("CastContext");
    private static final Object zzc = new Object();
    @Nullable
    private static volatile CastContext zzd;
    private final Context zze;
    private final zzz zzf;
    private final SessionManager zzg;
    private final zzs zzh;
    private final PrecacheManager zzi;
    private final MediaNotificationManager zzj;
    private final CastOptions zzk;
    private final zzn zzl;
    @VisibleForTesting
    final zzae zza;
    private final zzbf zzm;
    private final zzay zzn;
    @Nullable
    private final List zzo;
    @Nullable
    private final zzbm zzp;
    private final zzcx zzq;
    @Nullable
    private zzah zzr;
    @Nullable
    private CastReasonCodes zzs;

    /*
     * WARNING - void declaration
     */
    public int getCastReasonCodeForCastStatusCode(int castStatusCode) {
        void var1_1;
        CastReasonCodes this_ = ((CastContext)((Object)this_)).zzs;
        if (this_ == null) {
            zzb.w("castReasonCodes hasn't been initialized yet", new Object[0]);
            return 0;
        }
        return this_.zza((int)var1_1);
    }

    public int getCastState() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzg.zza();
    }

    @Nullable
    public MediaRouteSelector getMergedSelector() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        try {
            CastContext castContext = MediaRouteSelector.fromBundle((Bundle)castContext.zzf.zzf());
            return castContext;
        }
        catch (RemoteException remoteException) {
            String string2 = "getMergedSelectorAsBundle";
            Object[] objectArray = new Object[]{string2, zzz.class.getSimpleName()};
            zzb.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return null;
        }
    }

    @Nullable
    public static CastContext getSharedInstance() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return zzd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @NonNull
    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (zzd != null) return zzd;
        Object object = zzc;
        synchronized (object) {
            Context context2;
            Object object2 = zzd;
            if (object2 != null) return zzd;
            context2 = context2.getApplicationContext();
            object2 = CastContext.zzi(context2);
            CastOptions castOptions = object2.getCastOptions(context2);
            zzn zzn2 = new zzn(context2);
            Context context3 = context2;
            zzbf zzbf2 = new zzbf(context3, MediaRouter.getInstance((Context)context3), castOptions, zzn2);
            try {
                Context context4 = context2;
                zzd = new CastContext(context4, castOptions, object2.getAdditionalSessionProviders(context4), zzbf2, zzn2);
                return zzd;
            }
            catch (ModuleUnavailableException moduleUnavailableException) {
                throw new RuntimeException(moduleUnavailableException);
            }
        }
    }

    @NonNull
    public CastOptions getCastOptions() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzk;
    }

    @NonNull
    public MediaNotificationManager getMediaNotificationManager() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzj;
    }

    @NonNull
    public PrecacheManager getPrecacheManager() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzi;
    }

    @NonNull
    public SessionManager getSessionManager() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzg;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Task<CastContext> getSharedInstance(@NonNull Context context, @NonNull Executor executor) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (zzd == null) {
            void var1_1;
            Context context2;
            context2 = context2.getApplicationContext();
            OptionsProvider optionsProvider = CastContext.zzi(context2);
            CastOptions castOptions = optionsProvider.getCastOptions(context2);
            zzn zzn2 = new zzn(context2);
            Context context3 = context2;
            zzbf zzbf2 = new zzbf(context3, MediaRouter.getInstance((Context)context3), castOptions, zzn2);
            return Tasks.call((Executor)var1_1, (Callable)new zzd(context2, castOptions, optionsProvider, zzbf2, zzn2));
        }
        return Tasks.forResult((Object)zzd);
    }

    @Deprecated
    public void addAppVisibilityListener(@NonNull AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
    }

    /*
     * WARNING - void declaration
     */
    public void addCastStateListener(@NonNull CastStateListener listener) throws IllegalStateException, NullPointerException {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Preconditions.checkNotNull((Object)var1_1);
        this.zzg.zzc((CastStateListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addSessionTransferCallback(@NonNull SessionTransferCallback callback) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Preconditions.checkNotNull((Object)var1_1);
        zzbm zzbm2 = ((CastContext)((Object)zzbm2)).zzm.zzn();
        if (zzbm2 != null) {
            zzbm2.zzm((SessionTransferCallback)var1_1);
            return;
        }
    }

    @Deprecated
    public void removeAppVisibilityListener(@NonNull AppVisibilityListener appVisibilityListener) throws IllegalStateException {
    }

    /*
     * WARNING - void declaration
     */
    public void removeCastStateListener(@NonNull CastStateListener listener) throws IllegalStateException {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 == null) {
            return;
        }
        this.zzg.zzd((CastStateListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeSessionTransferCallback(@NonNull SessionTransferCallback callback) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Preconditions.checkNotNull((Object)var1_1);
        zzbm zzbm2 = ((CastContext)((Object)zzbm2)).zzm.zzn();
        if (zzbm2 != null) {
            zzbm2.zzn((SessionTransferCallback)var1_1);
            return;
        }
    }

    public void setLaunchCredentialsData(@NonNull CredentialsData credentialsData) {
        LaunchOptions launchOptions;
        LaunchOptions.Builder builder = new LaunchOptions.Builder(this.zzk.getLaunchOptions());
        builder.setCredentialsData((CredentialsData)launchOptions);
        launchOptions = builder.build();
        this.zzk.zzb(launchOptions);
        this.zzk();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setReceiverApplicationId(@NonNull String applicationId) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (TextUtils.equals((CharSequence)var1_1, (CharSequence)this.zzk.getReceiverApplicationId())) {
            return;
        }
        this.zzk.zzc((String)var1_1);
        this.zzk();
        Object object = this.zzj();
        try {
            this.zzf.zzk((String)var1_1, (Map)object);
        }
        catch (RemoteException remoteException) {
            object = "setReceiverApplicationId";
            Object[] objectArray = new Object[]{object, zzz.class.getSimpleName()};
            zzb.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
        }
        CastButtonFactory.zza(this.zze);
    }

    @Deprecated
    public boolean isAppVisible() throws IllegalStateException {
        return false;
    }

    @Deprecated
    public boolean onDispatchVolumeKeyEventBeforeJellyBean(@NonNull KeyEvent keyEvent) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return false;
    }

    @Nullable
    public static CastContext zza(@NonNull Context object) throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        try {
            object = CastContext.getSharedInstance(object);
            return object;
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray = new Object[]{runtimeException};
            zzb.e("Failed to load module from Google Play services. Cast will not work properly. Might due to outdated Google Play services. Ignoring this failure silently.", objectArray);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ CastContext zzb(Context context, CastOptions castOptions, OptionsProvider optionsProvider, zzbf zzbf2, zzn zzn2) throws Exception {
        Object object = zzc;
        synchronized (object) {
            CastContext castContext = zzd;
            if (castContext != null) return zzd;
            Context context2 = context;
            zzd = new CastContext(context2, castOptions, optionsProvider.getAdditionalSessionProviders(context2), zzbf2, zzn2);
            return zzd;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @ShowFirstParty
    public final zzs zzc() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzh;
    }

    static /* bridge */ /* synthetic */ zzz zzd(CastContext castContext) {
        return castContext.zzf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static OptionsProvider zzi(Context object) throws IllegalStateException {
        try {
            String string2;
            Bundle bundle = Wrappers.packageManager((Context)object).getApplicationInfo((String)object.getPackageName(), (int)128).metaData;
            if (bundle == null) {
                zzb.e("Bundle is null", new Object[0]);
            }
            if ((string2 = bundle.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY)) != null) return Class.forName(string2).asSubclass(OptionsProvider.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    static /* bridge */ /* synthetic */ Logger zze() {
        return zzb;
    }

    public final zzcx zzf() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzq;
    }

    private final Map zzj() {
        HashMap<Object, IBinder> hashMap = new HashMap<Object, IBinder>();
        Object object = ((CastContext)((Object)iterator)).zzr;
        if (object != null) {
            hashMap.put(((SessionProvider)object).getCategory(), ((SessionProvider)object).zza());
        }
        if ((iterator = ((CastContext)((Object)iterator)).zzo) != null) {
            Iterator iterator = iterator.iterator();
            while (iterator.hasNext()) {
                SessionProvider sessionProvider = (SessionProvider)iterator.next();
                Preconditions.checkNotNull((Object)sessionProvider, (Object)"Additional SessionProvider must not be null.");
                object = Preconditions.checkNotEmpty((String)sessionProvider.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                HashMap<Object, IBinder> hashMap2 = hashMap;
                Object object2 = object;
                Object[] objectArray = new Object[]{object};
                Preconditions.checkArgument((boolean)(hashMap2.containsKey(object2) ^ true), (Object)String.format("SessionProvider for category %s already added", objectArray));
                hashMap2.put(object2, sessionProvider.zza());
            }
        }
        return hashMap;
    }

    public static /* synthetic */ void zzg(@NonNull CastContext castContext, @NonNull Bundle bundle) {
        com.google.android.gms.internal.cast.zzf.zza(castContext.zze, castContext.zzl, castContext.zzg, castContext.zzp, castContext.zza).zzc(bundle);
    }

    private CastContext(Context objectArray, CastOptions stringArray, @Nullable List object, zzbf object2, zzn zzn2) throws ModuleUnavailableException {
        block12: {
            block11: {
                block10: {
                    this.zze = objectArray;
                    this.zzk = stringArray;
                    this.zzm = object2;
                    this.zzl = zzn2;
                    this.zzo = object;
                    this.zzn = new zzay((Context)objectArray);
                    this.zzp = object2.zzn();
                    this.zzk();
                    object = this.zzj();
                    try {
                        this.zzf = object = zzaf.zza((Context)objectArray, (CastOptions)stringArray, object2, (Map)object);
                    }
                    catch (RemoteException remoteException) {
                        throw new IllegalStateException("Failed to call newCastContextImpl", remoteException);
                    }
                    try {
                        object2 = object.zzg();
                        this.zzh = new zzs((zzag)object2);
                    }
                    catch (RemoteException remoteException) {
                        throw new IllegalStateException("Failed to call getDiscoveryManagerImpl", remoteException);
                    }
                    try {
                        object = object.zzh();
                        this.zzg = new SessionManager((zzao)object, (Context)objectArray);
                        object = this.zzg;
                        this.zzj = new MediaNotificationManager((SessionManager)object);
                        this.zzi = new PrecacheManager(this.zzk, (SessionManager)object, zzn2);
                        object = this.zzp;
                        if (object == null) break block10;
                        ((zzbm)object).zzj(this.zzg);
                    }
                    catch (RemoteException remoteException) {
                        throw new IllegalStateException("Failed to call getSessionManagerImpl", remoteException);
                    }
                }
                this.zzq = new zzcx((Context)objectArray);
                objectArray = "com.google.android.gms.cast.FLAG_MEDIA_ROUTE_DIALOG_UPDATE_DEVICES_DELAY_MS";
                zzn2.zza(new String[]{objectArray, "com.google.android.gms.cast.FLAG_MEDIA_ROUTE_DIALOG_DISCOVERY_TIMEOUT_MS", "com.google.android.gms.cast.FLAG_MEDIA_ROUTE_DIALOG_ZERO_DEVICE_TIMEOUT_MS", "com.google.android.gms.cast.FLAG_MEDIA_ROUTE_DIALOG_ENABLE_WIFI_WARNING"}).addOnSuccessListener((OnSuccessListener)zzab.zza);
                this.zza = new zzae();
                try {
                    this.zzf.zzi(this.zza);
                    this.zza.zze(this.zzn.zza);
                    if (stringArray.zza().isEmpty()) break block11;
                }
                catch (RemoteException remoteException) {
                    throw new IllegalStateException("Failed to call addAppVisibilityListener", remoteException);
                }
                objectArray = String.valueOf(String.valueOf(this.zzk.zza()));
                zzb.i("Setting Route Discovery for appIds: ".concat((String)objectArray), new Object[0]);
                this.zzn.zza(this.zzk.zza());
            }
            objectArray = "com.google.android.gms.cast.FLAG_CLIENT_SESSION_ANALYTICS_ENABLED";
            zzn2.zza(new String[]{objectArray, "com.google.android.gms.cast.FLAG_FIRELOG_UPLOAD_MODE", "com.google.android.gms.cast.FLAG_CLIENT_FEATURE_USAGE_ANALYTICS_ENABLED"}).addOnSuccessListener((OnSuccessListener)new zzb(this));
            objectArray = "com.google.android.gms.cast.MAP_CAST_STATUS_CODES_TO_CAST_REASON_CODES";
            stringArray = new String[]{objectArray};
            zzn2.doRead(TaskApiCall.builder().run((RemoteCall)new zzh(zzn2, stringArray)).setFeatures(new Feature[]{zzax.zzh}).setAutoResolveMissingFeatures(false).setMethodKey(8427).build()).addOnSuccessListener((OnSuccessListener)new zzc(this));
            try {
                int n = this.zzf.zze();
                if (n < 224300000) break block12;
            }
            catch (RemoteException remoteException) {
                objectArray = new Object[]{"clientGmsVersion", zzz.class.getSimpleName()};
                zzb.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
                return;
            }
            CastButtonFactory.zzb(new zze(this));
            return;
        }
    }

    final /* synthetic */ void zzh(Bundle bundle) {
        this.zzs = new CastReasonCodes(bundle);
    }

    @RequiresNonNull(value={"castOptions", "mediaRouter", "appContext"})
    private final void zzk() {
        if (!TextUtils.isEmpty((CharSequence)this.zzk.getReceiverApplicationId())) {
            this.zzr = new zzah(this.zze, this.zzk, this.zzm);
            return;
        }
        this.zzr = null;
    }
}

