/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.RemoteException;
import android.view.Menu;
import android.view.MenuItem;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.MenuItemCompat;
import androidx.mediarouter.app.MediaRouteActionProvider;
import androidx.mediarouter.app.MediaRouteButton;
import androidx.mediarouter.app.MediaRouteDialogFactory;
import androidx.mediarouter.media.MediaRouteSelector;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.zza;
import com.google.android.gms.cast.framework.zze;
import com.google.android.gms.cast.framework.zzz;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzaa;
import com.google.android.gms.internal.cast.zzln;
import com.google.android.gms.internal.cast.zzr;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class CastButtonFactory {
    private static final Logger zzb = new Logger("CastButtonFactory");
    private static final List zzc = new ArrayList();
    private static final List zzd = new ArrayList();
    @Nullable
    private static zza zze = null;
    public static final /* synthetic */ int zza;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public static MenuItem setUpMediaRouteButton(@NonNull Context context, @NonNull Menu menu, int menuResourceId) {
        Object[] objectArray;
        void var2_3;
        Object[] objectArray2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Preconditions.checkNotNull((Object)objectArray2);
        objectArray2 = objectArray2.findItem((int)var2_3);
        if (objectArray2 == null) {
            objectArray = new Object[]{(int)var2_3};
            throw new IllegalArgumentException(String.format(Locale.ROOT, "menu doesn't contain a menu item whose ID is %d.", objectArray));
        }
        boolean bl = CastButtonFactory.zzh((Context)objectArray);
        try {
            boolean bl2;
            MediaRouteActionProvider mediaRouteActionProvider = CastButtonFactory.zzc((MenuItem)objectArray2);
            if (mediaRouteActionProvider != null && (bl2 = CastButtonFactory.zzi((Context)objectArray, null))) {
                mediaRouteActionProvider.setAlwaysVisible(true);
            }
            CastButtonFactory.zzf((Context)objectArray, (MenuItem)objectArray2, CastButtonFactory.zzd(null, bl));
            zzc.add(new WeakReference<Object[]>(objectArray2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArray2 = new Object[]{(int)var2_3};
            throw new IllegalArgumentException(String.format(Locale.ROOT, "menu item with ID %d doesn't have a MediaRouteActionProvider.", objectArray2), illegalArgumentException);
        }
        CastButtonFactory.zze(null, bl);
        return objectArray2;
    }

    private CastButtonFactory() {
    }

    /*
     * WARNING - void declaration
     */
    public static void setUpMediaRouteButton(@NonNull Context context, @NonNull MediaRouteButton button) {
        void var1_1;
        Context context2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        boolean bl = CastButtonFactory.zzh(context2);
        if (var1_1 != null) {
            if (CastButtonFactory.zzi(context2, null)) {
                var1_1.setAlwaysVisible(true);
            }
            CastButtonFactory.zzg(context2, (MediaRouteButton)var1_1, CastButtonFactory.zzd(null, bl));
            zzd.add(new WeakReference<void>(var1_1));
        }
        CastButtonFactory.zze(null, bl);
    }

    @Nullable
    private static MediaRouteActionProvider zzc(MenuItem menuItem) {
        if ((menuItem = (MediaRouteActionProvider)MenuItemCompat.getActionProvider((MenuItem)menuItem)) == null) {
            return null;
        }
        return menuItem;
    }

    @Nullable
    private static MediaRouteDialogFactory zzd(@Nullable MediaRouteDialogFactory mediaRouteDialogFactory, boolean bl) {
        if (bl) {
            return zzaa.zza();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void zze(@Nullable MediaRouteDialogFactory mediaRouteDialogFactory, boolean bl) {
        mediaRouteDialogFactory = bl ? zzln.zzZ : zzln.zzH;
        zzr.zzd((zzln)mediaRouteDialogFactory);
    }

    private static void zzf(Context object, MenuItem menuItem, @Nullable MediaRouteDialogFactory mediaRouteDialogFactory) throws IllegalArgumentException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        menuItem = CastButtonFactory.zzc(menuItem);
        if (menuItem == null) {
            throw new IllegalArgumentException("cannot refreshButtonSelector with null mediaRouteActionProvider");
        }
        if ((object = CastContext.zza((Context)object)) != null && (object = ((CastContext)object).getMergedSelector()) != null) {
            menuItem.setRouteSelector((MediaRouteSelector)object);
        }
        if (mediaRouteDialogFactory != null) {
            menuItem.setDialogFactory(mediaRouteDialogFactory);
            return;
        }
    }

    private static void zzg(Context object, MediaRouteButton mediaRouteButton, @Nullable MediaRouteDialogFactory mediaRouteDialogFactory) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        object = CastContext.zza((Context)object);
        if (object != null && (object = ((CastContext)object).getMergedSelector()) != null) {
            mediaRouteButton.setRouteSelector((MediaRouteSelector)object);
        }
        if (mediaRouteDialogFactory != null) {
            mediaRouteButton.setDialogFactory(mediaRouteDialogFactory);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zza(@NonNull Context context) {
        MenuItem menuItem;
        Iterator iterator = zzc.iterator();
        while (iterator.hasNext()) {
            menuItem = (MenuItem)((WeakReference)iterator.next()).get();
            if (menuItem == null) continue;
            try {
                CastButtonFactory.zzf(context, menuItem, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object[] objectArray = new Object[]{illegalArgumentException};
                zzb.w("Unexpected exception when refreshing MediaRouteSelectors for Cast buttons", objectArray);
            }
        }
        iterator = zzd.iterator();
        while (iterator.hasNext()) {
            menuItem = (MediaRouteButton)((WeakReference)iterator.next()).get();
            if (menuItem == null) continue;
            CastButtonFactory.zzg(context, (MediaRouteButton)menuItem, null);
        }
        return;
    }

    static void zzb(zza object) {
        zze = object;
        object = zze;
        try {
            object = ((zze)object).zza;
            CastContext.zzd((CastContext)object).zzj(false);
            return;
        }
        catch (RemoteException remoteException) {
            String string = "setCustomMediaRouteDialogFactorySetUp";
            Object[] objectArray = new Object[]{string, zzz.class.getSimpleName()};
            CastContext.zze().d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    private static boolean zzh(Context object) {
        return (object = CastContext.zza((Context)object)) != null && ((CastContext)object).getCastOptions().zze();
    }

    private static boolean zzi(Context context, @Nullable MediaRouteDialogFactory mediaRouteDialogFactory) {
        return CastButtonFactory.zzh(context);
    }
}

