/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.util.PlatformVersion;

public final class zzcb
extends UIController {
    private final ImageView zza;
    @Nullable
    private final View zzb;
    private final boolean zzc;
    private final Drawable zzd;
    private final String zze;
    private final Drawable zzf;
    private final String zzg;
    private final Drawable zzh;
    private final String zzi;
    private boolean zzj = false;

    /*
     * Enabled aggressive block sorting
     */
    public zzcb(ImageView imageView, Context context, Drawable drawable2, Drawable drawable3, Drawable drawable4, @Nullable View view, boolean bl) {
        this.zza = imageView;
        this.zzd = drawable2;
        this.zzf = drawable3;
        imageView = drawable4 != null ? drawable4 : drawable3;
        this.zzh = imageView;
        this.zze = context.getString(R.string.cast_play);
        this.zzg = context.getString(R.string.cast_pause);
        this.zzi = context.getString(R.string.cast_stop);
        this.zzb = view;
        this.zzc = bl;
        this.zza.setEnabled(false);
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzc();
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
        this.zzb(true);
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzc();
    }

    @Override
    public final void onSessionEnded() {
        this.zza.setEnabled(false);
        super.onSessionEnded();
    }

    private final void zza(Drawable drawable2, String string2) {
        boolean bl = drawable2.equals(this.zza.getDrawable()) ^ true;
        this.zza.setImageDrawable(drawable2);
        this.zza.setContentDescription((CharSequence)string2);
        this.zza.setVisibility(0);
        this.zza.setEnabled(true);
        drawable2 = this.zzb;
        if (drawable2 != null) {
            drawable2.setVisibility(8);
        }
        if (bl && this.zzj) {
            this.zza.sendAccessibilityEvent(8);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=21)
    private final void zzb(boolean bl) {
        View view;
        if (PlatformVersion.isAtLeastLollipop()) {
            this.zzj = this.zza.isAccessibilityFocused();
        }
        if ((view = this.zzb) != null) {
            view.setVisibility(0);
            if (this.zzj) {
                this.zzb.sendAccessibilityEvent(8);
            }
        }
        ImageView imageView = this.zza;
        int n = true != this.zzc ? 0 : 4;
        imageView.setVisibility(n);
        this.zza.setEnabled(bl ^ true);
    }

    private final void zzc() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zza.setEnabled(false);
            return;
        }
        if (remoteMediaClient.isPlaying()) {
            if (remoteMediaClient.isLiveStream()) {
                this.zza(this.zzh, this.zzi);
                return;
            }
            this.zza(this.zzf, this.zzg);
            return;
        }
        if (remoteMediaClient.isBuffering()) {
            this.zzb(false);
            return;
        }
        if (remoteMediaClient.isPaused()) {
            this.zza(this.zzd, this.zze);
            return;
        }
        if (remoteMediaClient.isLoadingNextItem()) {
            this.zzb(true);
            return;
        }
    }
}

