/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.support.v4.media.session.MediaSessionCompat;
import androidx.annotation.Nullable;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import androidx.mediarouter.media.MediaRouterParams;
import androidx.mediarouter.media.MediaTransferReceiver;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzai;
import com.google.android.gms.internal.cast.zzal;
import com.google.android.gms.internal.cast.zzaq;
import com.google.android.gms.internal.cast.zzaz;
import com.google.android.gms.internal.cast.zzba;
import com.google.android.gms.internal.cast.zzbc;
import com.google.android.gms.internal.cast.zzbh;
import com.google.android.gms.internal.cast.zzdm;
import com.google.android.gms.internal.cast.zzkx;
import com.google.android.gms.internal.cast.zzr;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class zzbd
extends zzai {
    private static final Logger zza;
    private final MediaRouter zzb;
    private final CastOptions zzc;
    private final Map zzd;
    @Nullable
    private zzbh zze;
    private boolean zzf;

    @Override
    @Nullable
    public final Bundle zzb(String string2) {
        for (MediaRouter.RouteInfo routeInfo : ((zzbd)this).zzb.getRoutes()) {
            if (!routeInfo.getId().equals(string2)) continue;
            return routeInfo.getExtras();
        }
        return null;
    }

    @Nullable
    public final zzbh zzn() {
        return this.zze;
    }

    @Override
    public final String zzc() {
        return this.zzb.getSelectedRoute().getId();
    }

    static {
        Logger logger;
        zza = logger = new Logger("MediaRouterProxy");
    }

    public zzbd(Context context, MediaRouter object, CastOptions castOptions, zzn zzn2) {
        boolean bl;
        HashMap hashMap;
        this.zzd = hashMap = new HashMap();
        this.zzb = object;
        this.zzc = castOptions;
        if (Build.VERSION.SDK_INT <= 32) {
            zza.i("Don't need to set MediaRouterParams for Android S v2 or below", new Object[0]);
            return;
        }
        zza.i("Set up MediaRouterParams based on module flag and CastOptions for Android T or above", new Object[0]);
        this.zze = object;
        super(context, MediaTransferReceiver.class);
        object.setPackage(context.getPackageName());
        this.zzf = bl = context.getPackageManager().queryBroadcastReceivers((Intent)object, 0).isEmpty() ^ true;
        if (bl) {
            zzr.zzd(zzkx.zzJ);
        }
        String[] stringArray = new String[]{"com.google.android.gms.cast.FLAG_OUTPUT_SWITCHER_ENABLED"};
        stringArray = zzn2.zza(stringArray);
        super(this, castOptions);
        stringArray.addOnCompleteListener((OnCompleteListener)object);
    }

    @Override
    public final void zzd(@Nullable Bundle bundle, int n) {
        if ((bundle = MediaRouteSelector.fromBundle((Bundle)bundle)) == null) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.zzt((MediaRouteSelector)bundle, n);
            return;
        }
        zzdm zzdm2 = new zzdm(Looper.getMainLooper());
        zzba zzba2 = new zzba(this, (MediaRouteSelector)bundle, n);
        zzdm2.post((Runnable)zzba2);
    }

    private final void zzt(@Nullable MediaRouteSelector mediaRouteSelector, int n) {
        Object object = (Set)this.zzd.get(mediaRouteSelector);
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (MediaRouter.Callback)object2;
            this.zzb.addCallback(mediaRouteSelector, object2, n);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzo(MediaRouteSelector mediaRouteSelector, int n) {
        Map map = this.zzd;
        synchronized (map) {
            this.zzt(mediaRouteSelector, n);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzp(CastOptions castOptions, Task task) {
        block15: {
            block14: {
                void var2_8;
                Object object;
                Object[] objectArray;
                Object[] objectArray2;
                if (task.isSuccessful()) {
                    void var2_6;
                    objectArray2 = (Object[])task.getResult();
                    if (objectArray2 != null) {
                        if (objectArray2.containsKey("com.google.android.gms.cast.FLAG_OUTPUT_SWITCHER_ENABLED")) {
                            boolean bl = true;
                        } else {
                            boolean bl = false;
                        }
                    } else {
                        boolean bl = false;
                    }
                    objectArray = zza;
                    Object[] objectArray3 = new Object[1];
                    object = true != var2_6 ? "not existed" : "existed";
                    objectArray3[0] = object;
                    objectArray.d("The module-to-client output switcher flag %s", objectArray3);
                    if (var2_6 != false) {
                        boolean bl = objectArray2.getBoolean("com.google.android.gms.cast.FLAG_OUTPUT_SWITCHER_ENABLED");
                    } else {
                        boolean bl = true;
                    }
                } else {
                    boolean bl = true;
                }
                object = zza;
                objectArray2 = new Object[]{(boolean)var2_8, castOptions.zzg()};
                object.d("Set up output switcher flags: %b (from module), %b (from CastOptions)", objectArray2);
                boolean bl = var2_8 != false ? castOptions.zzg() : false;
                MediaRouter mediaRouter = this.zzb;
                if (mediaRouter == null || (object = this.zzc) == null) break block14;
                boolean bl2 = ((CastOptions)((Object)object)).zzf();
                boolean bl3 = ((CastOptions)((Object)object)).zzd();
                objectArray = new MediaRouterParams.Builder();
                mediaRouter.setRouterParams(objectArray.setMediaTransferReceiverEnabled(bl).setTransferToLocalEnabled(bl2).setOutputSwitcherEnabled(bl3).build());
                Logger logger = zza;
                objectArray = new Object[]{this.zzf, bl, bl2, bl3};
                logger.i("media transfer = %b, session transfer = %b, transfer to local = %b, in-app output switcher = %b", objectArray);
                if (bl2) break block15;
            }
            return;
        }
        MediaRouter mediaRouter = this.zzb;
        zzaz zzaz2 = new zzaz((zzbh)Preconditions.checkNotNull((Object)this.zze));
        mediaRouter.setOnPrepareTransferListener((MediaRouter.OnPrepareTransferListener)zzaz2);
        zzr.zzd(zzkx.zzK);
    }

    final /* synthetic */ void zzq(MediaRouteSelector mediaRouteSelector) {
        this.zzu(mediaRouteSelector);
    }

    @Override
    public final void zze(@Nullable Bundle object, zzal zzal2) {
        if ((object = MediaRouteSelector.fromBundle((Bundle)object)) == null) {
            return;
        }
        if (!((zzbd)object2).zzd.containsKey(object)) {
            Map map = ((zzbd)object2).zzd;
            HashSet hashSet = new HashSet();
            map.put(object, hashSet);
        }
        Object object2 = ((zzbd)object2).zzd;
        object2 = object2.get(object);
        object2 = (Set)object2;
        object = new zzaq(zzal2);
        object2.add(object);
    }

    @Override
    public final void zzf() {
        Iterator iterator = this.zzd.values().iterator();
        while (iterator.hasNext()) {
            for (Object object : (Set)iterator.next()) {
                object = (MediaRouter.Callback)object;
                this.zzb.removeCallback(object);
            }
        }
        this.zzd.clear();
    }

    @Override
    public final void zzg(@Nullable Bundle bundle) {
        if ((bundle = MediaRouteSelector.fromBundle((Bundle)bundle)) == null) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.zzu((MediaRouteSelector)bundle);
            return;
        }
        zzdm zzdm2 = new zzdm(Looper.getMainLooper());
        zzbc zzbc2 = new zzbc(this, (MediaRouteSelector)bundle);
        zzdm2.post((Runnable)zzbc2);
    }

    private final void zzu(@Nullable MediaRouteSelector object) {
        if ((object = (Set)this.zzd.get(object)) == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (MediaRouter.Callback)object2;
            this.zzb.removeCallback(object2);
        }
    }

    @Override
    public final void zzh() {
        zzbd zzbd2 = zzbd2.zzb;
        zzbd2.selectRoute(zzbd2.getDefaultRoute());
    }

    @Override
    public final void zzi(String string2) {
        Logger logger = zza;
        Object[] objectArray2 = new Object[]{string2};
        logger.d("select route with routeId = %s", objectArray2);
        for (Object[] objectArray2 : this.zzb.getRoutes()) {
            if (!objectArray2.getId().equals(string2)) continue;
            zza.d("media route is found and selected", new Object[0]);
            this.zzb.selectRoute((MediaRouter.RouteInfo)objectArray2);
            return;
        }
    }

    public final void zzr(@Nullable MediaSessionCompat mediaSessionCompat) {
        this.zzb.setMediaSessionCompat(mediaSessionCompat);
    }

    @Override
    public final void zzj(int n) {
        this.zzb.unselect(n);
    }

    @Override
    public final boolean zzk() {
        MediaRouter.RouteInfo routeInfo = this.zzb.getBluetoothRoute();
        return routeInfo != null && this.zzb.getSelectedRoute().getId().equals(routeInfo.getId());
    }

    @Override
    public final boolean zzl() {
        MediaRouter.RouteInfo routeInfo = this.zzb.getDefaultRoute();
        return routeInfo != null && this.zzb.getSelectedRoute().getId().equals(routeInfo.getId());
    }

    public final boolean zzs() {
        return this.zzf;
    }

    @Override
    public final boolean zzm(@Nullable Bundle bundle, int n) {
        if ((bundle = MediaRouteSelector.fromBundle((Bundle)bundle)) == null) {
            return false;
        }
        return this.zzb.isRouteAvailable((MediaRouteSelector)bundle, n);
    }
}

