/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.R;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.internal.zza;
import com.google.android.gms.cast.framework.media.internal.zzb;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.CastSeekBar;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.cast.framework.media.widget.zzh;
import com.google.android.gms.cast.framework.media.widget.zzi;
import com.google.android.gms.cast.framework.media.widget.zzk;
import com.google.android.gms.cast.framework.media.widget.zzl;
import com.google.android.gms.cast.framework.media.widget.zzn;
import com.google.android.gms.cast.framework.media.widget.zzp;
import com.google.android.gms.cast.framework.media.widget.zzr;
import com.google.android.gms.cast.framework.media.widget.zzs;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.cast.zzco;
import com.google.android.gms.internal.cast.zzcp;
import com.google.android.gms.internal.cast.zzcq;
import com.google.android.gms.internal.cast.zzcr;
import com.google.android.gms.internal.cast.zzkx;
import java.util.Timer;
import java.util.TimerTask;

public abstract class ExpandedControllerActivity
extends AppCompatActivity
implements ControlButtonsContainer {
    @VisibleForTesting
    final SessionManagerListener zza;
    @VisibleForTesting
    final RemoteMediaClient.Listener zzb;
    @DrawableRes
    private int zze;
    @DrawableRes
    private int zzf;
    @DrawableRes
    private int zzg;
    @DrawableRes
    private int zzh;
    @DrawableRes
    private int zzi;
    @DrawableRes
    private int zzj;
    @DrawableRes
    private int zzk;
    @DrawableRes
    private int zzl;
    @DrawableRes
    private int zzm;
    @DrawableRes
    private int zzn;
    @ColorInt
    private int zzo;
    @ColorInt
    private int zzp;
    @ColorInt
    private int zzq;
    @ColorInt
    private int zzr;
    private int zzs;
    private int zzt;
    private int zzu;
    private int zzv;
    private TextView zzw;
    private SeekBar zzx;
    private CastSeekBar zzy;
    private ImageView zzz;
    private ImageView zzA;
    private int[] zzB;
    private ImageView[] zzC;
    private View zzD;
    private View zzE;
    private ImageView zzF;
    private TextView zzG;
    private TextView zzH;
    private TextView zzI;
    private TextView zzJ;
    @VisibleForTesting
    zzb zzc;
    private UIMediaController zzK;
    private SessionManager zzL;
    @Nullable
    private Cast.Listener zzM;
    @VisibleForTesting
    boolean zzd;
    private boolean zzN;
    private Timer zzO;
    @Nullable
    private String zzP;

    @Override
    public final int getButtonSlotCount() {
        return 4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getButtonTypeAt(int slotIndex) throws IndexOutOfBoundsException {
        void var1_1;
        return this.zzB[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NonNull
    public final ImageView getButtonImageViewAt(int slotIndex) throws IndexOutOfBoundsException {
        void var1_1;
        return this.zzC[var1_1];
    }

    @Deprecated
    @NonNull
    public SeekBar getSeekBar() {
        return this.zzx;
    }

    @NonNull
    public TextView getStatusTextView() {
        return this.zzw;
    }

    @Override
    @NonNull
    public UIMediaController getUIMediaController() {
        return this.zzK;
    }

    public ExpandedControllerActivity() {
        Object object = new zzr(this, null);
        this.zza = object;
        this.zzb = object = new zzp(this, null);
        this.zzC = new ImageView[4];
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        Object object;
        super.onCreate((Bundle)object);
        this.zzL = CastContext.getSharedInstance((Context)this).getSessionManager();
        if (this.zzL.getCurrentCastSession() == null) {
            this.finish();
        }
        object = new UIMediaController((Activity)this);
        this.zzK = object;
        this.zzK.setPostRemoteMediaClientListener(this.zzb);
        this.setContentView(R.layout.cast_expanded_controller_activity);
        object = new int[1];
        object[0] = R.attr.selectableItemBackgroundBorderless;
        object = this.obtainStyledAttributes((int[])object);
        this.zze = object.getResourceId(0, 0);
        object.recycle();
        Object object2 = this.obtainStyledAttributes(null, R.styleable.CastExpandedController, R.attr.castExpandedControllerStyle, R.style.CastExpandedController);
        this.zzs = object2.getResourceId(R.styleable.CastExpandedController_castButtonColor, 0);
        this.zzf = object2.getResourceId(R.styleable.CastExpandedController_castPlayButtonDrawable, 0);
        this.zzg = object2.getResourceId(R.styleable.CastExpandedController_castPauseButtonDrawable, 0);
        this.zzh = object2.getResourceId(R.styleable.CastExpandedController_castStopButtonDrawable, 0);
        this.zzi = object2.getResourceId(R.styleable.CastExpandedController_castSkipPreviousButtonDrawable, 0);
        this.zzj = object2.getResourceId(R.styleable.CastExpandedController_castSkipNextButtonDrawable, 0);
        this.zzk = object2.getResourceId(R.styleable.CastExpandedController_castRewind30ButtonDrawable, 0);
        this.zzl = object2.getResourceId(R.styleable.CastExpandedController_castForward30ButtonDrawable, 0);
        this.zzm = object2.getResourceId(R.styleable.CastExpandedController_castMuteToggleButtonDrawable, 0);
        this.zzn = object2.getResourceId(R.styleable.CastExpandedController_castClosedCaptionsButtonDrawable, 0);
        int n = object2.getResourceId(R.styleable.CastExpandedController_castControlButtons, 0);
        if (n != 0) {
            TypedArray typedArray = this.getResources().obtainTypedArray(n);
            n = typedArray.length() == 4 ? 1 : 0;
            Preconditions.checkArgument(n != 0);
            this.zzB = new int[typedArray.length()];
            for (n = 0; n < typedArray.length(); ++n) {
                this.zzB[n] = typedArray.getResourceId(n, 0);
            }
            typedArray.recycle();
        } else {
            int[] nArray = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
            this.zzB = nArray;
        }
        this.zzr = object2.getColor(R.styleable.CastExpandedController_castExpandedControllerLoadingIndicatorColor, 0);
        int n2 = R.styleable.CastExpandedController_castAdLabelColor;
        n2 = object2.getResourceId(n2, 0);
        this.zzo = this.getResources().getColor(n2);
        n2 = R.styleable.CastExpandedController_castAdInProgressTextColor;
        n2 = object2.getResourceId(n2, 0);
        this.zzp = this.getResources().getColor(n2);
        n2 = R.styleable.CastExpandedController_castAdLabelTextColor;
        n2 = object2.getResourceId(n2, 0);
        this.zzq = this.getResources().getColor(n2);
        this.zzt = object2.getResourceId(R.styleable.CastExpandedController_castAdLabelTextAppearance, 0);
        this.zzu = object2.getResourceId(R.styleable.CastExpandedController_castAdInProgressLabelTextAppearance, 0);
        this.zzv = object2.getResourceId(R.styleable.CastExpandedController_castAdInProgressText, 0);
        n2 = object2.getResourceId(R.styleable.CastExpandedController_castDefaultAdPosterUrl, 0);
        if (n2 != 0) {
            this.zzP = this.getApplicationContext().getResources().getString(n2);
        }
        object2.recycle();
        Object object3 = this.findViewById(R.id.expanded_controller_layout);
        object2 = this.zzK;
        this.zzz = (ImageView)object3.findViewById(R.id.background_image_view);
        this.zzA = (ImageView)object3.findViewById(R.id.blurred_background_image_view);
        int n3 = R.id.background_place_holder_image_view;
        View view = object3.findViewById(n3);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        ImageView imageView = this.zzz;
        ImageHints imageHints = new ImageHints(4, displayMetrics.widthPixels, displayMetrics.heightPixels);
        zzn zzn2 = new zzn(this, null);
        ((UIMediaController)object2).zzb(imageView, imageHints, view, zzn2);
        this.zzw = (TextView)object3.findViewById(R.id.status_text);
        ProgressBar progressBar = (ProgressBar)object3.findViewById(R.id.loading_indicator);
        Drawable drawable2 = progressBar.getIndeterminateDrawable();
        int n4 = this.zzr;
        if (n4 != 0) {
            drawable2.setColorFilter(n4, PorterDuff.Mode.SRC_IN);
        }
        ((UIMediaController)object2).bindViewToLoadingIndicator((View)progressBar);
        TextView textView = (TextView)object3.findViewById(R.id.start_text);
        TextView textView2 = (TextView)object3.findViewById(R.id.end_text);
        this.zzx = (SeekBar)object3.findViewById(R.id.seek_bar);
        this.zzy = (CastSeekBar)object3.findViewById(R.id.cast_seek_bar);
        ((UIMediaController)object2).bindSeekBar(this.zzy, 1000L);
        zzcq zzcq2 = new zzcq(textView, ((UIMediaController)object2).zza());
        ((UIMediaController)object2).bindViewToUIController((View)textView, zzcq2);
        zzco zzco2 = new zzco(textView2, ((UIMediaController)object2).zza());
        ((UIMediaController)object2).bindViewToUIController((View)textView2, zzco2);
        View view2 = object3.findViewById(R.id.live_indicators);
        zzcp zzcp2 = new zzcp(view2, ((UIMediaController)object2).zza());
        ((UIMediaController)object2).bindViewToUIController(view2, zzcp2);
        RelativeLayout relativeLayout = (RelativeLayout)object3.findViewById(R.id.tooltip_container);
        zzcr zzcr2 = new zzcr(relativeLayout, this.zzy, ((UIMediaController)object2).zza());
        ((UIMediaController)object2).bindViewToUIController((View)relativeLayout, zzcr2);
        ((UIMediaController)object2).zzf(zzcr2);
        this.zzC[0] = (ImageView)object3.findViewById(R.id.button_0);
        this.zzC[1] = (ImageView)object3.findViewById(R.id.button_1);
        this.zzC[2] = (ImageView)object3.findViewById(R.id.button_2);
        this.zzC[3] = (ImageView)object3.findViewById(R.id.button_3);
        this.zzl((View)object3, R.id.button_0, this.zzB[0], (UIMediaController)object2);
        this.zzl((View)object3, R.id.button_1, this.zzB[1], (UIMediaController)object2);
        this.zzl((View)object3, R.id.button_play_pause_toggle, R.id.cast_button_type_play_pause_toggle, (UIMediaController)object2);
        this.zzl((View)object3, R.id.button_2, this.zzB[2], (UIMediaController)object2);
        this.zzl((View)object3, R.id.button_3, this.zzB[3], (UIMediaController)object2);
        this.zzD = this.findViewById(R.id.ad_container);
        this.zzF = (ImageView)this.zzD.findViewById(R.id.ad_image_view);
        this.zzE = this.zzD.findViewById(R.id.ad_background_image_view);
        this.zzH = (TextView)this.zzD.findViewById(R.id.ad_label);
        this.zzH.setTextColor(this.zzq);
        this.zzH.setBackgroundColor(this.zzo);
        this.zzG = (TextView)this.zzD.findViewById(R.id.ad_in_progress_label);
        this.zzJ = (TextView)this.findViewById(R.id.ad_skip_text);
        this.zzI = (TextView)this.findViewById(R.id.ad_skip_button);
        object3 = this.zzI;
        object2 = new zzi(this);
        object3.setOnClickListener((View.OnClickListener)object2);
        this.setSupportActionBar((Toolbar)this.findViewById(R.id.toolbar));
        object3 = this.getSupportActionBar();
        if (object3 != null) {
            object3.setDisplayHomeAsUpEnabled(true);
            object3.setHomeAsUpIndicator(R.drawable.quantum_ic_keyboard_arrow_down_white_36);
        }
        this.zzn();
        this.zzo();
        if (this.zzG != null && this.zzv != 0) {
            if (PlatformVersion.isAtLeastM()) {
                this.zzG.setTextAppearance(this.zzu);
            } else {
                this.zzG.setTextAppearance(this.getApplicationContext(), this.zzu);
            }
            this.zzG.setTextColor(this.zzp);
            this.zzG.setText(this.zzv);
        }
        object2 = this.getApplicationContext();
        ImageHints imageHints2 = new ImageHints(-1, this.zzF.getWidth(), this.zzF.getHeight());
        object3 = new zzb((Context)object2, imageHints2);
        this.zzc = object3;
        object3 = this.zzc;
        object2 = new zzh(this);
        ((zzb)object3).zzc((zza)object2);
        com.google.android.gms.internal.cast.zzr.zzd(zzkx.zzc);
    }

    protected void onDestroy() {
        this.zzc.zza();
        UIMediaController uIMediaController = this.zzK;
        if (uIMediaController != null) {
            uIMediaController.setPostRemoteMediaClientListener(null);
            this.zzK.dispose();
        }
        super.onDestroy();
    }

    protected void onPause() {
        Object object = this.zzL;
        if (object == null) {
            return;
        }
        object = ((SessionManager)object).getCurrentCastSession();
        Cast.Listener listener = this.zzM;
        if (listener != null && object != null) {
            ((CastSession)object).removeCastListener(listener);
            this.zzM = null;
        }
        this.zzL.removeSessionManagerListener(this.zza, CastSession.class);
        super.onPause();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onResume() {
        Object object = this.zzL;
        if (object == null) {
            return;
        }
        ((SessionManager)object).addSessionManagerListener(this.zza, CastSession.class);
        object = this.zzL.getCurrentCastSession();
        if (object == null || !((Session)object).isConnected() && !((Session)object).isConnecting()) {
            this.finish();
        } else {
            zzl zzl2 = new zzl(this);
            this.zzM = zzl2;
            ((CastSession)object).addCastListener(this.zzM);
        }
        boolean bl = (object = this.zzj()) != null ? !((RemoteMediaClient)object).hasMediaSession() : true;
        this.zzd = bl;
        this.zzn();
        this.zzp();
        super.onResume();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        int n;
        super.onWindowFocusChanged(n != 0);
        if (n != 0) {
            n = this.getWindow().getDecorView().getSystemUiVisibility() ^ 2;
            if (PlatformVersion.isAtLeastJellyBean()) {
                n ^= 4;
            }
            if (PlatformVersion.isAtLeastKitKat()) {
                n ^= 0x1000;
            }
            this.getWindow().getDecorView().setSystemUiVisibility(n);
            this.setImmersive(true);
            return;
        }
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
        }
        return true;
    }

    static /* bridge */ /* synthetic */ ImageView zza(ExpandedControllerActivity expandedControllerActivity) {
        return expandedControllerActivity.zzF;
    }

    static /* bridge */ /* synthetic */ TextView zzb(ExpandedControllerActivity expandedControllerActivity) {
        return expandedControllerActivity.zzG;
    }

    static /* bridge */ /* synthetic */ TextView zzc(ExpandedControllerActivity expandedControllerActivity) {
        return expandedControllerActivity.zzI;
    }

    static /* bridge */ /* synthetic */ TextView zzd(ExpandedControllerActivity expandedControllerActivity) {
        return expandedControllerActivity.zzw;
    }

    static /* bridge */ /* synthetic */ RemoteMediaClient zze(ExpandedControllerActivity expandedControllerActivity) {
        return expandedControllerActivity.zzj();
    }

    @Nullable
    private final RemoteMediaClient zzj() {
        CastSession castSession = ((ExpandedControllerActivity)((Object)castSession)).zzL.getCurrentCastSession();
        if (castSession != null && castSession.isConnected()) {
            return castSession.getRemoteMediaClient();
        }
        return null;
    }

    static /* bridge */ /* synthetic */ void zzf(ExpandedControllerActivity expandedControllerActivity, RemoteMediaClient remoteMediaClient) {
        expandedControllerActivity.zzm(remoteMediaClient);
    }

    static /* bridge */ /* synthetic */ void zzg(ExpandedControllerActivity expandedControllerActivity) {
        expandedControllerActivity.zzn();
    }

    static /* bridge */ /* synthetic */ void zzh(ExpandedControllerActivity expandedControllerActivity) {
        expandedControllerActivity.zzo();
    }

    static /* bridge */ /* synthetic */ void zzi(ExpandedControllerActivity expandedControllerActivity) {
        expandedControllerActivity.zzp();
    }

    private final void zzk(String string2) {
        string2 = Uri.parse((String)string2);
        this.zzc.zzd((Uri)string2);
        this.zzE.setVisibility(8);
    }

    private final void zzl(View view, int n, int n2, UIMediaController uIMediaController) {
        view = (ImageView)view.findViewById(n);
        if (n2 == R.id.cast_button_type_empty) {
            view.setVisibility(4);
            return;
        }
        if (n2 == R.id.cast_button_type_play_pause_toggle) {
            view.setBackgroundResource(expandedControllerActivity.zze);
            n = expandedControllerActivity.zzs;
            n2 = expandedControllerActivity.zzg;
            Drawable drawable2 = com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, n, n2);
            Drawable drawable3 = com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzs, expandedControllerActivity.zzf);
            int n3 = expandedControllerActivity.zzs;
            int n4 = expandedControllerActivity.zzh;
            ExpandedControllerActivity expandedControllerActivity = com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, n3, n4);
            view.setImageDrawable(drawable3);
            uIMediaController.bindImageViewToPlayPauseToggle((ImageView)view, drawable3, drawable2, (Drawable)expandedControllerActivity, null, false);
            return;
        }
        if (n2 == R.id.cast_button_type_skip_previous) {
            view.setBackgroundResource(expandedControllerActivity.zze);
            view.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzs, expandedControllerActivity.zzi));
            view.setContentDescription((CharSequence)expandedControllerActivity.getResources().getString(R.string.cast_skip_prev));
            uIMediaController.bindViewToSkipPrev(view, 0);
            return;
        }
        if (n2 == R.id.cast_button_type_skip_next) {
            view.setBackgroundResource(expandedControllerActivity.zze);
            view.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzs, expandedControllerActivity.zzj));
            view.setContentDescription((CharSequence)expandedControllerActivity.getResources().getString(R.string.cast_skip_next));
            uIMediaController.bindViewToSkipNext(view, 0);
            return;
        }
        if (n2 == R.id.cast_button_type_rewind_30_seconds) {
            view.setBackgroundResource(expandedControllerActivity.zze);
            view.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzs, expandedControllerActivity.zzk));
            view.setContentDescription((CharSequence)expandedControllerActivity.getResources().getString(R.string.cast_rewind_30));
            uIMediaController.bindViewToRewind(view, 30000L);
            return;
        }
        if (n2 == R.id.cast_button_type_forward_30_seconds) {
            view.setBackgroundResource(expandedControllerActivity.zze);
            view.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzs, expandedControllerActivity.zzl));
            view.setContentDescription((CharSequence)expandedControllerActivity.getResources().getString(R.string.cast_forward_30));
            uIMediaController.bindViewToForward(view, 30000L);
            return;
        }
        if (n2 == R.id.cast_button_type_mute_toggle) {
            view.setBackgroundResource(expandedControllerActivity.zze);
            view.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzs, expandedControllerActivity.zzm));
            uIMediaController.bindImageViewToMuteToggle((ImageView)view);
            return;
        }
        if (n2 == R.id.cast_button_type_closed_caption) {
            view.setBackgroundResource(expandedControllerActivity.zze);
            view.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzs, expandedControllerActivity.zzn));
            uIMediaController.bindViewToClosedCaption(view);
            return;
        }
    }

    private final void zzm(RemoteMediaClient remoteMediaClient) {
        if (!this.zzd) {
            MediaStatus mediaStatus = remoteMediaClient.getMediaStatus();
            if (mediaStatus == null || remoteMediaClient.isBuffering()) {
                return;
            }
            this.zzI.setVisibility(8);
            this.zzJ.setVisibility(8);
            mediaStatus = mediaStatus.getCurrentAdBreakClip();
            if (mediaStatus != null && mediaStatus.getWhenSkippableInMs() != -1L) {
                float f;
                zzk zzk2;
                if (!this.zzN) {
                    Timer timer;
                    zzk2 = new zzk(this, remoteMediaClient);
                    this.zzO = timer = new Timer();
                    this.zzO.scheduleAtFixedRate((TimerTask)zzk2, 0L, 500L);
                    this.zzN = true;
                }
                if ((f = (float)(mediaStatus.getWhenSkippableInMs() - remoteMediaClient.getApproximateAdBreakClipPositionMs())) <= 0.0f) {
                    if (this.zzN) {
                        this.zzO.cancel();
                        this.zzN = false;
                    }
                    this.zzI.setVisibility(0);
                    this.zzI.setClickable(true);
                    return;
                }
                this.zzJ.setVisibility(0);
                mediaStatus = this.zzJ;
                zzk2 = this.getResources();
                int n = R.string.cast_expanded_controller_skip_ad_text;
                Object[] objectArray = new Object[]{(int)Math.ceil(f / 1000.0f)};
                mediaStatus.setText((CharSequence)zzk2.getString(n, objectArray));
                this.zzI.setClickable(false);
                return;
            }
            return;
        }
    }

    private final void zzn() {
        Object object = expandedControllerActivity.zzL.getCurrentCastSession();
        if (object != null && (object = ((CastSession)object).getCastDevice()) != null && !TextUtils.isEmpty((CharSequence)(object = object.getFriendlyName()))) {
            TextView textView = expandedControllerActivity.zzw;
            ExpandedControllerActivity expandedControllerActivity = expandedControllerActivity.getResources();
            int n = R.string.cast_casting_to_device;
            Object[] objectArray = new Object[]{object};
            textView.setText((CharSequence)expandedControllerActivity.getString(n, objectArray));
            return;
        }
        expandedControllerActivity.zzw.setText((CharSequence)"");
    }

    private final void zzo() {
        Object object = this.zzj();
        if (object != null && ((RemoteMediaClient)object).hasMediaSession() && (object = ((RemoteMediaClient)object).getMediaInfo()) != null && (object = object.getMetadata()) != null && (this = this.getSupportActionBar()) != null) {
            this.setTitle(object.getString("com.google.android.gms.cast.metadata.TITLE"));
            object = com.google.android.gms.cast.framework.media.internal.zzs.zze((MediaMetadata)object);
            if (object != null) {
                this.setSubtitle((CharSequence)object);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @TargetApi(value=23)
    private final void zzp() {
        void var1_7;
        void var1_5;
        void var2_15;
        AdBreakClipInfo adBreakClipInfo;
        Bitmap bitmap;
        Bitmap bitmap2;
        Drawable drawable2;
        RemoteMediaClient remoteMediaClient = this.zzj();
        if (remoteMediaClient == null) {
            return;
        }
        MediaStatus mediaStatus = remoteMediaClient.getMediaStatus();
        if (mediaStatus == null) {
            return;
        }
        if (!mediaStatus.isPlayingAd()) {
            this.zzJ.setVisibility(8);
            this.zzI.setVisibility(8);
            this.zzD.setVisibility(8);
            this.zzA.setVisibility(8);
            this.zzA.setImageBitmap(null);
            return;
        }
        if (this.zzA.getVisibility() == 8 && (drawable2 = this.zzz.getDrawable()) != null && drawable2 instanceof BitmapDrawable && (bitmap2 = ((BitmapDrawable)drawable2).getBitmap()) != null && (bitmap = com.google.android.gms.cast.framework.media.widget.zzs.zza((Context)this, bitmap2, 0.25f, 7.5f)) != null) {
            this.zzA.setImageBitmap(bitmap);
            this.zzA.setVisibility(0);
        }
        if ((adBreakClipInfo = mediaStatus.getCurrentAdBreakClip()) != null) {
            String string2 = adBreakClipInfo.getTitle();
            String string3 = adBreakClipInfo.getImageUrl();
            String string4 = string2;
            String string5 = string3;
        } else {
            Object var1_8 = null;
            Object var2_17 = null;
        }
        if (!TextUtils.isEmpty((CharSequence)var2_15)) {
            this.zzk((String)var2_15);
        } else if (!TextUtils.isEmpty((CharSequence)this.zzP)) {
            this.zzk(this.zzP);
        } else {
            this.zzG.setVisibility(0);
            this.zzE.setVisibility(0);
            this.zzF.setVisibility(8);
        }
        TextView textView = this.zzH;
        if (TextUtils.isEmpty((CharSequence)var1_5)) {
            String string6 = this.getResources().getString(R.string.cast_ad_label);
        }
        textView.setText((CharSequence)var1_7);
        if (PlatformVersion.isAtLeastM()) {
            this.zzH.setTextAppearance(this.zzt);
        } else {
            this.zzH.setTextAppearance((Context)this, this.zzt);
        }
        this.zzD.setVisibility(0);
        this.zzm(remoteMediaClient);
    }
}

