/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;

@Keep
public class MediaIntentReceiver
extends BroadcastReceiver {
    private static final String TAG = "MediaIntentReceiver";
    private static final Logger log;
    @NonNull
    public static final String ACTION_TOGGLE_PLAYBACK = "com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK";
    @NonNull
    public static final String ACTION_SKIP_NEXT = "com.google.android.gms.cast.framework.action.SKIP_NEXT";
    @NonNull
    public static final String ACTION_SKIP_PREV = "com.google.android.gms.cast.framework.action.SKIP_PREV";
    @NonNull
    public static final String ACTION_FORWARD = "com.google.android.gms.cast.framework.action.FORWARD";
    @NonNull
    public static final String ACTION_REWIND = "com.google.android.gms.cast.framework.action.REWIND";
    @NonNull
    public static final String ACTION_STOP_CASTING = "com.google.android.gms.cast.framework.action.STOP_CASTING";
    @NonNull
    public static final String ACTION_DISCONNECT = "com.google.android.gms.cast.framework.action.DISCONNECT";
    @NonNull
    public static final String EXTRA_SKIP_STEP_MS = "googlecast-extra_skip_step_ms";

    @Nullable
    private static RemoteMediaClient getRemoteMediaClient(CastSession session) {
        CastSession castSession;
        if (session == null || !castSession.isConnected()) {
            return null;
        }
        return castSession.getRemoteMediaClient();
    }

    static {
        Logger logger;
        log = logger = new Logger(TAG);
    }

    /*
     * Unable to fully structure code
     */
    public void onReceive(@NonNull Context context, @NonNull Intent intent) {
        var4_3 = intent.getAction();
        var3_4 = MediaIntentReceiver.log;
        var5_6 = new Object[]{var4_3};
        var3_4.d("onReceive action: %s", (Object[])var5_6);
        if (var4_3 == null) {
            return;
        }
        var5_6 = CastContext.getSharedInstance((Context)var1_1).getSessionManager();
        var6_7 = var5_6.getCurrentSession();
        if (var6_7 == null) {
            return;
        }
        switch (var4_3.hashCode()) lbl-1000:
        // 8 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    var3_5 = -1;
lbl15:
                    // 9 sources

                    while (true) {
                        switch (var3_5) {
                            default: {
                                this.onReceiveOtherAction((Context)var1_1, var4_3, (Intent)var2_2);
                                return;
                            }
                            case 7: {
                                this.onReceiveActionMediaButton(var6_7, (Intent)var2_2);
                                return;
                            }
                            case 6: {
                                var5_6.endCurrentSession(false);
                                return;
                            }
                            case 5: {
                                var5_6.endCurrentSession(true);
                                return;
                            }
                            case 4: {
                                this.onReceiveActionRewind(var6_7, var2_2.getLongExtra("googlecast-extra_skip_step_ms", 0L));
                                return;
                            }
                            case 3: {
                                this.onReceiveActionForward(var6_7, var2_2.getLongExtra("googlecast-extra_skip_step_ms", 0L));
                                return;
                            }
                            case 2: {
                                this.onReceiveActionSkipPrev(var6_7);
                                return;
                            }
                            case 1: {
                                this.onReceiveActionSkipNext(var6_7);
                                return;
                            }
                            case 0: 
                        }
                        this.onReceiveActionTogglePlayback(var6_7);
                        return;
                    }
                    break;
                }
            }
            case 1997055314: {
                if (!var4_3.equals("android.intent.action.MEDIA_BUTTON")) ** GOTO lbl-1000
                var3_5 = 7;
                ** GOTO lbl15
            }
            case 1362116196: {
                if (!var4_3.equals("com.google.android.gms.cast.framework.action.FORWARD")) ** GOTO lbl-1000
                var3_5 = 3;
                ** GOTO lbl15
            }
            case 235550565: {
                if (!var4_3.equals("com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK")) ** GOTO lbl-1000
                var3_5 = 0;
                ** GOTO lbl15
            }
            case -124479363: {
                if (!var4_3.equals("com.google.android.gms.cast.framework.action.DISCONNECT")) ** GOTO lbl-1000
                var3_5 = 6;
                ** GOTO lbl15
            }
            case -668151673: {
                if (!var4_3.equals("com.google.android.gms.cast.framework.action.STOP_CASTING")) ** GOTO lbl-1000
                var3_5 = 5;
                ** GOTO lbl15
            }
            case -945080078: {
                if (!var4_3.equals("com.google.android.gms.cast.framework.action.SKIP_PREV")) ** GOTO lbl-1000
                var3_5 = 2;
                ** GOTO lbl15
            }
            case -945151566: {
                if (!var4_3.equals("com.google.android.gms.cast.framework.action.SKIP_NEXT")) ** GOTO lbl-1000
                var3_5 = 1;
                ** GOTO lbl15
            }
            case -1699820260: 
        }
        ** while (!var4_3.equals((Object)"com.google.android.gms.cast.framework.action.REWIND"))
lbl74:
        // 1 sources

        var3_5 = 4;
        ** while (true)
    }

    /*
     * WARNING - void declaration
     */
    protected void onReceiveActionForward(@NonNull Session currentSession, long forwardStepMs) {
        if (currentSession instanceof CastSession) {
            void var2_2;
            void var1_1;
            this.seek((CastSession)var1_1, (long)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onReceiveActionMediaButton(@NonNull Session currentSession, @NonNull Intent intent) {
        if (currentSession instanceof CastSession) {
            KeyEvent keyEvent;
            if (!keyEvent.hasExtra("android.intent.extra.KEY_EVENT")) {
                return;
            }
            if ((keyEvent = (KeyEvent)((Bundle)Preconditions.checkNotNull((Object)keyEvent.getExtras())).get("android.intent.extra.KEY_EVENT")) == null || keyEvent.getAction() != 0) {
                return;
            }
            if (keyEvent.getKeyCode() == 85) {
                void var1_1;
                this.togglePlayback((CastSession)var1_1);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onReceiveActionRewind(@NonNull Session currentSession, long rewindStepMs) {
        if (currentSession instanceof CastSession) {
            void var2_2;
            void var1_1;
            this.seek((CastSession)var1_1, (long)(-var2_2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onReceiveActionSkipNext(@NonNull Session currentSession) {
        if (currentSession instanceof CastSession) {
            void var1_1;
            RemoteMediaClient remoteMediaClient = MediaIntentReceiver.getRemoteMediaClient((CastSession)var1_1);
            if (remoteMediaClient == null || remoteMediaClient.isPlayingAd()) {
                return;
            }
            remoteMediaClient.queueNext(null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onReceiveActionSkipPrev(@NonNull Session currentSession) {
        if (currentSession instanceof CastSession) {
            void var1_1;
            RemoteMediaClient remoteMediaClient = MediaIntentReceiver.getRemoteMediaClient((CastSession)var1_1);
            if (remoteMediaClient == null || remoteMediaClient.isPlayingAd()) {
                return;
            }
            remoteMediaClient.queuePrev(null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onReceiveActionTogglePlayback(@NonNull Session currentSession) {
        if (currentSession instanceof CastSession) {
            void var1_1;
            this.togglePlayback((CastSession)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected void onReceiveOtherAction(@NonNull String action, @NonNull Intent intent) {
        void var2_2;
        void var1_1;
        this.onReceiveOtherAction(null, (String)var1_1, (Intent)var2_2);
    }

    protected void onReceiveOtherAction(@Nullable Context context, @NonNull String string2, @NonNull Intent intent) {
    }

    /*
     * WARNING - void declaration
     */
    private void seek(CastSession session, long seekStepMs) {
        void var2_2;
        void var1_1;
        if (seekStepMs == 0L) {
            return;
        }
        RemoteMediaClient remoteMediaClient = MediaIntentReceiver.getRemoteMediaClient((CastSession)var1_1);
        if (remoteMediaClient == null || remoteMediaClient.isLiveStream() || remoteMediaClient.isPlayingAd()) {
            return;
        }
        remoteMediaClient.seek(remoteMediaClient.getApproximateStreamPosition() + var2_2);
    }

    private void togglePlayback(CastSession session) {
        RemoteMediaClient remoteMediaClient = MediaIntentReceiver.getRemoteMediaClient(session);
        if (remoteMediaClient == null) {
            return;
        }
        remoteMediaClient.togglePlayback();
    }
}

