/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.NotificationOptions;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzaa;
import com.google.android.gms.cast.framework.zze;
import com.google.android.gms.cast.framework.zzf;
import com.google.android.gms.cast.framework.zzg;
import com.google.android.gms.cast.framework.zzk;
import com.google.android.gms.cast.framework.zzm;
import com.google.android.gms.cast.framework.zzo;
import com.google.android.gms.cast.framework.zzu;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.internal.zzas;
import com.google.android.gms.cast.zzbb;
import com.google.android.gms.cast.zzbc;
import com.google.android.gms.cast.zzbh;
import com.google.android.gms.cast.zzbt;
import com.google.android.gms.cast.zzq;
import com.google.android.gms.cast.zzr;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.PendingResults;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzad;
import com.google.android.gms.internal.cast.zzbd;
import com.google.android.gms.internal.cast.zzbm;
import com.google.android.gms.tasks.Task;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.checkerframework.dataflow.qual.Pure;

public class CastSession
extends Session {
    private static final Logger zzb;
    private final Context zzc;
    private final Set zzd;
    @Nullable
    private final zzaa zze;
    private final CastOptions zzf;
    private final zzbd zzg;
    private final com.google.android.gms.cast.framework.media.internal.zzr zzh;
    @Nullable
    private zzr zzi;
    @Nullable
    private RemoteMediaClient zzj;
    @Nullable
    private CastDevice zzk;
    @Nullable
    private Cast.ApplicationConnectionResult zzl;
    @Nullable
    private com.google.android.gms.internal.cast.zzbh zzm;
    private final zzg zzn;
    public static final /* synthetic */ int zza;

    public double getVolume() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            return castSession.zza();
        }
        return 0.0;
    }

    public int getActiveInputState() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            return castSession.zzb();
        }
        return -1;
    }

    public int getStandbyState() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            return castSession.zzc();
        }
        return -1;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = this.zzj;
        if (remoteMediaClient == null) {
            return 0L;
        }
        return remoteMediaClient.getStreamDuration() - this.zzj.getApproximateStreamPosition();
    }

    @Nullable
    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            return castSession.zzd();
        }
        return null;
    }

    @Nullable
    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzl;
    }

    @Pure
    @Nullable
    public CastDevice getCastDevice() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzk;
    }

    @Nullable
    public RemoteMediaClient getRemoteMediaClient() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzj;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<Status> sendMessage(@NonNull String namespace, @NonNull String message) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession == null) {
            castSession = new Status(17);
            return PendingResults.immediatePendingResult((Status)castSession);
        }
        return zzbm.zza(castSession.zzh((String)var1_1, (String)var2_2), com.google.android.gms.cast.framework.zze.zza, com.google.android.gms.cast.framework.zzf.zza);
    }

    @Nullable
    public String getApplicationStatus() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            return castSession.zzj();
        }
        return null;
    }

    static {
        Logger logger;
        zzb = logger = new Logger("CastSession");
    }

    /*
     * WARNING - void declaration
     */
    public void addCastListener(@NonNull Cast.Listener listener) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 != null) {
            this.zzd.add(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void end(boolean stopCasting) {
        zzaa zzaa2 = this.zze;
        if (zzaa2 == null) {
            return;
        }
        try {
            void var1_1;
            zzaa2.zze((boolean)var1_1, 0);
        }
        catch (RemoteException remoteException) {
            zzaa2 = zzb;
            Object[] objectArray = new Object[]{"disconnectFromDevice", zzaa.class.getSimpleName()};
            zzaa2.d(remoteException, "Unable to call %s on %s.", objectArray);
        }
        this.notifySessionEnded(0);
        this.zzo();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onResuming(@Nullable Bundle routeInfoExtra) {
        void var1_1;
        this.zzk = CastDevice.getFromBundle((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onStarting(@Nullable Bundle routeInfoExtra) {
        void var1_1;
        this.zzk = CastDevice.getFromBundle((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeCastListener(@NonNull Cast.Listener listener) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 != null) {
            this.zzd.remove(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeMessageReceivedCallbacks(@NonNull String namespace) throws IOException, IllegalArgumentException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null) {
            void var1_1;
            castSession.zzg((String)var1_1);
            return;
        }
    }

    public void requestStatus() throws IOException, IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null) {
            TaskApiCall.Builder builder = TaskApiCall.builder();
            zzbb zzbb2 = zzbb.zza;
            builder = builder.run((RemoteCall)zzbb2);
            builder = builder.setMethodKey(8404);
            builder = builder.build();
            ((zzbt)castSession).doWrite((TaskApiCall)builder);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void resume(@Nullable Bundle routeInfoExtra) {
        void var1_1;
        this.zzn((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setMessageReceivedCallbacks(@NonNull String namespace, @NonNull Cast.MessageReceivedCallback callbacks) throws IOException, IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            void var2_2;
            void var1_1;
            castSession.zzi((String)var1_1, (Cast.MessageReceivedCallback)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMute(boolean mute) throws IOException, IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            void var1_1;
            TaskApiCall.Builder builder = TaskApiCall.builder();
            zzbc zzbc2 = new zzbc((zzbt)castSession, (boolean)var1_1);
            TaskApiCall.Builder builder2 = builder.run((RemoteCall)zzbc2);
            builder2 = builder2.setMethodKey(8412);
            builder2 = builder2.build();
            ((zzbt)castSession).doWrite((TaskApiCall)builder2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setVolume(double volume) throws IOException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Object object = ((CastSession)object).zzi;
        if (object != null && object.zzl()) {
            void var1_1;
            if (Double.isInfinite((double)var1_1) || Double.isNaN((double)var1_1)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Volume cannot be ");
                stringBuilder.append((double)var1_1);
                object = new IllegalArgumentException(stringBuilder.toString());
                throw object;
            }
            TaskApiCall.Builder builder = TaskApiCall.builder();
            zzbh zzbh2 = new zzbh((zzbt)object, (double)var1_1);
            builder = builder.run((RemoteCall)zzbh2);
            builder = builder.setMethodKey(8411);
            builder = builder.build();
            ((zzbt)object).doWrite((TaskApiCall)builder);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void start(@Nullable Bundle routeInfoExtra) {
        void var1_1;
        this.zzn((Bundle)var1_1);
    }

    public boolean isMute() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        return castSession != null && castSession.zzl() && castSession.zzm();
    }

    static /* bridge */ /* synthetic */ zzr zza(CastSession castSession) {
        return castSession.zzi;
    }

    static /* bridge */ /* synthetic */ zzaa zzb(CastSession castSession) {
        return castSession.zze;
    }

    static /* bridge */ /* synthetic */ RemoteMediaClient zzc(CastSession castSession) {
        return castSession.zzj;
    }

    public final com.google.android.gms.cast.framework.media.internal.zzr zzd() {
        return this.zzh;
    }

    static /* bridge */ /* synthetic */ Logger zze() {
        return zzb;
    }

    static /* bridge */ /* synthetic */ Set zzf(CastSession castSession) {
        return castSession.zzd;
    }

    static /* bridge */ /* synthetic */ void zzg(CastSession castSession, int n) {
        castSession.zzh.zzj(n);
        Object object = castSession.zzi;
        if (object != null) {
            object.zzf();
            castSession.zzi = null;
        }
        castSession.zzk = null;
        object = castSession.zzj;
        if (object != null) {
            ((RemoteMediaClient)object).zzr(null);
            castSession.zzj = null;
        }
        castSession.zzl = null;
    }

    static /* bridge */ /* synthetic */ void zzh(CastSession castSession) {
        castSession.zzo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ void zzi(CastSession castSession, String object, Task applicationConnectionResult) {
        if (castSession.zze == null) {
            return;
        }
        try {
            block11: {
                block10: {
                    block9: {
                        boolean bl;
                        boolean bl2 = applicationConnectionResult.isSuccessful();
                        if (!bl2) break block9;
                        castSession.zzl = applicationConnectionResult = (Cast.ApplicationConnectionResult)applicationConnectionResult.getResult();
                        Status status = applicationConnectionResult.getStatus();
                        if (status != null && (bl = applicationConnectionResult.getStatus().isSuccess())) {
                            Logger logger = zzb;
                            Object[] objectArray = new Object[]{object};
                            logger.d("%s() -> success result", objectArray);
                            logger = new zzas(null);
                            castSession.zzj = object = new RemoteMediaClient((zzas)logger);
                            castSession.zzj.zzr(castSession.zzi);
                            castSession.zzj.zzo();
                            castSession.zzh.zzi(castSession.zzj, castSession.getCastDevice());
                            castSession.zze.zzf((ApplicationMetadata)Preconditions.checkNotNull((Object)applicationConnectionResult.getApplicationMetadata()), applicationConnectionResult.getApplicationStatus(), (String)Preconditions.checkNotNull((Object)applicationConnectionResult.getSessionId()), applicationConnectionResult.getWasLaunched());
                            return;
                        }
                        Status status2 = applicationConnectionResult.getStatus();
                        if (status2 != null) {
                            status2 = zzb;
                            Object[] objectArray = new Object[]{object};
                            status2.d("%s() -> failure result", objectArray);
                            castSession.zze.zzg(applicationConnectionResult.getStatus().getStatusCode());
                            return;
                        }
                        break block10;
                    }
                    object = applicationConnectionResult.getException();
                    boolean bl = object instanceof ApiException;
                    if (bl) break block11;
                }
                castSession.zze.zzg(2476);
                return;
            }
            castSession.zze.zzg(((ApiException)object).getStatusCode());
            return;
        }
        catch (RemoteException remoteException) {
            object = zzb;
            applicationConnectionResult = new Cast.ApplicationConnectionResult[]{"methods", zzaa.class.getSimpleName()};
            object.d((Throwable)remoteException, "Unable to call %s on %s.", (Object[])applicationConnectionResult);
            return;
        }
    }

    public CastSession(Context context, String iObjectWrapper, @Nullable String object, CastOptions castOptions, zzbd zzbd2, com.google.android.gms.cast.framework.media.internal.zzr zzr2) {
        zzg zzg2 = com.google.android.gms.cast.framework.zzg.zza;
        super(context, (String)iObjectWrapper, (String)object);
        this.zzd = iObjectWrapper = new HashSet();
        this.zzc = context.getApplicationContext();
        this.zzf = castOptions;
        this.zzg = zzbd2;
        this.zzh = zzr2;
        this.zzn = zzg2;
        iObjectWrapper = this.zzm();
        object = new zzk(this, null);
        this.zze = zzad.zzb(context, castOptions, iObjectWrapper, (zzu)object);
    }

    public final synchronized void zzj(@Nullable com.google.android.gms.internal.cast.zzbh zzbh2) {
        this.zzm = zzbh2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void zzn(@Nullable Bundle object) {
        void var2_8;
        void var2_6;
        this.zzk = CastDevice.getFromBundle((Bundle)object);
        if (this.zzk == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(2153);
                return;
            }
            this.notifyFailedToStartSession(2151);
            return;
        }
        object = this.zzi;
        if (object != null) {
            object.zzf();
            this.zzi = null;
        }
        object = zzb;
        Object[] objectArray = new Object[]{this.zzk};
        object.d("Acquiring a connection to Google Play Services for %s", objectArray);
        CastDevice castDevice = (CastDevice)Preconditions.checkNotNull((Object)this.zzk);
        Bundle bundle = new Bundle();
        object = this.zzf;
        object = object == null ? null : ((CastOptions)((Object)object)).getCastMediaOptions();
        if (object == null) {
            Object var2_5 = null;
        } else {
            NotificationOptions notificationOptions = ((CastMediaOptions)((Object)object)).getNotificationOptions();
        }
        boolean bl = object != null ? ((CastMediaOptions)((Object)object)).zza() : false;
        if (var2_6 != null) {
            boolean bl2 = true;
        } else {
            boolean bl3 = false;
        }
        bundle.putBoolean("com.google.android.gms.cast.EXTRA_CAST_FRAMEWORK_NOTIFICATION_ENABLED", (boolean)var2_8);
        bundle.putBoolean("com.google.android.gms.cast.EXTRA_CAST_REMOTE_CONTROL_NOTIFICATION_ENABLED", bl);
        bundle.putBoolean("com.google.android.gms.cast.EXTRA_CAST_ALWAYS_FOLLOW_SESSION_ENABLED", this.zzg.zzs());
        zzm zzm2 = new zzm(this, null);
        Cast.CastOptions.Builder builder = new Cast.CastOptions.Builder(castDevice, (Cast.Listener)zzm2);
        builder.zzc(bundle);
        builder = builder.build();
        builder = Cast.zza((Context)this.zzc, (Cast.CastOptions)builder);
        zzo zzo2 = new zzo(this, null);
        builder.zzk((zzq)zzo2);
        this.zzi = builder;
        this.zzi.zze();
    }

    private final void zzo() {
        com.google.android.gms.internal.cast.zzbh zzbh2 = ((CastSession)((Object)zzbh2)).zzm;
        if (zzbh2 != null) {
            zzbh2.zze();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected final void zzk(@Nullable Bundle bundle) {
        Object object = CastDevice.getFromBundle((Bundle)bundle);
        if (object != null && !object.equals((Object)((CastSession)((Object)iterator)).zzk)) {
            Object object2;
            boolean bl = !TextUtils.isEmpty((CharSequence)object.getFriendlyName()) ? ((bundle = ((CastSession)((Object)iterator)).zzk) != null ? !TextUtils.equals((CharSequence)bundle.getFriendlyName(), (CharSequence)object.getFriendlyName()) : true) : false;
            ((CastSession)((Object)iterator)).zzk = object;
            Logger logger = zzb;
            Object[] objectArray = new Object[2];
            objectArray[0] = ((CastSession)((Object)iterator)).zzk;
            object = true != bl ? "unchanged" : "changed";
            objectArray[1] = object;
            logger.d("update to device (%s) with name %s", objectArray);
            if (bl && (object2 = ((CastSession)((Object)iterator)).zzk) != null) {
                object = ((CastSession)((Object)iterator)).zzh;
                if (object != null) {
                    ((com.google.android.gms.cast.framework.media.internal.zzr)object).zzl((CastDevice)object2);
                }
                object2 = new HashSet(((CastSession)((Object)iterator)).zzd);
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    ((Cast.Listener)iterator.next()).onDeviceNameChanged();
                }
            }
        }
    }
}

