/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbbr;

@Hide
public final class zzbbq
extends UIController {
    private final ImageView zzfhq;
    private final ImageHints zzfgq;
    private final Bitmap zzfhu;
    private final View zzfhv;
    private final ImagePicker zzfdu;
    private final zzbax zzfhs;

    public zzbbq(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n, View view) {
        CastMediaOptions castMediaOptions;
        this.zzfhq = imageView;
        this.zzfgq = imageHints;
        this.zzfhu = n != 0 ? BitmapFactory.decodeResource((Resources)context.getResources(), (int)n) : null;
        this.zzfhv = view;
        CastContext castContext = CastContext.zzbu(context);
        this.zzfdu = castContext != null ? ((castMediaOptions = castContext.getCastOptions().getCastMediaOptions()) != null ? castMediaOptions.getImagePicker() : null) : null;
        this.zzfhs = new zzbax(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzfhs.zza(new zzbbr(this));
        this.zzafz();
        this.zzafy();
    }

    @Override
    public final void onSessionEnded() {
        this.zzfhs.clear();
        this.zzafz();
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzafy();
    }

    private final void zzafy() {
        WebImage webImage;
        Uri uri;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzafz();
            return;
        }
        MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
        zzbbq zzbbq2 = this;
        if ((mediaInfo == null ? null : (uri = zzbbq2.zzfdu != null && (webImage = zzbbq2.zzfdu.onPickImage(mediaInfo.getMetadata(), zzbbq2.zzfgq)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0))) == null) {
            this.zzafz();
            return;
        }
        this.zzfhs.zzl(uri);
    }

    private final void zzafz() {
        if (this.zzfhv != null) {
            this.zzfhv.setVisibility(0);
            this.zzfhq.setVisibility(4);
        }
        if (this.zzfhu != null) {
            this.zzfhq.setImageBitmap(this.zzfhu);
        }
    }

    static /* synthetic */ View zza(zzbbq zzbbq2) {
        return zzbbq2.zzfhv;
    }

    static /* synthetic */ ImageView zzb(zzbbq zzbbq2) {
        return zzbbq2.zzfhq;
    }
}

