/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaLoadOptions;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.framework.media.zzaa;
import com.google.android.gms.cast.framework.media.zzab;
import com.google.android.gms.cast.framework.media.zzac;
import com.google.android.gms.cast.framework.media.zzad;
import com.google.android.gms.cast.framework.media.zzae;
import com.google.android.gms.cast.framework.media.zzaf;
import com.google.android.gms.cast.framework.media.zzag;
import com.google.android.gms.cast.framework.media.zzah;
import com.google.android.gms.cast.framework.media.zzai;
import com.google.android.gms.cast.framework.media.zzaj;
import com.google.android.gms.cast.framework.media.zzak;
import com.google.android.gms.cast.framework.media.zzal;
import com.google.android.gms.cast.framework.media.zzam;
import com.google.android.gms.cast.framework.media.zzan;
import com.google.android.gms.cast.framework.media.zzao;
import com.google.android.gms.cast.framework.media.zzap;
import com.google.android.gms.cast.framework.media.zzaq;
import com.google.android.gms.cast.framework.media.zzn;
import com.google.android.gms.cast.framework.media.zzo;
import com.google.android.gms.cast.framework.media.zzp;
import com.google.android.gms.cast.framework.media.zzq;
import com.google.android.gms.cast.framework.media.zzr;
import com.google.android.gms.cast.framework.media.zzs;
import com.google.android.gms.cast.framework.media.zzt;
import com.google.android.gms.cast.framework.media.zzu;
import com.google.android.gms.cast.framework.media.zzv;
import com.google.android.gms.cast.framework.media.zzw;
import com.google.android.gms.cast.framework.media.zzx;
import com.google.android.gms.cast.framework.media.zzy;
import com.google.android.gms.cast.framework.media.zzz;
import com.google.android.gms.cast.zzbl;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbdf;
import com.google.android.gms.internal.zzbdp;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbek;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.internal.zzben;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class RemoteMediaClient
implements Cast.MessageReceivedCallback {
    private final Object mLock;
    private final Handler mHandler;
    private final zzbej zzext;
    private final zza zzffn;
    private final Cast.CastApi zzfam;
    private GoogleApiClient zzffo;
    private final List<Listener> zzffp = new CopyOnWriteArrayList<Listener>();
    private final Map<ProgressListener, zze> zzffq = new ConcurrentHashMap<ProgressListener, zze>();
    private final Map<Long, zze> zzffr = new ConcurrentHashMap<Long, zze>();
    private ParseAdsInfoCallback zzffs;
    public static final String NAMESPACE = zzbej.NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_REPLACED = 2103;

    @Hide
    public RemoteMediaClient(@NonNull zzbej zzbej2, @NonNull Cast.CastApi castApi) {
        this.mLock = new Object();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzffn = new zza();
        this.zzfam = castApi;
        this.zzext = (zzbej)zzbq.checkNotNull((Object)zzbej2);
        this.zzext.zza((zzbek)new zzn(this));
        this.zzext.zza((zzbem)this.zzffn);
    }

    @Hide
    public final void zzc(GoogleApiClient googleApiClient) {
        if (this.zzffo == googleApiClient) {
            return;
        }
        if (this.zzffo != null) {
            this.zzext.zzagm();
            try {
                this.zzfam.removeMessageReceivedCallbacks(this.zzffo, this.getNamespace());
            }
            catch (IOException iOException) {}
            this.zzffn.zzb(null);
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.zzffo = googleApiClient;
        if (this.zzffo != null) {
            this.zzffn.zzb(this.zzffo);
        }
    }

    @Hide
    public final void zzafl() throws IOException {
        if (this.zzffo != null) {
            this.zzfam.setMessageReceivedCallbacks(this.zzffo, this.getNamespace(), (Cast.MessageReceivedCallback)this);
        }
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo) {
        return this.load(mediaInfo, new MediaLoadOptions.Builder().build());
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl) {
        MediaLoadOptions mediaLoadOptions = new MediaLoadOptions.Builder().setAutoplay(bl).build();
        return this.load(mediaInfo, mediaLoadOptions);
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l) {
        MediaLoadOptions mediaLoadOptions = new MediaLoadOptions.Builder().setAutoplay(bl).setPlayPosition(l).build();
        return this.load(mediaInfo, mediaLoadOptions);
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        MediaLoadOptions mediaLoadOptions = new MediaLoadOptions.Builder().setAutoplay(bl).setPlayPosition(l).setCustomData(jSONObject).build();
        return this.load(mediaInfo, mediaLoadOptions);
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) {
        MediaLoadOptions mediaLoadOptions = new MediaLoadOptions.Builder().setAutoplay(bl).setPlayPosition(l).setActiveTrackIds(lArray).setCustomData(jSONObject).build();
        return this.load(mediaInfo, mediaLoadOptions);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, MediaLoadOptions mediaLoadOptions) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzy(this, this.zzffo, mediaInfo, mediaLoadOptions));
    }

    public PendingResult<MediaChannelResult> pause() {
        return this.pause(null);
    }

    public PendingResult<MediaChannelResult> pause(JSONObject jSONObject) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzaf(this, this.zzffo, jSONObject));
    }

    public PendingResult<MediaChannelResult> stop() {
        return this.stop(null);
    }

    public PendingResult<MediaChannelResult> stop(JSONObject jSONObject) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzag(this, this.zzffo, jSONObject));
    }

    public PendingResult<MediaChannelResult> play() {
        return this.play(null);
    }

    public PendingResult<MediaChannelResult> play(JSONObject jSONObject) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzah(this, this.zzffo, jSONObject));
    }

    public PendingResult<MediaChannelResult> seek(long l) {
        return this.seek(l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n) {
        return this.seek(l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n, JSONObject jSONObject) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzai(this, this.zzffo, l, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d) throws IllegalArgumentException {
        return this.setStreamVolume(d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return this.zza(new zzaj(this, this.zzffo, d, jSONObject));
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl) {
        return this.setStreamMute(bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl, JSONObject jSONObject) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzak(this, this.zzffo, bl, jSONObject));
    }

    public PendingResult<MediaChannelResult> setPlaybackRate(double d) {
        return this.setPlaybackRate(d, null);
    }

    public PendingResult<MediaChannelResult> setPlaybackRate(double d, JSONObject jSONObject) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        if (Double.compare(d, 2.0) > 0 || Double.compare(d, 0.5) < 0) {
            throw new IllegalArgumentException("playbackRate must be between PLAYBACK_RATE_MIN and PLAYBACK_RATE_MAX");
        }
        return this.zza(new zzal(this, this.zzffo, d, jSONObject));
    }

    public PendingResult<MediaChannelResult> requestStatus() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzo(this, this.zzffo));
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(long[] lArray) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return this.zza(new zzp(this, this.zzffo, lArray));
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(TextTrackStyle textTrackStyle) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return this.zza(new zzq(this, this.zzffo, textTrackStyle));
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzr(this, this.zzffo, mediaQueueItemArray, n, n2, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueInsertItems(MediaQueueItem[] mediaQueueItemArray, int n, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzs(this, this.zzffo, mediaQueueItemArray, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueAppendItem(MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, long l, JSONObject jSONObject) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzt(this, this.zzffo, mediaQueueItem, n, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(MediaQueueItem[] mediaQueueItemArray, JSONObject jSONObject) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzu(this, this.zzffo, mediaQueueItemArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(int[] nArray, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzv(this, this.zzffo, nArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueReorderItems(int[] nArray, int n, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzw(this, this.zzffo, nArray, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queuePrev(JSONObject jSONObject) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzx(this, this.zzffo, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueNext(JSONObject jSONObject) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzz(this, this.zzffo, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(int n, JSONObject jSONObject) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzaa(this, this.zzffo, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(int n, JSONObject jSONObject) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzab(this, this.zzffo, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, JSONObject jSONObject) {
        return this.queueJumpToItem(n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, long l, JSONObject jSONObject) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzac(this, this.zzffo, n, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(int n, int n2, JSONObject jSONObject) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzad(this, this.zzffo, n, n2, jSONObject));
    }

    @Hide
    public final PendingResult<MediaChannelResult> zza(String string2, List<zzbl> list) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (!this.zzafm()) {
            return RemoteMediaClient.zzafn();
        }
        return this.zza(new zzae(this, this.zzffo, true, string2, null));
    }

    private final int zzbc(int n) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.mLock;
        synchronized (object) {
            zzbq.zzgn((String)"Must be called from the main thread.");
            return this.zzext.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.mLock;
        synchronized (object) {
            zzbq.zzgn((String)"Must be called from the main thread.");
            return this.zzext.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.mLock;
        synchronized (object) {
            zzbq.zzgn((String)"Must be called from the main thread.");
            return this.zzext.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.mLock;
        synchronized (object) {
            zzbq.zzgn((String)"Must be called from the main thread.");
            return this.zzext.getMediaInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerState() {
        Object object = this.mLock;
        synchronized (object) {
            zzbq.zzgn((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getPlayerState() : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleReason() {
        Object object = this.mLock;
        synchronized (object) {
            zzbq.zzgn((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getIdleReason() : 0;
        }
    }

    public boolean isLiveStream() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null && mediaInfo.getStreamType() == 2;
    }

    public boolean isPlaying() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 2;
    }

    public boolean isPaused() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && (mediaStatus.getPlayerState() == 3 || this.isLiveStream() && this.getIdleReason() == 2);
    }

    public boolean isBuffering() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 4;
    }

    public boolean isLoadingNextItem() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getLoadingItemId() != 0;
    }

    public MediaQueueItem getCurrentItem() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getCurrentItemId());
    }

    public MediaQueueItem getLoadingItem() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getLoadingItemId());
    }

    public MediaQueueItem getPreloadedItem() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getPreloadedItemId());
    }

    public void togglePlayback() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        int n = this.getPlayerState();
        if (n == 4 || n == 2) {
            this.pause();
            return;
        }
        this.play();
    }

    public boolean hasMediaSession() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        return this.isBuffering() || this.isPlaying() || this.isPaused() || this.isLoadingNextItem();
    }

    public void addListener(Listener listener) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzffp.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzffp.remove(listener);
        }
    }

    public boolean addProgressListener(ProgressListener progressListener, long l) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (progressListener == null || this.zzffq.containsKey(progressListener)) {
            return false;
        }
        zze zze2 = this.zzffr.get(l);
        if (zze2 == null) {
            zze2 = new zze(l);
            this.zzffr.put(l, zze2);
        }
        zze2.zza(progressListener);
        this.zzffq.put(progressListener, zze2);
        if (this.hasMediaSession()) {
            zze2.start();
        }
        return true;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        zze zze2 = this.zzffq.remove(progressListener);
        if (zze2 != null) {
            zze2.zzb(progressListener);
            if (!zze2.zzafr()) {
                this.zzffr.remove(zze2.zzafq());
                zze2.stop();
            }
        }
    }

    public void setParseAdsInfoCallback(ParseAdsInfoCallback parseAdsInfoCallback) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        this.zzffs = parseAdsInfoCallback;
    }

    public boolean isPlayingAd() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.isPlayingAd();
    }

    public String getNamespace() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        return this.zzext.getNamespace();
    }

    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.zzext.zzfu(string3);
    }

    private final boolean zzafm() {
        return this.zzffo != null;
    }

    private static PendingResult<MediaChannelResult> zzafn() {
        zzd zzd2 = new zzd();
        zzd2.setResult(zzd2.zzk(new Status(17)));
        return zzd2;
    }

    private final zzb zza(zzb zzb2) {
        try {
            this.zzffo.zze((zzm)zzb2);
            return zzb2;
        }
        catch (IllegalStateException illegalStateException) {
            try {
                zzb2.setResult((MediaChannelResult)zzb2.zzb(new Status(2100)));
                return zzb2;
            }
            catch (Throwable throwable) {
                return zzb2;
            }
        }
    }

    private final void zza(Set<ProgressListener> set) {
        if (this.isBuffering() || this.isPaused()) {
            return;
        }
        HashSet<ProgressListener> hashSet = new HashSet<ProgressListener>(set);
        if (this.isPlaying()) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((ProgressListener)iterator.next()).onProgressUpdated(this.getApproximateStreamPosition(), this.getStreamDuration());
            }
            return;
        }
        if (this.isLoadingNextItem()) {
            MediaQueueItem mediaQueueItem = this.getLoadingItem();
            if (mediaQueueItem != null && mediaQueueItem.getMedia() != null) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    ((ProgressListener)iterator.next()).onProgressUpdated(0L, mediaQueueItem.getMedia().getStreamDuration());
                }
            }
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((ProgressListener)iterator.next()).onProgressUpdated(0L, 0L);
        }
    }

    private final void zzafo() {
        for (zze zze2 : this.zzffr.values()) {
            if (this.hasMediaSession() && !zze2.isStarted()) {
                zze2.start();
            } else if (!this.hasMediaSession() && zze2.isStarted()) {
                zze2.stop();
            }
            if (!zze2.isStarted() || !this.isBuffering() && !this.isPaused() && !this.isLoadingNextItem()) continue;
            this.zza(zze2.zzfgd);
        }
    }

    static /* synthetic */ void zza(RemoteMediaClient remoteMediaClient) {
        remoteMediaClient.zzafo();
    }

    static /* synthetic */ ParseAdsInfoCallback zzc(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzffs;
    }

    static /* synthetic */ Object zzd(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.mLock;
    }

    static /* synthetic */ zzbej zze(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzext;
    }

    static /* synthetic */ int zza(RemoteMediaClient remoteMediaClient, int n) {
        return remoteMediaClient.zzbc(n);
    }

    static /* synthetic */ void zza(RemoteMediaClient remoteMediaClient, Set set) {
        remoteMediaClient.zza(set);
    }

    final class zze {
        private final Set<ProgressListener> zzfgd = new HashSet<ProgressListener>();
        private final long zzfge;
        private final Runnable zzfgf;
        private boolean zzfgg;

        public zze(long l) {
            this.zzfge = l;
            this.zzfgf = new zzaq(this, RemoteMediaClient.this);
        }

        public final long zzafq() {
            return this.zzfge;
        }

        public final void zza(ProgressListener progressListener) {
            this.zzfgd.add(progressListener);
        }

        public final void zzb(ProgressListener progressListener) {
            this.zzfgd.remove(progressListener);
        }

        public final boolean zzafr() {
            return !this.zzfgd.isEmpty();
        }

        public final void start() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzfgf);
            this.zzfgg = true;
            RemoteMediaClient.this.mHandler.postDelayed(this.zzfgf, this.zzfge);
        }

        public final void stop() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzfgf);
            this.zzfgg = false;
        }

        public final boolean isStarted() {
            return this.zzfgg;
        }

        static /* synthetic */ long zzb(zze zze2) {
            return zze2.zzfge;
        }
    }

    abstract class zzb
    extends zzbdf<MediaChannelResult> {
        zzben zzezb;
        private final boolean zzfga;
        private /* synthetic */ RemoteMediaClient zzfft;

        zzb(RemoteMediaClient remoteMediaClient, GoogleApiClient googleApiClient) {
            this(remoteMediaClient, googleApiClient, false);
        }

        zzb(RemoteMediaClient remoteMediaClient, GoogleApiClient googleApiClient, boolean bl) {
            this.zzfft = remoteMediaClient;
            super(googleApiClient);
            this.zzfga = bl;
            this.zzezb = new zzan(this, remoteMediaClient);
        }

        abstract void zzb(zzbdp var1);

        protected final /* synthetic */ void zza(Api.zzb zzb2) throws RemoteException {
            zzbdp zzbdp2 = (zzbdp)zzb2;
            zzb zzb3 = this;
            if (!zzb3.zzfga) {
                Iterator iterator = zzb3.zzfft.zzffp.iterator();
                while (iterator.hasNext()) {
                    ((Listener)iterator.next()).onSendingRemoteMediaRequest();
                }
            }
            zzb3.zzb(zzbdp2);
        }

        public final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            zzb zzb2 = this;
            return new zzao(zzb2, status2);
        }
    }

    static final class zzc
    implements MediaChannelResult {
        private final Status mStatus;
        private final JSONObject zzess;

        zzc(Status status, JSONObject jSONObject) {
            this.mStatus = status;
            this.zzess = jSONObject;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final JSONObject getCustomData() {
            return this.zzess;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    final class zza
    implements zzbem {
        private GoogleApiClient zzeyx;
        private long zzeyy = 0L;

        public final void zzb(GoogleApiClient googleApiClient) {
            this.zzeyx = googleApiClient;
        }

        public final void zza(String string2, String string3, long l, String string4) {
            if (this.zzeyx == null) {
                throw new IllegalStateException("No GoogleApiClient available");
            }
            RemoteMediaClient.this.zzfam.sendMessage(this.zzeyx, string2, string3).setResultCallback((ResultCallback)new zzam(this, l));
        }

        public final long zzadw() {
            return ++this.zzeyy;
        }
    }

    static final class zzd
    extends BasePendingResult<MediaChannelResult> {
        zzd() {
            super(null);
        }

        @NonNull
        protected final MediaChannelResult zzk(Status status) {
            return new zzap(this, status);
        }

        @NonNull
        protected final /* synthetic */ Result zzb(Status status) {
            return this.zzk(status);
        }
    }

    public static interface ParseAdsInfoCallback {
        public boolean parseIsPlayingAdFromMediaStatus(MediaStatus var1);

        public List<AdBreakInfo> parseAdBreaksFromMediaStatus(MediaStatus var1);
    }

    public static interface ProgressListener {
        public void onProgressUpdated(long var1, long var3);
    }

    public static interface Listener {
        public void onStatusUpdated();

        public void onMetadataUpdated();

        public void onQueueStatusUpdated();

        public void onPreloadStatusUpdated();

        public void onSendingRemoteMediaRequest();

        public void onAdBreakStatusUpdated();
    }
}

