/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.Keep;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzdny;

@Hide
class InnerZoneDrawable
extends Drawable {
    private final Paint zzfby = new Paint();
    private final Paint zzfcy = new Paint();
    private final Rect zzfcd = new Rect();
    private final int zzfcz;
    private final int zzfda;
    private float zzfbz;
    private float zzfdb = 1.0f;
    private float centerX;
    private float centerY;
    private float zzfdc;
    private float zzfdd;

    public InnerZoneDrawable(Context context) {
        Resources resources = context.getResources();
        this.zzfcz = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        this.zzfda = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.zzfby.setAntiAlias(true);
        this.zzfby.setStyle(Paint.Style.FILL);
        this.zzfcy.setAntiAlias(true);
        this.zzfcy.setStyle(Paint.Style.FILL);
        InnerZoneDrawable innerZoneDrawable = this;
        innerZoneDrawable.zzfby.setColor(-1);
        innerZoneDrawable.zzfcy.setColor(-1);
        innerZoneDrawable.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        if (this.zzfdd > 0.0f) {
            float f = this.zzfbz * this.zzfdc;
            this.zzfcy.setAlpha((int)((float)this.zzfda * this.zzfdd));
            canvas.drawCircle(this.centerX, this.centerY, f, this.zzfcy);
        }
        canvas.drawCircle(this.centerX, this.centerY, this.zzfbz * this.zzfdb, this.zzfby);
    }

    public void setAlpha(int n) {
        this.zzfby.setAlpha(n);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzfby.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    @Keep
    public void setScale(float f) {
        this.zzfdb = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseScale(float f) {
        this.zzfdc = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseAlpha(float f) {
        this.zzfdd = f;
        this.invalidateSelf();
    }

    public final void zzc(Rect rect) {
        this.zzfcd.set(rect);
        this.centerX = this.zzfcd.exactCenterX();
        this.centerY = this.zzfcd.exactCenterY();
        this.zzfbz = Math.max((float)this.zzfcz, Math.max((float)this.zzfcd.width() / 2.0f, (float)this.zzfcd.height() / 2.0f));
        this.invalidateSelf();
    }

    public final Animator zzaff() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{0.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzdny.zzbmj());
        return objectAnimator.setDuration(200L);
    }
}

