/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private String zzfad;
    private final List<String> zzfae;
    private final boolean zzfaf;
    private final LaunchOptions zzevx;
    private final boolean zzfag;
    private final CastMediaOptions zzfah;
    private final boolean zzfai;
    private final double zzfaj;

    CastOptions(String string2, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.zzfad = TextUtils.isEmpty((CharSequence)string2) ? "" : string2;
        int n = list == null ? 0 : list.size();
        this.zzfae = new ArrayList<String>(n);
        if (n > 0) {
            this.zzfae.addAll(list);
        }
        this.zzfaf = bl;
        this.zzevx = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.zzfag = bl2;
        this.zzfah = castMediaOptions;
        this.zzfai = bl3;
        this.zzfaj = d;
    }

    public String getReceiverApplicationId() {
        return this.zzfad;
    }

    @Hide
    public final void setReceiverApplicationId(String string2) {
        this.zzfad = string2;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzfae);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.zzfaf;
    }

    public LaunchOptions getLaunchOptions() {
        return this.zzevx;
    }

    public boolean getResumeSavedSession() {
        return this.zzfag;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.zzfah;
    }

    public boolean getEnableReconnectionService() {
        return this.zzfai;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.zzfaj;
    }

    @Hide
    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastOptions castOptions = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)castOptions.getReceiverApplicationId(), (boolean)false);
        zzbgo.zzb((Parcel)parcel2, (int)3, castOptions.getSupportedNamespaces(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (boolean)castOptions.getStopReceiverApplicationWhenEndingSession());
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable)castOptions.getLaunchOptions(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (boolean)castOptions.getResumeSavedSession());
        zzbgo.zza((Parcel)parcel2, (int)7, (Parcelable)castOptions.getCastMediaOptions(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (boolean)castOptions.getEnableReconnectionService());
        zzbgo.zza((Parcel)parcel2, (int)9, (double)castOptions.getVolumeDeltaBeforeIceCreamSandwich());
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private String zzfad;
        private List<String> zzfae = new ArrayList<String>();
        private boolean zzfaf;
        private LaunchOptions zzevx = new LaunchOptions();
        private boolean zzfag = true;
        private CastMediaOptions zzfah = new CastMediaOptions.Builder().build();
        private boolean zzfai = true;
        private double zzfaj = 0.05f;

        public Builder() {
        }

        public final Builder setReceiverApplicationId(String string2) {
            this.zzfad = string2;
            return this;
        }

        public final Builder setSupportedNamespaces(List<String> list) {
            this.zzfae = list;
            return this;
        }

        public final Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.zzfaf = bl;
            return this;
        }

        public final Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.zzevx = launchOptions;
            return this;
        }

        public final Builder setResumeSavedSession(boolean bl) {
            this.zzfag = bl;
            return this;
        }

        public final Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.zzfah = castMediaOptions;
            return this;
        }

        public final Builder setEnableReconnectionService(boolean bl) {
            this.zzfai = bl;
            return this;
        }

        public final Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.zzfaj = d;
            return this;
        }

        public final CastOptions build() {
            return new CastOptions(this.zzfad, this.zzfae, this.zzfaf, this.zzevx, this.zzfag, this.zzfah, this.zzfai, this.zzfaj);
        }
    }
}

