/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.phenotype;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.phenotype.Flag;
import com.google.android.gms.phenotype.zza;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class Configuration
extends AbstractSafeParcelable
implements Comparable<Configuration> {
    public static final Parcelable.Creator<Configuration> CREATOR = new zza();
    final int mVersionCode;
    public final int aAs;
    public final Flag[] aAt;
    public final String[] aAu;
    public final Map<String, Flag> aAv;

    Configuration(int n, int n2, Flag[] flagArray, String[] stringArray) {
        this.mVersionCode = n;
        this.aAs = n2;
        this.aAt = flagArray;
        this.aAv = new TreeMap<String, Flag>();
        for (Flag flag : flagArray) {
            this.aAv.put(flag.name, flag);
        }
        this.aAu = stringArray;
        if (this.aAu != null) {
            Arrays.sort(this.aAu);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Configuration(");
        stringBuilder.append(this.mVersionCode);
        stringBuilder.append(", ");
        stringBuilder.append(this.aAs);
        stringBuilder.append(", ");
        stringBuilder.append("(");
        for (Flag flag : this.aAv.values()) {
            stringBuilder.append(flag);
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        stringBuilder.append(", ");
        stringBuilder.append("(");
        if (this.aAu != null) {
            for (String string2 : this.aAu) {
                stringBuilder.append(string2);
                stringBuilder.append(", ");
            }
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Configuration) {
            Configuration configuration = (Configuration)object;
            return this.mVersionCode == configuration.mVersionCode && this.aAs == configuration.aAs && zzz.equal(this.aAv, configuration.aAv) && Arrays.equals(this.aAu, configuration.aAu);
        }
        return false;
    }

    public int zza(Configuration configuration) {
        return this.aAs - configuration.aAs;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zza((Configuration)object);
    }
}

