/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.android.gms.internal.zzb;
import com.google.android.gms.internal.zzd;
import com.google.android.gms.internal.zzi;
import com.google.android.gms.internal.zzl;
import com.google.android.gms.internal.zzm;
import com.google.android.gms.internal.zzo;
import com.google.android.gms.internal.zzr;
import com.google.android.gms.internal.zzs;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;

public abstract class zzk<T>
implements Comparable<zzk<T>> {
    private final zzs.zza zzac = zzs.zza.zzbj ? new zzs.zza() : null;
    private final int zzad;
    private final String zzae;
    private final int zzaf;
    private final zzm.zza zzag;
    private Integer zzah;
    private zzl zzai;
    private boolean zzaj = true;
    private boolean zzak = false;
    private boolean zzal = false;
    private long zzam = 0L;
    private zzo zzan;
    private zzb.zza zzao = null;

    public zzk(int n, String string2, zzm.zza zza2) {
        this.zzad = n;
        this.zzae = string2;
        this.zzag = zza2;
        this.zza(new zzd());
        this.zzaf = zzk.zzb(string2);
    }

    public int getMethod() {
        return this.zzad;
    }

    public int zzf() {
        return this.zzaf;
    }

    private static int zzb(String string2) {
        String string3;
        Uri uri;
        if (!TextUtils.isEmpty((CharSequence)string2) && (uri = Uri.parse((String)string2)) != null && (string3 = uri.getHost()) != null) {
            return string3.hashCode();
        }
        return 0;
    }

    public zzk<?> zza(zzo zzo2) {
        this.zzan = zzo2;
        return this;
    }

    public void zzc(String string2) {
        if (zzs.zza.zzbj) {
            this.zzac.zza(string2, Thread.currentThread().getId());
        } else if (this.zzam == 0L) {
            this.zzam = SystemClock.elapsedRealtime();
        }
    }

    void zzd(final String string2) {
        if (this.zzai != null) {
            this.zzai.zzf(this);
        }
        if (zzs.zza.zzbj) {
            final long l = Thread.currentThread().getId();
            if (Looper.myLooper() != Looper.getMainLooper()) {
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        zzk.this.zzac.zza(string2, l);
                        zzk.this.zzac.zzd(this.toString());
                    }
                });
                return;
            }
            this.zzac.zza(string2, l);
            this.zzac.zzd(this.toString());
        } else {
            long l = SystemClock.elapsedRealtime() - this.zzam;
            if (l >= 3000L) {
                zzs.zzb("%d ms: %s", l, this.toString());
            }
        }
    }

    public zzk<?> zza(zzl zzl2) {
        this.zzai = zzl2;
        return this;
    }

    public final zzk<?> zza(int n) {
        this.zzah = n;
        return this;
    }

    public String getUrl() {
        return this.zzae;
    }

    public String zzg() {
        return this.getUrl();
    }

    public zzk<?> zza(zzb.zza zza2) {
        this.zzao = zza2;
        return this;
    }

    public zzb.zza zzh() {
        return this.zzao;
    }

    public boolean isCanceled() {
        return false;
    }

    public Map<String, String> getHeaders() throws com.google.android.gms.internal.zza {
        return Collections.emptyMap();
    }

    @Deprecated
    protected Map<String, String> zzi() throws com.google.android.gms.internal.zza {
        return null;
    }

    @Deprecated
    protected String zzj() {
        return this.zzm();
    }

    @Deprecated
    public String zzk() {
        return this.zzn();
    }

    @Deprecated
    public byte[] zzl() throws com.google.android.gms.internal.zza {
        Map<String, String> map = this.zzi();
        if (map != null && map.size() > 0) {
            return this.zza(map, this.zzj());
        }
        return null;
    }

    protected String zzm() {
        return "UTF-8";
    }

    public String zzn() {
        String string2 = String.valueOf(this.zzm());
        return string2.length() != 0 ? "application/x-www-form-urlencoded; charset=".concat(string2) : new String("application/x-www-form-urlencoded; charset=");
    }

    public byte[] zzo() throws com.google.android.gms.internal.zza {
        Object var1_1 = null;
        return null;
    }

    private byte[] zza(Map<String, String> map, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringBuilder.append(URLEncoder.encode(entry.getKey(), string2));
                stringBuilder.append('=');
                stringBuilder.append(URLEncoder.encode(entry.getValue(), string2));
                stringBuilder.append('&');
            }
            return stringBuilder.toString().getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string3 = String.valueOf(string2);
            throw new RuntimeException(string3.length() != 0 ? "Encoding not supported: ".concat(string3) : new String("Encoding not supported: "), unsupportedEncodingException);
        }
    }

    public final boolean zzp() {
        return this.zzaj;
    }

    public zza zzq() {
        return zza.zzat;
    }

    public final int zzr() {
        return this.zzan.zzc();
    }

    public zzo zzs() {
        return this.zzan;
    }

    public void zzt() {
        this.zzal = true;
    }

    public boolean zzu() {
        return this.zzal;
    }

    protected abstract zzm<T> zza(zzi var1);

    protected zzr zzb(zzr zzr2) {
        return zzr2;
    }

    protected abstract void zza(T var1);

    public void zzc(zzr zzr2) {
        if (this.zzag != null) {
            this.zzag.zze(zzr2);
        }
    }

    public int zzc(zzk<T> zzk2) {
        zza zza2;
        zza zza3 = this.zzq();
        return zza3 == (zza2 = zzk2.zzq()) ? this.zzah - zzk2.zzah : zza2.ordinal() - zza3.ordinal();
    }

    public String toString() {
        String string2 = String.valueOf(Integer.toHexString(this.zzf()));
        String string3 = string2.length() != 0 ? "0x".concat(string2) : new String("0x");
        String string4 = "[ ] ";
        String string5 = String.valueOf(this.getUrl());
        String string6 = String.valueOf((Object)this.zzq());
        String string7 = String.valueOf(this.zzah);
        return new StringBuilder(3 + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string3).length() + String.valueOf(string6).length() + String.valueOf(string7).length()).append(string4).append(string5).append(" ").append(string3).append(" ").append(string6).append(" ").append(string7).toString();
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zzc((zzk)object);
    }

    public static final class zza
    extends Enum<zza> {
        public static final /* enum */ zza zzas = new zza();
        public static final /* enum */ zza zzat = new zza();
        public static final /* enum */ zza zzau = new zza();
        public static final /* enum */ zza zzav = new zza();
        private static final /* synthetic */ zza[] zzaw;

        public static zza[] values() {
            return (zza[])zzaw.clone();
        }

        static {
            zzaw = new zza[]{zzas, zzat, zzau, zzav};
        }
    }
}

