/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzaou;
import com.google.android.gms.internal.zzaoz;
import com.google.android.gms.internal.zzapw;
import com.google.android.gms.internal.zzapx;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzaqo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class zzaps {
    private final Map<Type, zzaou<?>> bop;

    public zzaps(Map<Type, zzaou<?>> map) {
        this.bop = map;
    }

    public <T> zzapx<T> zzb(zzaqo<T> zzaqo2) {
        final Type type = zzaqo2.bC();
        Class<T> clazz = zzaqo2.bB();
        final zzaou<?> zzaou2 = this.bop.get(type);
        if (zzaou2 != null) {
            return new zzapx<T>(){

                @Override
                public T bj() {
                    return zzaou2.zza(type);
                }
            };
        }
        final zzaou<?> zzaou3 = this.bop.get(clazz);
        if (zzaou3 != null) {
            return new zzapx<T>(){

                @Override
                public T bj() {
                    return zzaou3.zza(type);
                }
            };
        }
        zzapx<T> zzapx2 = this.zzl(clazz);
        if (zzapx2 != null) {
            return zzapx2;
        }
        zzapx<T> zzapx3 = this.zzc(type, clazz);
        if (zzapx3 != null) {
            return zzapx3;
        }
        return this.zzd(type, clazz);
    }

    private <T> zzapx<T> zzl(Class<? super T> clazz) {
        try {
            final Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new zzapx<T>(){

                @Override
                public T bj() {
                    try {
                        Object var1_1 = null;
                        return constructor.newInstance(null);
                    }
                    catch (InstantiationException instantiationException) {
                        String string2 = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string2).length()).append("Failed to invoke ").append(string2).append(" with no args").toString(), instantiationException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        String string3 = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string3).length()).append("Failed to invoke ").append(string3).append(" with no args").toString(), invocationTargetException.getTargetException());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new AssertionError((Object)illegalAccessException);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private <T> zzapx<T> zzc(final Type type, Class<? super T> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new zzapx<T>(){

                    @Override
                    public T bj() {
                        return new TreeSet();
                    }
                };
            }
            if (EnumSet.class.isAssignableFrom(clazz)) {
                return new zzapx<T>(){

                    @Override
                    public T bj() {
                        if (type instanceof ParameterizedType) {
                            Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
                            if (type2 instanceof Class) {
                                return EnumSet.noneOf((Class)type2);
                            }
                            String string2 = String.valueOf(type.toString());
                            throw new zzaoz(string2.length() != 0 ? "Invalid EnumSet type: ".concat(string2) : new String("Invalid EnumSet type: "));
                        }
                        String string3 = String.valueOf(type.toString());
                        throw new zzaoz(string3.length() != 0 ? "Invalid EnumSet type: ".concat(string3) : new String("Invalid EnumSet type: "));
                    }
                };
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new zzapx<T>(){

                    @Override
                    public T bj() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return new zzapx<T>(){

                    @Override
                    public T bj() {
                        return new LinkedList();
                    }
                };
            }
            return new zzapx<T>(){

                @Override
                public T bj() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return new zzapx<T>(){

                    @Override
                    public T bj() {
                        return new TreeMap();
                    }
                };
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(zzaqo.zzl(((ParameterizedType)type).getActualTypeArguments()[0]).bB())) {
                return new zzapx<T>(){

                    @Override
                    public T bj() {
                        return new LinkedHashMap();
                    }
                };
            }
            return new zzapx<T>(){

                @Override
                public T bj() {
                    return new zzapw();
                }
            };
        }
        return null;
    }

    private <T> zzapx<T> zzd(final Type type, final Class<? super T> clazz) {
        return new zzapx<T>(){
            private final zzaqa boS = zzaqa.bo();

            @Override
            public T bj() {
                try {
                    Object t = this.boS.zzf(clazz);
                    return t;
                }
                catch (Exception exception) {
                    String string2 = String.valueOf(type);
                    throw new RuntimeException(new StringBuilder(116 + String.valueOf(string2).length()).append("Unable to invoke no-args constructor for ").append(string2).append(". ").append("Register an InstanceCreator with Gson for this type may fix this problem.").toString(), exception);
                }
            }
        };
    }

    public String toString() {
        return this.bop.toString();
    }
}

