/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.server.converter.ConverterWrapper;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.common.util.zzc;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.common.util.zzq;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class FastJsonResponse {
    public abstract Map<String, Field<?, ?>> zzawz();

    protected abstract Object zzic(String var1);

    protected boolean zza(Field field) {
        if (field.zzaxc() == 11) {
            if (field.zzaxd()) {
                return this.zzif(field.zzaxe());
            }
            return this.zzie(field.zzaxe());
        }
        return this.zzid(field.zzaxe());
    }

    protected abstract boolean zzid(String var1);

    protected boolean zzie(String string2) {
        throw new UnsupportedOperationException("Concrete types not supported");
    }

    protected boolean zzif(String string2) {
        throw new UnsupportedOperationException("Concrete type arrays not supported");
    }

    protected <O, I> I zza(Field<I, O> field, Object object) {
        if (((Field)field).Fp != null) {
            return field.convertBack(object);
        }
        return (I)object;
    }

    public String toString() {
        Map<String, Field<?, ?>> map = this.zzawz();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.zza(field)) continue;
            Object object = this.zzb(field);
            Object obj = this.zza(field, object);
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"").append(string2).append("\":");
            if (obj == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.zzaxc()) {
                case 8: {
                    stringBuilder.append("\"").append(zzc.zzq((byte[])obj)).append("\"");
                    continue block5;
                }
                case 9: {
                    stringBuilder.append("\"").append(zzc.zzr((byte[])obj)).append("\"");
                    continue block5;
                }
                case 10: {
                    HashMap hashMap = (HashMap)obj;
                    zzq.zza(stringBuilder, hashMap);
                    continue block5;
                }
            }
            if (field.zzaxb()) {
                this.zza(stringBuilder, field, (ArrayList)obj);
                continue;
            }
            this.zza(stringBuilder, field, obj);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
        } else {
            stringBuilder.append("{}");
        }
        return stringBuilder.toString();
    }

    protected Object zzb(Field field) {
        String string2 = field.zzaxe();
        if (field.zzaxg() != null) {
            zzaa.zza(this.zzic(field.zzaxe()) == null, "Concrete field shouldn't be value object: %s", field.zzaxe());
            Object var3_3 = field.zzaxd() ? null : null;
            try {
                char c = Character.toUpperCase(string2.charAt(0));
                String string3 = String.valueOf(string2.substring(1));
                String string4 = new StringBuilder(4 + String.valueOf(string3).length()).append("get").append(c).append(string3).toString();
                return this.getClass().getMethod(string4, new Class[0]).invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.zzic(field.zzaxe());
    }

    private void zza(StringBuilder stringBuilder, Field field, Object object) {
        if (field.zzaxa() == 11) {
            Class<FastJsonResponse> clazz = field.zzaxg();
            stringBuilder.append(clazz.cast(object).toString());
        } else if (field.zzaxa() == 7) {
            stringBuilder.append("\"");
            stringBuilder.append(zzp.zzii((String)object));
            stringBuilder.append("\"");
        } else {
            stringBuilder.append(object);
        }
    }

    private void zza(StringBuilder stringBuilder, Field field, ArrayList<Object> arrayList) {
        stringBuilder.append("[");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            if (i > 0) {
                stringBuilder.append(",");
            }
            if ((object = arrayList.get(i)) == null) continue;
            this.zza(stringBuilder, field, object);
        }
        stringBuilder.append("]");
    }

    public static interface zza<I, O> {
        public I convertBack(O var1);
    }

    public static class Field<I, O>
    extends AbstractSafeParcelable {
        private final int mVersionCode;
        protected final int Fg;
        protected final boolean Fh;
        protected final int Fi;
        protected final boolean Fj;
        protected final String Fk;
        protected final int Fl;
        protected final Class<? extends FastJsonResponse> Fm;
        protected final String Fn;
        private FieldMappingDictionary Fo;
        private zza<I, O> Fp;
        public static final com.google.android.gms.common.server.response.zza CREATOR = new com.google.android.gms.common.server.response.zza();

        Field(int n, int n2, boolean bl, int n3, boolean bl2, String string2, int n4, String string3, ConverterWrapper converterWrapper) {
            this.mVersionCode = n;
            this.Fg = n2;
            this.Fh = bl;
            this.Fi = n3;
            this.Fj = bl2;
            this.Fk = string2;
            this.Fl = n4;
            if (string3 == null) {
                this.Fm = null;
                this.Fn = null;
            } else {
                this.Fm = SafeParcelResponse.class;
                this.Fn = string3;
            }
            this.Fp = converterWrapper == null ? null : converterWrapper.zzawx();
        }

        protected Field(int n, boolean bl, int n2, boolean bl2, String string2, int n3, Class<? extends FastJsonResponse> clazz, zza<I, O> zza2) {
            this.mVersionCode = 1;
            this.Fg = n;
            this.Fh = bl;
            this.Fi = n2;
            this.Fj = bl2;
            this.Fk = string2;
            this.Fl = n3;
            this.Fm = clazz;
            this.Fn = clazz == null ? null : clazz.getCanonicalName();
            this.Fp = zza2;
        }

        public int getVersionCode() {
            return this.mVersionCode;
        }

        public int zzaxa() {
            return this.Fg;
        }

        public boolean zzaxb() {
            return this.Fh;
        }

        public int zzaxc() {
            return this.Fi;
        }

        public boolean zzaxd() {
            return this.Fj;
        }

        public String zzaxe() {
            return this.Fk;
        }

        public int zzaxf() {
            return this.Fl;
        }

        public Class<? extends FastJsonResponse> zzaxg() {
            return this.Fm;
        }

        String zzaxh() {
            if (this.Fn == null) {
                return null;
            }
            return this.Fn;
        }

        public boolean zzaxi() {
            return this.Fp != null;
        }

        public void zza(FieldMappingDictionary fieldMappingDictionary) {
            this.Fo = fieldMappingDictionary;
        }

        ConverterWrapper zzaxj() {
            if (this.Fp == null) {
                return null;
            }
            return ConverterWrapper.zza(this.Fp);
        }

        public Map<String, Field<?, ?>> zzaxk() {
            zzaa.zzy(this.Fn);
            zzaa.zzy(this.Fo);
            return this.Fo.zzig(this.Fn);
        }

        public I convertBack(O o) {
            return this.Fp.convertBack(o);
        }

        public static Field<Integer, Integer> zzk(String string2, int n) {
            return new Field<Integer, Integer>(0, false, 0, false, string2, n, null, null);
        }

        public static Field<Boolean, Boolean> zzl(String string2, int n) {
            return new Field<Boolean, Boolean>(6, false, 6, false, string2, n, null, null);
        }

        public static Field<String, String> zzm(String string2, int n) {
            return new Field<String, String>(7, false, 7, false, string2, n, null, null);
        }

        public static <T extends FastJsonResponse> Field<T, T> zza(String string2, int n, Class<T> clazz) {
            return new Field(11, false, 11, false, string2, n, clazz, null);
        }

        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> zzb(String string2, int n, Class<T> clazz) {
            return new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, n, clazz, null);
        }

        public static Field zza(String string2, int n, zza<?, ?> zza2, boolean bl) {
            return new Field(7, bl, 0, false, string2, n, null, zza2);
        }

        public void writeToParcel(Parcel parcel, int n) {
            com.google.android.gms.common.server.response.zza.zza(this, parcel, n);
        }

        public String toString() {
            zzz.zza zza2 = zzz.zzx(this).zzg("versionCode", this.mVersionCode).zzg("typeIn", this.Fg).zzg("typeInArray", this.Fh).zzg("typeOut", this.Fi).zzg("typeOutArray", this.Fj).zzg("outputFieldName", this.Fk).zzg("safeParcelFieldId", this.Fl).zzg("concreteTypeName", this.zzaxh());
            Class<FastJsonResponse> clazz = this.zzaxg();
            if (clazz != null) {
                zza2.zzg("concreteType.class", clazz.getCanonicalName());
            }
            if (this.Fp != null) {
                zza2.zzg("converterName", this.Fp.getClass().getCanonicalName());
            }
            return zza2.toString();
        }
    }
}

