/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzz;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class zzm
extends zzl
implements Handler.Callback {
    private final HashMap<zza, zzb> En = new HashMap();
    private final Context zzatc;
    private final Handler mHandler;
    private final com.google.android.gms.common.stats.zza Eo;
    private final long Ep;

    zzm(Context context) {
        this.zzatc = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.Eo = com.google.android.gms.common.stats.zza.zzaxr();
        this.Ep = 5000L;
    }

    @Override
    public boolean zza(String string2, String string3, ServiceConnection serviceConnection, String string4) {
        return this.zza(new zza(string2, string3), serviceConnection, string4);
    }

    @Override
    public boolean zza(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzaa.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.En;
        synchronized (hashMap) {
            zzb zzb2 = this.En.get(zza2);
            if (zzb2 == null) {
                zzb2 = new zzb(zza2);
                zzb2.zza(serviceConnection, string2);
                zzb2.zzhw(string2);
                this.En.put(zza2, zzb2);
            } else {
                this.mHandler.removeMessages(0, (Object)zza2);
                if (zzb2.zza(serviceConnection)) {
                    String string3 = String.valueOf(zza2);
                    throw new IllegalStateException(new StringBuilder(81 + String.valueOf(string3).length()).append("Trying to bind a GmsServiceConnection that was already connected before.  config=").append(string3).toString());
                }
                zzb2.zza(serviceConnection, string2);
                switch (zzb2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzb2.getComponentName(), zzb2.getBinder());
                        break;
                    }
                    case 2: {
                        zzb2.zzhw(string2);
                    }
                }
            }
            return zzb2.isBound();
        }
    }

    @Override
    public void zzb(String string2, String string3, ServiceConnection serviceConnection, String string4) {
        this.zzb(new zza(string2, string3), serviceConnection, string4);
    }

    @Override
    public void zzb(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzaa.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.En;
        synchronized (hashMap) {
            zzb zzb2 = this.En.get(zza2);
            if (zzb2 == null) {
                String string3 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(50 + String.valueOf(string3).length()).append("Nonexistent connection status for service config: ").append(string3).toString());
            }
            if (!zzb2.zza(serviceConnection)) {
                String string4 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(76 + String.valueOf(string4).length()).append("Trying to unbind a GmsServiceConnection  that was not bound before.  config=").append(string4).toString());
            }
            zzb2.zzb(serviceConnection, string2);
            if (zzb2.zzawf()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zza2);
                this.mHandler.sendMessageDelayed(message, this.Ep);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                zza zza2 = (zza)message.obj;
                HashMap<zza, zzb> hashMap = this.En;
                synchronized (hashMap) {
                    zzb zzb2 = this.En.get(zza2);
                    if (zzb2 != null && zzb2.zzawf()) {
                        if (zzb2.isBound()) {
                            zzb2.zzhx("GmsClientSupervisor");
                        }
                        this.En.remove(zza2);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static final class zza {
        private final String cd;
        private final String Eq;
        private final ComponentName Er;

        public zza(String string2, String string3) {
            this.cd = zzaa.zzib(string2);
            this.Eq = zzaa.zzib(string3);
            this.Er = null;
        }

        public zza(ComponentName componentName) {
            this.cd = null;
            this.Eq = null;
            this.Er = zzaa.zzy(componentName);
        }

        public String toString() {
            return this.cd == null ? this.Er.flattenToString() : this.cd;
        }

        public Intent zzawe() {
            Intent intent = this.cd != null ? new Intent(this.cd).setPackage(this.Eq) : new Intent().setComponent(this.Er);
            return intent;
        }

        public int hashCode() {
            return zzz.hashCode(this.cd, this.Er);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)object;
            return zzz.equal(this.cd, zza2.cd) && zzz.equal(this.Er, zza2.Er);
        }
    }

    private final class zzb {
        private final zza Es;
        private final Set<ServiceConnection> Et;
        private int mState;
        private boolean Eu;
        private IBinder DI;
        private final com.google.android.gms.common.internal.zzm$zza Ev;
        private ComponentName Er;

        public zzb(com.google.android.gms.common.internal.zzm$zza zza2) {
            this.Ev = zza2;
            this.Es = new zza();
            this.Et = new HashSet<ServiceConnection>();
            this.mState = 2;
        }

        @TargetApi(value=14)
        public void zzhw(String string2) {
            this.mState = 3;
            this.Eu = zzm.this.Eo.zza(zzm.this.zzatc, string2, this.Ev.zzawe(), this.Es, 129);
            if (!this.Eu) {
                this.mState = 2;
                try {
                    zzm.this.Eo.zza(zzm.this.zzatc, this.Es);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public void zzhx(String string2) {
            zzm.this.Eo.zza(zzm.this.zzatc, this.Es);
            this.Eu = false;
            this.mState = 2;
        }

        public void zza(ServiceConnection serviceConnection, String string2) {
            zzm.this.Eo.zza(zzm.this.zzatc, serviceConnection, string2, this.Ev.zzawe());
            this.Et.add(serviceConnection);
        }

        public void zzb(ServiceConnection serviceConnection, String string2) {
            zzm.this.Eo.zzb(zzm.this.zzatc, serviceConnection);
            this.Et.remove(serviceConnection);
        }

        public boolean isBound() {
            return this.Eu;
        }

        public int getState() {
            return this.mState;
        }

        public boolean zza(ServiceConnection serviceConnection) {
            return this.Et.contains(serviceConnection);
        }

        public boolean zzawf() {
            return this.Et.isEmpty();
        }

        public IBinder getBinder() {
            return this.DI;
        }

        public ComponentName getComponentName() {
            return this.Er;
        }

        public class zza
        implements ServiceConnection {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                HashMap hashMap = zzm.this.En;
                synchronized (hashMap) {
                    zzb.this.DI = iBinder;
                    zzb.this.Er = componentName;
                    for (ServiceConnection serviceConnection : zzb.this.Et) {
                        serviceConnection.onServiceConnected(componentName, iBinder);
                    }
                    zzb.this.mState = 1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName componentName) {
                HashMap hashMap = zzm.this.En;
                synchronized (hashMap) {
                    zzb.this.DI = null;
                    zzb.this.Er = componentName;
                    for (ServiceConnection serviceConnection : zzb.this.Et) {
                        serviceConnection.onServiceDisconnected(componentName);
                    }
                    zzb.this.mState = 2;
                }
            }
        }
    }
}

