/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzg;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;

public final class Status
extends AbstractSafeParcelable
implements Result,
ReflectedParcelable {
    public static final Status xZ = new Status(0);
    public static final Status ya = new Status(14);
    public static final Status yb = new Status(8);
    public static final Status yc = new Status(15);
    public static final Status yd = new Status(16);
    public static final Status ye = new Status(17);
    public static final Status yf = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zzg();
    final int mVersionCode;
    private final int uo;
    private final String wP;
    private final PendingIntent mPendingIntent;

    Status(int n, int n2, String string2, PendingIntent pendingIntent) {
        this.mVersionCode = n;
        this.uo = n2;
        this.wP = string2;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int n) {
        this(n, null);
    }

    public Status(int n, String string2) {
        this(1, n, string2, null);
    }

    public Status(int n, String string2, PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), n, null, 0, 0, 0);
    }

    PendingIntent zzarj() {
        return this.mPendingIntent;
    }

    @Nullable
    public String getStatusMessage() {
        return this.wP;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.uo <= 0;
    }

    public boolean isCanceled() {
        return this.uo == 16;
    }

    public boolean isInterrupted() {
        return this.uo == 14;
    }

    public int getStatusCode() {
        return this.uo;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return zzz.hashCode(this.mVersionCode, this.uo, this.wP, this.mPendingIntent);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.mVersionCode == status.mVersionCode && this.uo == status.uo && zzz.equal(this.wP, status.wP) && zzz.equal(this.mPendingIntent, status.mPendingIntent);
    }

    public String zzark() {
        if (this.wP != null) {
            return this.wP;
        }
        return CommonStatusCodes.getStatusCodeString(this.uo);
    }

    public String toString() {
        return zzz.zzx(this).zzg("statusCode", this.zzark()).zzg("resolution", this.mPendingIntent).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzg.zza(this, parcel, n);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

