/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.phenotype;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.phenotype.zzb;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;

public class Flag
extends AbstractSafeParcelable
implements Comparable<Flag> {
    public static final Parcelable.Creator<Flag> CREATOR = new zzb();
    final int mVersionCode;
    public final String name;
    final long axp;
    final boolean afy;
    final double afA;
    final String Dr;
    final byte[] axq;
    public final int axr;
    public final int axs;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final zza axt = new zza();

    Flag(int n, String string2, long l, boolean bl, double d, String string3, byte[] byArray, int n2, int n3) {
        this.mVersionCode = n;
        this.name = string2;
        this.axp = l;
        this.afy = bl;
        this.afA = d;
        this.Dr = string3;
        this.axq = byArray;
        this.axr = n2;
        this.axs = n3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Flag(");
        stringBuilder.append(this.mVersionCode);
        stringBuilder.append(", ");
        stringBuilder.append(this.name);
        stringBuilder.append(", ");
        switch (this.axr) {
            case 1: {
                stringBuilder.append(this.axp);
                break;
            }
            case 2: {
                stringBuilder.append(this.afy);
                break;
            }
            case 3: {
                stringBuilder.append(this.afA);
                break;
            }
            case 4: {
                stringBuilder.append("'");
                stringBuilder.append(this.Dr);
                stringBuilder.append("'");
                break;
            }
            case 5: {
                if (this.axq == null) {
                    stringBuilder.append("null");
                    break;
                }
                stringBuilder.append("'");
                stringBuilder.append(new String(this.axq, UTF_8));
                stringBuilder.append("'");
                break;
            }
            default: {
                int n = this.axr;
                throw new AssertionError((Object)new StringBuilder(31).append("Invalid enum value: ").append(n).toString());
            }
        }
        stringBuilder.append(", ");
        stringBuilder.append(this.axr);
        stringBuilder.append(", ");
        stringBuilder.append(this.axs);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Flag) {
            Flag flag = (Flag)object;
            if (this.mVersionCode != flag.mVersionCode || !zzab.equal(this.name, flag.name) || this.axr != flag.axr || this.axs != flag.axs) {
                return false;
            }
            switch (this.axr) {
                case 1: {
                    return this.axp == flag.axp;
                }
                case 2: {
                    return this.afy == flag.afy;
                }
                case 3: {
                    return this.afA == flag.afA;
                }
                case 4: {
                    return zzab.equal(this.Dr, flag.Dr);
                }
                case 5: {
                    return Arrays.equals(this.axq, flag.axq);
                }
            }
            int n = this.axr;
            throw new AssertionError((Object)new StringBuilder(31).append("Invalid enum value: ").append(n).toString());
        }
        return false;
    }

    public int zza(Flag flag) {
        int n = this.name.compareTo(flag.name);
        if (n != 0) {
            return n;
        }
        n = Flag.compare(this.axr, flag.axr);
        if (n != 0) {
            return n;
        }
        switch (this.axr) {
            case 1: {
                return Flag.compare(this.axp, flag.axp);
            }
            case 2: {
                return Flag.compare(this.afy, flag.afy);
            }
            case 3: {
                return Double.compare(this.afA, flag.afA);
            }
            case 4: {
                return Flag.compare(this.Dr, flag.Dr);
            }
            case 5: {
                if (this.axq == flag.axq) {
                    return 0;
                }
                if (this.axq == null) {
                    return -1;
                }
                if (flag.axq == null) {
                    return 1;
                }
                for (int i = 0; i < Math.min(this.axq.length, flag.axq.length); ++i) {
                    n = Flag.compare(this.axq[i], flag.axq[i]);
                    if (n == 0) continue;
                    return n;
                }
                return Flag.compare(this.axq.length, flag.axq.length);
            }
        }
        int n2 = this.axr;
        throw new AssertionError((Object)new StringBuilder(31).append("Invalid enum value: ").append(n2).toString());
    }

    private static int compare(String string2, String string3) {
        if (string2 == string3) {
            return 0;
        }
        if (string2 == null) {
            return -1;
        }
        if (string3 == null) {
            return 1;
        }
        return string2.compareTo(string3);
    }

    private static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    private static int compare(long l, long l2) {
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    private static int compare(boolean bl, boolean bl2) {
        return bl == bl2 ? 0 : (bl ? 1 : -1);
    }

    private static int compare(byte by, byte by2) {
        return by - by2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zza((Flag)object);
    }

    public static class zza
    implements Comparator<Flag> {
        public int zza(Flag flag, Flag flag2) {
            if (flag.axs == flag2.axs) {
                return flag.name.compareTo(flag2.name);
            }
            return flag.axs - flag2.axs;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Flag)object, (Flag)object2);
        }
    }
}

