/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Bundle;
import android.os.Parcel;
import android.util.SparseArray;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.server.response.FastSafeParcelableJsonResponse;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.zze;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.common.util.zzc;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.common.util.zzq;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SafeParcelResponse
extends FastSafeParcelableJsonResponse {
    private final int mVersionCode;
    private final Parcel DI;
    private final int DJ;
    private final FieldMappingDictionary DB;
    private final String mClassName;
    private int DK;
    private int DL;
    public static final zze CREATOR = new zze();

    SafeParcelResponse(int n, Parcel parcel, FieldMappingDictionary fieldMappingDictionary) {
        this.mVersionCode = n;
        this.DI = zzac.zzy(parcel);
        this.DJ = 2;
        this.DB = fieldMappingDictionary;
        this.mClassName = this.DB == null ? null : this.DB.zzawg();
        this.DK = 2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public Parcel zzawi() {
        switch (this.DK) {
            case 0: {
                this.DL = com.google.android.gms.common.internal.safeparcel.zzb.zzcr(this.DI);
                com.google.android.gms.common.internal.safeparcel.zzb.zzaj(this.DI, this.DL);
                this.DK = 2;
                break;
            }
            case 1: {
                com.google.android.gms.common.internal.safeparcel.zzb.zzaj(this.DI, this.DL);
                this.DK = 2;
                break;
            }
        }
        return this.DI;
    }

    FieldMappingDictionary zzawj() {
        switch (this.DJ) {
            case 0: {
                return null;
            }
            case 1: {
                return this.DB;
            }
            case 2: {
                return this.DB;
            }
        }
        int n = this.DJ;
        throw new IllegalStateException(new StringBuilder(34).append("Invalid creation type: ").append(n).toString());
    }

    @Override
    public Map<String, FastJsonResponse.Field<?, ?>> zzavs() {
        if (this.DB == null) {
            return null;
        }
        return this.DB.zzie(this.mClassName);
    }

    @Override
    public Object zzia(String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    @Override
    public boolean zzib(String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    @Override
    public String toString() {
        zzac.zzb(this.DB, (Object)"Cannot convert to JSON on client side.");
        Parcel parcel = this.zzawi();
        parcel.setDataPosition(0);
        StringBuilder stringBuilder = new StringBuilder(100);
        this.zza(stringBuilder, this.DB.zzie(this.mClassName), parcel);
        return stringBuilder.toString();
    }

    private void zza(StringBuilder stringBuilder, Map<String, FastJsonResponse.Field<?, ?>> map, Parcel parcel) {
        SparseArray<Map.Entry<String, FastJsonResponse.Field<?, ?>>> sparseArray = SafeParcelResponse.zzav(map);
        stringBuilder.append('{');
        int n = zza.zzcq(parcel);
        boolean bl = false;
        while (parcel.dataPosition() < n) {
            int n2 = zza.zzcp(parcel);
            int n3 = zza.zzgv(n2);
            Map.Entry entry = (Map.Entry)sparseArray.get(n3);
            if (entry == null) continue;
            if (bl) {
                stringBuilder.append(",");
            }
            this.zza(stringBuilder, (String)entry.getKey(), (FastJsonResponse.Field)entry.getValue(), parcel, n2);
            bl = true;
        }
        if (parcel.dataPosition() != n) {
            throw new zza.zza(new StringBuilder(37).append("Overread allowed size end=").append(n).toString(), parcel);
        }
        stringBuilder.append('}');
    }

    private static SparseArray<Map.Entry<String, FastJsonResponse.Field<?, ?>>> zzav(Map<String, FastJsonResponse.Field<?, ?>> map) {
        SparseArray sparseArray = new SparseArray();
        for (Map.Entry<String, FastJsonResponse.Field<?, ?>> entry : map.entrySet()) {
            sparseArray.put(entry.getValue().zzavy(), entry);
        }
        return sparseArray;
    }

    private void zza(StringBuilder stringBuilder, String string2, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        stringBuilder.append("\"").append(string2).append("\":");
        if (field.zzawb()) {
            this.zza(stringBuilder, field, parcel, n);
        } else {
            this.zzb(stringBuilder, field, parcel, n);
        }
    }

    private void zza(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        switch (field.zzavr()) {
            case 0: {
                int n2 = zza.zzg(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, n2));
                break;
            }
            case 1: {
                BigInteger bigInteger = zza.zzk(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bigInteger));
                break;
            }
            case 2: {
                long l = zza.zzi(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, l));
                break;
            }
            case 3: {
                float f = zza.zzl(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, Float.valueOf(f)));
                break;
            }
            case 4: {
                double d = zza.zzn(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, d));
                break;
            }
            case 5: {
                BigDecimal bigDecimal = zza.zzp(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bigDecimal));
                break;
            }
            case 6: {
                boolean bl = zza.zzc(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bl));
                break;
            }
            case 7: {
                String string2 = zza.zzq(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, string2));
                break;
            }
            case 8: 
            case 9: {
                byte[] byArray = zza.zzt(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, byArray));
                break;
            }
            case 10: {
                Bundle bundle = zza.zzs(parcel, n);
                HashMap<String, String> hashMap = SafeParcelResponse.zzq(bundle);
                this.zzb(stringBuilder, field, this.zza(field, hashMap));
                break;
            }
            case 11: {
                throw new IllegalArgumentException("Method does not accept concrete type.");
            }
            default: {
                int n3 = field.zzavr();
                throw new IllegalArgumentException(new StringBuilder(36).append("Unknown field out type = ").append(n3).toString());
            }
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        if (field.zzavw()) {
            stringBuilder.append("[");
            switch (field.zzavr()) {
                case 0: {
                    int[] nArray = zza.zzw(parcel, n);
                    zzb.zza(stringBuilder, nArray);
                    break;
                }
                case 1: {
                    BigInteger[] bigIntegerArray = zza.zzy(parcel, n);
                    zzb.zza(stringBuilder, bigIntegerArray);
                    break;
                }
                case 2: {
                    long[] lArray = zza.zzx(parcel, n);
                    zzb.zza(stringBuilder, lArray);
                    break;
                }
                case 3: {
                    float[] fArray = zza.zzz(parcel, n);
                    zzb.zza(stringBuilder, fArray);
                    break;
                }
                case 4: {
                    double[] dArray = zza.zzaa(parcel, n);
                    zzb.zza(stringBuilder, dArray);
                    break;
                }
                case 5: {
                    BigDecimal[] bigDecimalArray = zza.zzab(parcel, n);
                    zzb.zza(stringBuilder, bigDecimalArray);
                    break;
                }
                case 6: {
                    boolean[] blArray = zza.zzv(parcel, n);
                    zzb.zza(stringBuilder, blArray);
                    break;
                }
                case 7: {
                    String[] stringArray = zza.zzac(parcel, n);
                    zzb.zza(stringBuilder, stringArray);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    throw new UnsupportedOperationException("List of type BASE64, BASE64_URL_SAFE, or STRING_MAP is not supported");
                }
                case 11: {
                    Parcel[] parcelArray = zza.zzag(parcel, n);
                    int n2 = parcelArray.length;
                    for (int i = 0; i < n2; ++i) {
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        parcelArray[i].setDataPosition(0);
                        this.zza(stringBuilder, field.zzawd(), parcelArray[i]);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown field type out.");
                }
            }
            stringBuilder.append("]");
        } else {
            switch (field.zzavr()) {
                case 0: {
                    int n3 = zza.zzg(parcel, n);
                    stringBuilder.append(n3);
                    break;
                }
                case 1: {
                    BigInteger bigInteger = zza.zzk(parcel, n);
                    stringBuilder.append(bigInteger);
                    break;
                }
                case 2: {
                    long l = zza.zzi(parcel, n);
                    stringBuilder.append(l);
                    break;
                }
                case 3: {
                    float f = zza.zzl(parcel, n);
                    stringBuilder.append(f);
                    break;
                }
                case 4: {
                    double d = zza.zzn(parcel, n);
                    stringBuilder.append(d);
                    break;
                }
                case 5: {
                    BigDecimal bigDecimal = zza.zzp(parcel, n);
                    stringBuilder.append(bigDecimal);
                    break;
                }
                case 6: {
                    boolean bl = zza.zzc(parcel, n);
                    stringBuilder.append(bl);
                    break;
                }
                case 7: {
                    String string2 = zza.zzq(parcel, n);
                    stringBuilder.append("\"").append(zzp.zzii(string2)).append("\"");
                    break;
                }
                case 8: {
                    byte[] byArray = zza.zzt(parcel, n);
                    stringBuilder.append("\"").append(zzc.zzp(byArray)).append("\"");
                    break;
                }
                case 9: {
                    byte[] byArray = zza.zzt(parcel, n);
                    stringBuilder.append("\"").append(zzc.zzq(byArray));
                    stringBuilder.append("\"");
                    break;
                }
                case 10: {
                    Bundle bundle = zza.zzs(parcel, n);
                    Set set = bundle.keySet();
                    int n4 = set.size();
                    stringBuilder.append("{");
                    boolean bl = true;
                    for (String string3 : set) {
                        if (!bl) {
                            stringBuilder.append(",");
                        }
                        bl = false;
                        stringBuilder.append("\"").append(string3).append("\"");
                        stringBuilder.append(":");
                        stringBuilder.append("\"").append(zzp.zzii(bundle.getString(string3))).append("\"");
                    }
                    stringBuilder.append("}");
                    break;
                }
                case 11: {
                    Parcel parcel2 = zza.zzaf(parcel, n);
                    parcel2.setDataPosition(0);
                    this.zza(stringBuilder, field.zzawd(), parcel2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown field type out");
                }
            }
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Object object) {
        if (field.zzavv()) {
            this.zzb(stringBuilder, field, (ArrayList)object);
        } else {
            this.zza(stringBuilder, field.zzavq(), object);
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, ArrayList<?> arrayList) {
        stringBuilder.append("[");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            this.zza(stringBuilder, field.zzavq(), arrayList.get(i));
        }
        stringBuilder.append("]");
    }

    private void zza(StringBuilder stringBuilder, int n, Object object) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                stringBuilder.append(object);
                break;
            }
            case 7: {
                stringBuilder.append("\"").append(zzp.zzii(object.toString())).append("\"");
                break;
            }
            case 8: {
                stringBuilder.append("\"").append(zzc.zzp((byte[])object)).append("\"");
                break;
            }
            case 9: {
                stringBuilder.append("\"").append(zzc.zzq((byte[])object));
                stringBuilder.append("\"");
                break;
            }
            case 10: {
                zzq.zza(stringBuilder, (HashMap)object);
                break;
            }
            case 11: {
                throw new IllegalArgumentException("Method does not accept concrete type.");
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unknown type = ").append(n).toString());
            }
        }
    }

    public static HashMap<String, String> zzq(Bundle bundle) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : bundle.keySet()) {
            hashMap.put(string2, bundle.getString(string2));
        }
        return hashMap;
    }
}

