/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.phenotype;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.phenotype.Flag;
import com.google.android.gms.phenotype.zza;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class Configuration
extends AbstractSafeParcelable
implements Comparable<Configuration> {
    public static final Parcelable.Creator<Configuration> CREATOR = new zza();
    final int mVersionCode;
    public final int arh;
    public final Flag[] ari;
    public final String[] arj;
    public final Map<String, Flag> ark;

    Configuration(int n, int n2, Flag[] flagArray, String[] stringArray) {
        this.mVersionCode = n;
        this.arh = n2;
        this.ari = flagArray;
        this.ark = new TreeMap<String, Flag>();
        for (Flag flag : flagArray) {
            this.ark.put(flag.name, flag);
        }
        this.arj = stringArray;
        if (this.arj != null) {
            Arrays.sort(this.arj);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Configuration(");
        stringBuilder.append(this.mVersionCode);
        stringBuilder.append(", ");
        stringBuilder.append(this.arh);
        stringBuilder.append(", ");
        stringBuilder.append("(");
        for (Flag flag : this.ark.values()) {
            stringBuilder.append(flag);
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        stringBuilder.append(", ");
        stringBuilder.append("(");
        if (this.arj != null) {
            for (String string2 : this.arj) {
                stringBuilder.append(string2);
                stringBuilder.append(", ");
            }
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Configuration) {
            Configuration configuration = (Configuration)object;
            return this.mVersionCode == configuration.mVersionCode && this.arh == configuration.arh && zzaa.equal(this.ark, configuration.ark) && Arrays.equals(this.arj, configuration.arj);
        }
        return false;
    }

    public int zza(Configuration configuration) {
        return this.arh - configuration.arh;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zza((Configuration)object);
    }
}

