/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzamr;
import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzant;
import com.google.android.gms.internal.zzanu;
import com.google.android.gms.internal.zzanx;
import com.google.android.gms.internal.zzaol;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class zzanp {
    private final Map<Type, zzamr<?>> bed;

    public zzanp(Map<Type, zzamr<?>> map) {
        this.bed = map;
    }

    public <T> zzanu<T> zzb(zzaol<T> zzaol2) {
        final Type type = zzaol2.n();
        Class<T> clazz = zzaol2.m();
        final zzamr<?> zzamr2 = this.bed.get(type);
        if (zzamr2 != null) {
            return new zzanu<T>(){

                @Override
                public T zzczu() {
                    return zzamr2.zza(type);
                }
            };
        }
        final zzamr<?> zzamr3 = this.bed.get(clazz);
        if (zzamr3 != null) {
            return new zzanu<T>(){

                @Override
                public T zzczu() {
                    return zzamr3.zza(type);
                }
            };
        }
        zzanu<T> zzanu2 = this.zzl(clazz);
        if (zzanu2 != null) {
            return zzanu2;
        }
        zzanu<T> zzanu3 = this.zzc(type, clazz);
        if (zzanu3 != null) {
            return zzanu3;
        }
        return this.zzd(type, clazz);
    }

    private <T> zzanu<T> zzl(Class<? super T> clazz) {
        try {
            final Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new zzanu<T>(){

                @Override
                public T zzczu() {
                    try {
                        Object var1_1 = null;
                        return constructor.newInstance(null);
                    }
                    catch (InstantiationException instantiationException) {
                        String string2 = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string2).length()).append("Failed to invoke ").append(string2).append(" with no args").toString(), instantiationException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        String string3 = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string3).length()).append("Failed to invoke ").append(string3).append(" with no args").toString(), invocationTargetException.getTargetException());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new AssertionError((Object)illegalAccessException);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private <T> zzanu<T> zzc(final Type type, Class<? super T> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new zzanu<T>(){

                    @Override
                    public T zzczu() {
                        return new TreeSet();
                    }
                };
            }
            if (EnumSet.class.isAssignableFrom(clazz)) {
                return new zzanu<T>(){

                    @Override
                    public T zzczu() {
                        if (type instanceof ParameterizedType) {
                            Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
                            if (type2 instanceof Class) {
                                return EnumSet.noneOf((Class)type2);
                            }
                            String string2 = String.valueOf(type.toString());
                            throw new zzamw(string2.length() != 0 ? "Invalid EnumSet type: ".concat(string2) : new String("Invalid EnumSet type: "));
                        }
                        String string3 = String.valueOf(type.toString());
                        throw new zzamw(string3.length() != 0 ? "Invalid EnumSet type: ".concat(string3) : new String("Invalid EnumSet type: "));
                    }
                };
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new zzanu<T>(){

                    @Override
                    public T zzczu() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return new zzanu<T>(){

                    @Override
                    public T zzczu() {
                        return new LinkedList();
                    }
                };
            }
            return new zzanu<T>(){

                @Override
                public T zzczu() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return new zzanu<T>(){

                    @Override
                    public T zzczu() {
                        return new TreeMap();
                    }
                };
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(zzaol.zzl(((ParameterizedType)type).getActualTypeArguments()[0]).m())) {
                return new zzanu<T>(){

                    @Override
                    public T zzczu() {
                        return new LinkedHashMap();
                    }
                };
            }
            return new zzanu<T>(){

                @Override
                public T zzczu() {
                    return new zzant();
                }
            };
        }
        return null;
    }

    private <T> zzanu<T> zzd(final Type type, final Class<? super T> clazz) {
        return new zzanu<T>(){
            private final zzanx beG = zzanx.zzczz();

            @Override
            public T zzczu() {
                try {
                    Object t = this.beG.zzf(clazz);
                    return t;
                }
                catch (Exception exception) {
                    String string2 = String.valueOf(type);
                    throw new RuntimeException(new StringBuilder(116 + String.valueOf(string2).length()).append("Unable to invoke no-args constructor for ").append(string2).append(". ").append("Register an InstanceCreator with Gson for this type may fix this problem.").toString(), exception);
                }
            }
        };
    }

    public String toString() {
        return this.bed.toString();
    }
}

