/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Debug;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.common.stats.ConnectionEvent;
import com.google.android.gms.common.stats.zzc;
import com.google.android.gms.common.stats.zzd;
import com.google.android.gms.common.stats.zze;
import com.google.android.gms.common.util.zzt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class zzb {
    private static final Object yL = new Object();
    private static zzb Aj;
    private final List<String> Ak;
    private final List<String> Al;
    private final List<String> Am;
    private final List<String> An;
    private zze Ao;
    private static Integer Ap;
    private zze Aq;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzb zzaux() {
        Object object = yL;
        synchronized (object) {
            if (Aj == null) {
                Aj = new zzb();
            }
        }
        return Aj;
    }

    private zzb() {
        if (zzb.getLogLevel() == zzd.LOG_LEVEL_OFF) {
            this.Ak = Collections.EMPTY_LIST;
            this.Al = Collections.EMPTY_LIST;
            this.Am = Collections.EMPTY_LIST;
            this.An = Collections.EMPTY_LIST;
            return;
        }
        String string2 = zzc.zza.Au.get();
        this.Ak = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.Av.get();
        this.Al = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.Aw.get();
        this.Am = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.Ax.get();
        this.An = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        this.Ao = new zze(1024, zzc.zza.Ay.get());
        this.Aq = new zze(1024, zzc.zza.Ay.get());
    }

    private boolean zzc(Context context, Intent intent) {
        ComponentName componentName = intent.getComponent();
        if (componentName == null) {
            return false;
        }
        return com.google.android.gms.common.util.zzd.zzq(context, componentName.getPackageName());
    }

    @SuppressLint(value={"UntrackedBindService"})
    public boolean zza(Context context, String string2, Intent intent, ServiceConnection serviceConnection, int n) {
        if (this.zzc(context, intent)) {
            Log.w((String)"ConnectionTracker", (String)"Attempted to bind to a service in a STOPPED package.");
            return false;
        }
        boolean bl = context.bindService(intent, serviceConnection, n);
        if (bl) {
            this.zza(context, this.zzb(serviceConnection), string2, intent, 2);
        }
        return bl;
    }

    public boolean zza(Context context, Intent intent, ServiceConnection serviceConnection, int n) {
        return this.zza(context, context.getClass().getName(), intent, serviceConnection, n);
    }

    @SuppressLint(value={"UntrackedBindService"})
    public void zza(Context context, ServiceConnection serviceConnection) {
        context.unbindService(serviceConnection);
        this.zza(context, this.zzb(serviceConnection), (String)null, (Intent)null, 1);
    }

    public void zza(Context context, ServiceConnection serviceConnection, String string2, Intent intent) {
        this.zza(context, this.zzb(serviceConnection), string2, intent, 3);
    }

    public void zzb(Context context, ServiceConnection serviceConnection) {
        this.zza(context, this.zzb(serviceConnection), (String)null, (Intent)null, 4);
    }

    private void zza(Context context, String string2, String string3, Intent intent, int n) {
        String string4;
        String string5;
        String string6;
        if (!this.zzauy() || this.Ao == null) {
            return;
        }
        if (n == 4 || n == 1) {
            if (!this.Ao.zzhy(string2)) {
                return;
            }
            string6 = null;
            string5 = null;
            string4 = null;
        } else {
            ServiceInfo serviceInfo = zzb.zzd(context, intent);
            if (serviceInfo == null) {
                Log.w((String)"ConnectionTracker", (String)String.format("Client %s made an invalid request %s", string3, intent.toUri(0)));
                return;
            }
            string6 = serviceInfo.processName;
            string5 = serviceInfo.name;
            string4 = zzt.zzavz();
            if (!this.zzb(string4, string3, string6, string5)) {
                return;
            }
            this.Ao.zzhx(string2);
        }
        this.zza(context, string2, n, string4, string3, string6, string5);
    }

    private void zza(Context context, String string2, int n, String string3, String string4, String string5, String string6) {
        long l = System.currentTimeMillis();
        String string7 = null;
        if ((zzb.getLogLevel() & zzd.AD) != 0 && n != 13) {
            string7 = zzb.zzm(3, 5);
        }
        long l2 = 0L;
        if ((zzb.getLogLevel() & zzd.AF) != 0) {
            l2 = Debug.getNativeHeapAllocatedSize();
        }
        ConnectionEvent connectionEvent = n == 1 || n == 4 || n == 14 ? new ConnectionEvent(l, n, null, null, null, null, string7, string2, SystemClock.elapsedRealtime(), l2) : new ConnectionEvent(l, n, string3, string4, string5, string6, string7, string2, SystemClock.elapsedRealtime(), l2);
        context.startService(new Intent().setComponent(zzd.Az).putExtra("com.google.android.gms.common.stats.EXTRA_LOG_EVENT", (Parcelable)connectionEvent));
    }

    private boolean zzauy() {
        if (!false) {
            return false;
        }
        int n = zzb.getLogLevel();
        return n != zzd.LOG_LEVEL_OFF;
    }

    private boolean zzb(String string2, String string3, String string4, String string5) {
        int n = zzb.getLogLevel();
        return !this.Ak.contains(string2) && !this.Al.contains(string3) && !this.Am.contains(string4) && !this.An.contains(string5) && (!string4.equals(string2) || (n & zzd.AE) == 0);
    }

    private static ServiceInfo zzd(Context context, Intent intent) {
        List list = context.getPackageManager().queryIntentServices(intent, 128);
        if (list == null || list.size() == 0) {
            Log.w((String)"ConnectionTracker", (String)String.format("There are no handler of this intent: %s\n Stack trace: %s", intent.toUri(0), zzb.zzm(3, 20)));
            return null;
        }
        if (list.size() > 1) {
            Log.w((String)"ConnectionTracker", (String)String.format("Multiple handlers found for this intent: %s\n Stack trace: %s", intent.toUri(0), zzb.zzm(3, 20)));
            for (ResolveInfo resolveInfo : list) {
                Log.w((String)"ConnectionTracker", (String)resolveInfo.serviceInfo.name);
            }
            return null;
        }
        return ((ResolveInfo)list.get((int)0)).serviceInfo;
    }

    private String zzb(ServiceConnection serviceConnection) {
        return String.valueOf((long)Process.myPid() << 32 | (long)System.identityHashCode(serviceConnection));
    }

    private static int getLogLevel() {
        if (Ap == null) {
            try {
                Ap = com.google.android.gms.common.util.zzd.zzabc() ? zzc.zza.At.get() : zzd.LOG_LEVEL_OFF;
            }
            catch (SecurityException securityException) {
                Ap = zzd.LOG_LEVEL_OFF;
            }
        }
        return Ap;
    }

    private static String zzm(int n, int n2) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        n2 += n;
        for (int i = n; i < n2; ++i) {
            stringBuffer.append(zzb.zza(stackTraceElementArray, i)).append(" ");
        }
        return stringBuffer.toString();
    }

    private static String zza(StackTraceElement[] stackTraceElementArray, int n) {
        if (4 + n >= stackTraceElementArray.length) {
            return "<bottom of call stack>";
        }
        StackTraceElement stackTraceElement = stackTraceElementArray[4 + n];
        String string2 = String.valueOf(stackTraceElement.getClassName());
        String string3 = String.valueOf(stackTraceElement.getMethodName());
        int n2 = stackTraceElement.getLineNumber();
        return new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(".").append(string3).append(":").append(n2).toString();
    }
}

