/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzm;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class zzn
extends zzm
implements Handler.Callback {
    private final HashMap<zza, zzb> yN = new HashMap();
    private final Context zzaql;
    private final Handler mHandler;
    private final com.google.android.gms.common.stats.zzb yO;
    private final long yP;

    zzn(Context context) {
        this.zzaql = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.yO = com.google.android.gms.common.stats.zzb.zzaux();
        this.yP = 5000L;
    }

    @Override
    public boolean zza(String string2, String string3, ServiceConnection serviceConnection, String string4) {
        return this.zza(new zza(string2, string3), serviceConnection, string4);
    }

    @Override
    public boolean zza(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzab.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.yN;
        synchronized (hashMap) {
            zzb zzb2 = this.yN.get(zza2);
            if (zzb2 == null) {
                zzb2 = new zzb(zza2);
                zzb2.zza(serviceConnection, string2);
                zzb2.zzhm(string2);
                this.yN.put(zza2, zzb2);
            } else {
                this.mHandler.removeMessages(0, (Object)zzb2);
                if (zzb2.zza(serviceConnection)) {
                    String string3 = String.valueOf(zza2);
                    throw new IllegalStateException(new StringBuilder(81 + String.valueOf(string3).length()).append("Trying to bind a GmsServiceConnection that was already connected before.  config=").append(string3).toString());
                }
                zzb2.zza(serviceConnection, string2);
                switch (zzb2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzb2.getComponentName(), zzb2.getBinder());
                        break;
                    }
                    case 2: {
                        zzb2.zzhm(string2);
                    }
                }
            }
            return zzb2.isBound();
        }
    }

    @Override
    public void zzb(String string2, String string3, ServiceConnection serviceConnection, String string4) {
        this.zzb(new zza(string2, string3), serviceConnection, string4);
    }

    @Override
    public void zzb(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzab.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.yN;
        synchronized (hashMap) {
            zzb zzb2 = this.yN.get(zza2);
            if (zzb2 == null) {
                String string3 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(50 + String.valueOf(string3).length()).append("Nonexistent connection status for service config: ").append(string3).toString());
            }
            if (!zzb2.zza(serviceConnection)) {
                String string4 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(76 + String.valueOf(string4).length()).append("Trying to unbind a GmsServiceConnection  that was not bound before.  config=").append(string4).toString());
            }
            zzb2.zzb(serviceConnection, string2);
            if (zzb2.zzasz()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zzb2);
                this.mHandler.sendMessageDelayed(message, this.yP);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                zzb zzb2 = (zzb)message.obj;
                HashMap<zza, zzb> hashMap = this.yN;
                synchronized (hashMap) {
                    if (zzb2.zzasz()) {
                        if (zzb2.isBound()) {
                            zzb2.zzhn("GmsClientSupervisor");
                        }
                        this.yN.remove(zzb2.yV);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static final class zza {
        private final String zzcvc;
        private final String yQ;
        private final ComponentName yR;

        public zza(String string2, String string3) {
            this.zzcvc = zzab.zzhr(string2);
            this.yQ = zzab.zzhr(string3);
            this.yR = null;
        }

        public zza(ComponentName componentName) {
            this.zzcvc = null;
            this.yQ = null;
            this.yR = zzab.zzy(componentName);
        }

        public String toString() {
            return this.zzcvc == null ? this.yR.flattenToString() : this.zzcvc;
        }

        public Intent zzasy() {
            Intent intent = this.zzcvc != null ? new Intent(this.zzcvc).setPackage(this.yQ) : new Intent().setComponent(this.yR);
            return intent;
        }

        public int hashCode() {
            return zzaa.hashCode(this.zzcvc, this.yR);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)object;
            return zzaa.equal(this.zzcvc, zza2.zzcvc) && zzaa.equal(this.yR, zza2.yR);
        }
    }

    private final class zzb {
        private final zza yS;
        private final Set<ServiceConnection> yT;
        private int mState;
        private boolean yU;
        private IBinder xL;
        private final com.google.android.gms.common.internal.zzn$zza yV;
        private ComponentName yR;

        public zzb(com.google.android.gms.common.internal.zzn$zza zza2) {
            this.yV = zza2;
            this.yS = new zza();
            this.yT = new HashSet<ServiceConnection>();
            this.mState = 2;
        }

        @TargetApi(value=14)
        public void zzhm(String string2) {
            this.mState = 3;
            this.yU = zzn.this.yO.zza(zzn.this.zzaql, string2, this.yV.zzasy(), this.yS, 129);
            if (!this.yU) {
                this.mState = 2;
                try {
                    zzn.this.yO.zza(zzn.this.zzaql, this.yS);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public void zzhn(String string2) {
            zzn.this.yO.zza(zzn.this.zzaql, this.yS);
            this.yU = false;
            this.mState = 2;
        }

        public void zza(ServiceConnection serviceConnection, String string2) {
            zzn.this.yO.zza(zzn.this.zzaql, serviceConnection, string2, this.yV.zzasy());
            this.yT.add(serviceConnection);
        }

        public void zzb(ServiceConnection serviceConnection, String string2) {
            zzn.this.yO.zzb(zzn.this.zzaql, serviceConnection);
            this.yT.remove(serviceConnection);
        }

        public boolean isBound() {
            return this.yU;
        }

        public int getState() {
            return this.mState;
        }

        public boolean zza(ServiceConnection serviceConnection) {
            return this.yT.contains(serviceConnection);
        }

        public boolean zzasz() {
            return this.yT.isEmpty();
        }

        public IBinder getBinder() {
            return this.xL;
        }

        public ComponentName getComponentName() {
            return this.yR;
        }

        public class zza
        implements ServiceConnection {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                HashMap hashMap = zzn.this.yN;
                synchronized (hashMap) {
                    zzb.this.xL = iBinder;
                    zzb.this.yR = componentName;
                    for (ServiceConnection serviceConnection : zzb.this.yT) {
                        serviceConnection.onServiceConnected(componentName, iBinder);
                    }
                    zzb.this.mState = 1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName componentName) {
                HashMap hashMap = zzn.this.yN;
                synchronized (hashMap) {
                    zzb.this.xL = null;
                    zzb.this.yR = componentName;
                    for (ServiceConnection serviceConnection : zzb.this.yT) {
                        serviceConnection.onServiceDisconnected(componentName);
                    }
                    zzb.this.mState = 2;
                }
            }
        }
    }
}

