/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import java.lang.reflect.Method;

public class ProviderInstaller {
    private static final zzc aug = zzc.zzand();
    private static final Object zzamp = new Object();
    private static Method auh = null;
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installIfNeeded(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        zzab.zzb(context, (Object)"Context must not be null");
        aug.zzbo(context);
        Context context2 = zze.getRemoteContext(context);
        if (context2 == null) {
            Log.e((String)"ProviderInstaller", (String)"Failed to get remote context");
            throw new GooglePlayServicesNotAvailableException(8);
        }
        Object object = zzamp;
        synchronized (object) {
            try {
                if (auh == null) {
                    ProviderInstaller.zzdq(context2);
                }
                auh.invoke(null, context2);
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.e((String)"ProviderInstaller", (String)(string2.length() != 0 ? "Failed to install provider: ".concat(string2) : new String("Failed to install provider: ")));
                throw new GooglePlayServicesNotAvailableException(8);
            }
        }
    }

    public static void installIfNeededAsync(final Context context, final ProviderInstallListener providerInstallListener) {
        zzab.zzb(context, (Object)"Context must not be null");
        zzab.zzb(providerInstallListener, (Object)"Listener must not be null");
        zzab.zzhj("Must be called on the UI thread");
        AsyncTask<Void, Void, Integer> asyncTask = new AsyncTask<Void, Void, Integer>(){

            protected Integer zzc(Void ... voidArray) {
                try {
                    ProviderInstaller.installIfNeeded(context);
                }
                catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
                    return googlePlayServicesRepairableException.getConnectionStatusCode();
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return googlePlayServicesNotAvailableException.errorCode;
                }
                return 0;
            }

            protected void zzg(Integer n) {
                if (n == 0) {
                    providerInstallListener.onProviderInstalled();
                } else {
                    Intent intent = aug.zza(context, n, "pi");
                    providerInstallListener.onProviderInstallFailed(n, intent);
                }
            }

            protected /* synthetic */ void onPostExecute(Object object) {
                this.zzg((Integer)object);
            }

            protected /* synthetic */ Object doInBackground(Object[] objectArray) {
                return this.zzc((Void[])objectArray);
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    private static void zzdq(Context context) throws ClassNotFoundException, NoSuchMethodException {
        ClassLoader classLoader = context.getClassLoader();
        Class<?> clazz = classLoader.loadClass("com.google.android.gms.common.security.ProviderInstallerImpl");
        Class[] classArray = new Class[]{Context.class};
        auh = clazz.getMethod("insertProvider", classArray);
    }

    public static interface ProviderInstallListener {
        public void onProviderInstalled();

        public void onProviderInstallFailed(int var1, Intent var2);
    }
}

