/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzamu;
import com.google.android.gms.internal.zzamz;
import com.google.android.gms.internal.zzanw;
import com.google.android.gms.internal.zzanx;
import com.google.android.gms.internal.zzaoa;
import com.google.android.gms.internal.zzaoo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class zzans {
    private final Map<Type, zzamu<?>> ben;

    public zzans(Map<Type, zzamu<?>> map) {
        this.ben = map;
    }

    public <T> zzanx<T> zzb(zzaoo<T> zzaoo2) {
        final Type type = zzaoo2.t();
        Class<T> clazz = zzaoo2.s();
        final zzamu<?> zzamu2 = this.ben.get(type);
        if (zzamu2 != null) {
            return new zzanx<T>(){

                @Override
                public T a() {
                    return zzamu2.zza(type);
                }
            };
        }
        final zzamu<?> zzamu3 = this.ben.get(clazz);
        if (zzamu3 != null) {
            return new zzanx<T>(){

                @Override
                public T a() {
                    return zzamu3.zza(type);
                }
            };
        }
        zzanx<T> zzanx2 = this.zzl(clazz);
        if (zzanx2 != null) {
            return zzanx2;
        }
        zzanx<T> zzanx3 = this.zzc(type, clazz);
        if (zzanx3 != null) {
            return zzanx3;
        }
        return this.zzd(type, clazz);
    }

    private <T> zzanx<T> zzl(Class<? super T> clazz) {
        try {
            final Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new zzanx<T>(){

                @Override
                public T a() {
                    try {
                        Object var1_1 = null;
                        return constructor.newInstance(null);
                    }
                    catch (InstantiationException instantiationException) {
                        String string2 = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string2).length()).append("Failed to invoke ").append(string2).append(" with no args").toString(), instantiationException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        String string3 = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string3).length()).append("Failed to invoke ").append(string3).append(" with no args").toString(), invocationTargetException.getTargetException());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new AssertionError((Object)illegalAccessException);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private <T> zzanx<T> zzc(final Type type, Class<? super T> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new zzanx<T>(){

                    @Override
                    public T a() {
                        return new TreeSet();
                    }
                };
            }
            if (EnumSet.class.isAssignableFrom(clazz)) {
                return new zzanx<T>(){

                    @Override
                    public T a() {
                        if (type instanceof ParameterizedType) {
                            Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
                            if (type2 instanceof Class) {
                                return EnumSet.noneOf((Class)type2);
                            }
                            String string2 = String.valueOf(type.toString());
                            throw new zzamz(string2.length() != 0 ? "Invalid EnumSet type: ".concat(string2) : new String("Invalid EnumSet type: "));
                        }
                        String string3 = String.valueOf(type.toString());
                        throw new zzamz(string3.length() != 0 ? "Invalid EnumSet type: ".concat(string3) : new String("Invalid EnumSet type: "));
                    }
                };
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new zzanx<T>(){

                    @Override
                    public T a() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return new zzanx<T>(){

                    @Override
                    public T a() {
                        return new LinkedList();
                    }
                };
            }
            return new zzanx<T>(){

                @Override
                public T a() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return new zzanx<T>(){

                    @Override
                    public T a() {
                        return new TreeMap();
                    }
                };
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(zzaoo.zzl(((ParameterizedType)type).getActualTypeArguments()[0]).s())) {
                return new zzanx<T>(){

                    @Override
                    public T a() {
                        return new LinkedHashMap();
                    }
                };
            }
            return new zzanx<T>(){

                @Override
                public T a() {
                    return new zzanw();
                }
            };
        }
        return null;
    }

    private <T> zzanx<T> zzd(final Type type, final Class<? super T> clazz) {
        return new zzanx<T>(){
            private final zzaoa beQ = zzaoa.f();

            @Override
            public T a() {
                try {
                    Object t = this.beQ.zzf(clazz);
                    return t;
                }
                catch (Exception exception) {
                    String string2 = String.valueOf(type);
                    throw new RuntimeException(new StringBuilder(116 + String.valueOf(string2).length()).append("Unable to invoke no-args constructor for ").append(string2).append(". ").append("Register an InstanceCreator with Gson for this type may fix this problem.").toString(), exception);
                }
            }
        };
    }

    public String toString() {
        return this.ben.toString();
    }
}

