/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.stats.zzb;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzcc;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AdvertisingIdClient {
    com.google.android.gms.common.zza zzajb;
    zzcc zzajc;
    boolean zzajd;
    Object zzaje = new Object();
    zza zzajf;
    private final Context mContext;
    final long zzajg;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L);
    }

    public AdvertisingIdClient(Context context, long l) {
        zzab.zzaa(context);
        this.mContext = context;
        this.zzajd = false;
        this.zzajg = l;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.zze(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zze(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzab.zzhk("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzajd) {
                this.finish();
            }
            this.zzajb = AdvertisingIdClient.zzh(this.mContext);
            this.zzajc = AdvertisingIdClient.zza(this.mContext, this.zzajb);
            this.zzajd = true;
            if (bl) {
                this.zzdj();
            }
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzdj() {
        Object object = this.zzaje;
        synchronized (object) {
            if (this.zzajf != null) {
                this.zzajf.cancel();
                try {
                    this.zzajf.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.zzajg > 0L) {
                this.zzajf = new zza(this, this.zzajg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        zzab.zzhk("Calling this from your main thread can lead to deadlock");
        Info info = null;
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzajd) {
                Object object = this.zzaje;
                synchronized (object) {
                    if (this.zzajf == null || !this.zzajf.zzdk()) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.zze(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzajd) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzab.zzaa(this.zzajb);
            zzab.zzaa(this.zzajc);
            try {
                info = new Info(this.zzajc.getId(), this.zzajc.zzf(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzdj();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzab.zzhk("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzajb == null) {
                return;
            }
            try {
                if (this.zzajd) {
                    zzb.zzaut().zza(this.mContext, this.zzajb);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)illegalArgumentException);
            }
            this.zzajd = false;
            this.zzajc = null;
            this.zzajb = null;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    static com.google.android.gms.common.zza zzh(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            PackageManager packageManager = context.getPackageManager();
            packageManager.getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        int n = zzc.zzand().isGooglePlayServicesAvailable(context);
        switch (n) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Google Play services not available");
            }
        }
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            if (zzb.zzaut().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L);
        try {
            advertisingIdClient.zze(false);
            Info info = advertisingIdClient.getInfo();
            return info;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    static zzcc zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzcc.zza.zzf(zza2.zza(10000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzajl;
        private final boolean zzajm;

        public Info(String string2, boolean bl) {
            this.zzajl = string2;
            this.zzajm = bl;
        }

        public String getId() {
            return this.zzajl;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.zzajm;
        }

        public String toString() {
            String string2 = this.zzajl;
            boolean bl = this.zzajm;
            return new StringBuilder(7 + String.valueOf(string2).length()).append("{").append(string2).append("}").append(bl).toString();
        }
    }

    static class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzajh;
        private long zzaji;
        CountDownLatch zzajj;
        boolean zzajk;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzajh = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzaji = l;
            this.zzajj = new CountDownLatch(1);
            this.zzajk = false;
            this.start();
        }

        public void cancel() {
            this.zzajj.countDown();
        }

        public boolean zzdk() {
            return this.zzajk;
        }

        private void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzajh.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzajk = true;
            }
        }

        @Override
        public void run() {
            try {
                if (!this.zzajj.await(this.zzaji, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
            }
        }
    }
}

