/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqp;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

@TargetApi(value=11)
public final class zzqq
extends Fragment
implements zzqp {
    private static WeakHashMap<Activity, WeakReference<zzqq>> vb = new WeakHashMap();
    private Map<String, zzqo> vc = new ArrayMap();
    private int zzblz = 0;
    private Bundle vd;

    public static zzqq zzt(Activity activity) {
        zzqq zzqq2;
        WeakReference<zzqq> weakReference = vb.get(activity);
        if (weakReference != null && (zzqq2 = (zzqq)weakReference.get()) != null) {
            return zzqq2;
        }
        try {
            zzqq2 = (zzqq)activity.getFragmentManager().findFragmentByTag("LifecycleFragmentImpl");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag LifecycleFragmentImpl is not a LifecycleFragmentImpl", classCastException);
        }
        if (zzqq2 == null || zzqq2.isRemoving()) {
            zzqq2 = new zzqq();
            activity.getFragmentManager().beginTransaction().add((Fragment)zzqq2, "LifecycleFragmentImpl").commitAllowingStateLoss();
        }
        vb.put(activity, new WeakReference<zzqq>(zzqq2));
        return zzqq2;
    }

    @Override
    public <T extends zzqo> T zza(String string2, Class<T> clazz) {
        return (T)((zzqo)clazz.cast(this.vc.get(string2)));
    }

    @Override
    public void zza(String string2, @NonNull zzqo zzqo2) {
        if (this.vc.containsKey(string2)) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string2).length()).append("LifecycleCallback with tag ").append(string2).append(" already added to this fragment.").toString());
        }
        this.vc.put(string2, zzqo2);
        this.zzb(string2, zzqo2);
    }

    private void zzb(final String string2, final @NonNull zzqo zzqo2) {
        if (this.zzblz > 0) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (zzqq.this.zzblz >= 1) {
                        zzqo2.onCreate(zzqq.this.vd != null ? zzqq.this.vd.getBundle(string2) : null);
                    }
                    if (zzqq.this.zzblz >= 2) {
                        zzqo2.onStart();
                    }
                    if (zzqq.this.zzblz >= 3) {
                        zzqo2.onStop();
                    }
                }
            });
        }
    }

    @Override
    public Activity zzaqp() {
        return this.getActivity();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzblz = 1;
        this.vd = bundle;
        for (Map.Entry<String, zzqo> entry : this.vc.entrySet()) {
            entry.getValue().onCreate(bundle != null ? bundle.getBundle(entry.getKey()) : null);
        }
    }

    public void onStart() {
        super.onStop();
        this.zzblz = 2;
        for (zzqo zzqo2 : this.vc.values()) {
            zzqo2.onStart();
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        for (zzqo zzqo2 : this.vc.values()) {
            zzqo2.onActivityResult(n, n2, intent);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry<String, zzqo> entry : this.vc.entrySet()) {
            Bundle bundle2 = new Bundle();
            entry.getValue().onSaveInstanceState(bundle2);
            bundle.putBundle(entry.getKey(), bundle2);
        }
    }

    public void onStop() {
        super.onStop();
        this.zzblz = 3;
        for (zzqo zzqo2 : this.vc.values()) {
            zzqo2.onStop();
        }
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        for (zzqo zzqo2 : this.vc.values()) {
            zzqo2.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }
}

