/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.annotation.TargetApi;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.iid.zzb;

public class MessengerCompat
implements Parcelable {
    Messenger acc;
    zzb acd;
    public static final Parcelable.Creator<MessengerCompat> CREATOR = new Parcelable.Creator<MessengerCompat>(){

        public MessengerCompat zzmn(Parcel parcel) {
            IBinder iBinder = parcel.readStrongBinder();
            return iBinder != null ? new MessengerCompat(iBinder) : null;
        }

        public MessengerCompat[] zzsr(int n) {
            return new MessengerCompat[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.zzsr(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzmn(parcel);
        }
    };

    public MessengerCompat(Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.acc = new Messenger(handler);
        } else {
            this.acd = new zza(handler);
        }
    }

    public MessengerCompat(IBinder iBinder) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.acc = new Messenger(iBinder);
        } else {
            this.acd = zzb.zza.zzgq(iBinder);
        }
    }

    public static int zzc(Message message) {
        if (Build.VERSION.SDK_INT >= 21) {
            return MessengerCompat.zzd(message);
        }
        return message.arg2;
    }

    @TargetApi(value=21)
    private static int zzd(Message message) {
        return message.sendingUid;
    }

    public void send(Message message) throws RemoteException {
        if (this.acc != null) {
            this.acc.send(message);
        } else {
            this.acd.send(message);
        }
    }

    public IBinder getBinder() {
        return this.acc != null ? this.acc.getBinder() : this.acd.asBinder();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            return this.getBinder().equals(((MessengerCompat)object).getBinder());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.getBinder().hashCode();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (this.acc != null) {
            parcel.writeStrongBinder(this.acc.getBinder());
        } else {
            parcel.writeStrongBinder(this.acd.asBinder());
        }
    }

    private final class zza
    extends zzb.zza {
        Handler handler;

        zza(Handler handler) {
            this.handler = handler;
        }

        @Override
        public void send(Message message) throws RemoteException {
            message.arg2 = Binder.getCallingUid();
            this.handler.dispatchMessage(message);
        }
    }
}

