/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzm;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class zzn
extends zzm
implements Handler.Callback {
    private final HashMap<zza, zzb> yB = new HashMap();
    private final Context zzaqj;
    private final Handler mHandler;
    private final com.google.android.gms.common.stats.zzb yC;
    private final long yD;

    zzn(Context context) {
        this.zzaqj = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.yC = com.google.android.gms.common.stats.zzb.zzaut();
        this.yD = 5000L;
    }

    @Override
    public boolean zza(String string2, String string3, ServiceConnection serviceConnection, String string4) {
        return this.zza(new zza(string2, string3), serviceConnection, string4);
    }

    @Override
    public boolean zza(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzab.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.yB;
        synchronized (hashMap) {
            zzb zzb2 = this.yB.get(zza2);
            if (zzb2 == null) {
                zzb2 = new zzb(zza2);
                zzb2.zza(serviceConnection, string2);
                zzb2.zzhn(string2);
                this.yB.put(zza2, zzb2);
            } else {
                this.mHandler.removeMessages(0, (Object)zzb2);
                if (zzb2.zza(serviceConnection)) {
                    String string3 = String.valueOf(zza2);
                    throw new IllegalStateException(new StringBuilder(81 + String.valueOf(string3).length()).append("Trying to bind a GmsServiceConnection that was already connected before.  config=").append(string3).toString());
                }
                zzb2.zza(serviceConnection, string2);
                switch (zzb2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzb2.getComponentName(), zzb2.getBinder());
                        break;
                    }
                    case 2: {
                        zzb2.zzhn(string2);
                    }
                }
            }
            return zzb2.isBound();
        }
    }

    @Override
    public void zzb(String string2, String string3, ServiceConnection serviceConnection, String string4) {
        this.zzb(new zza(string2, string3), serviceConnection, string4);
    }

    @Override
    public void zzb(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzab.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.yB;
        synchronized (hashMap) {
            zzb zzb2 = this.yB.get(zza2);
            if (zzb2 == null) {
                String string3 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(50 + String.valueOf(string3).length()).append("Nonexistent connection status for service config: ").append(string3).toString());
            }
            if (!zzb2.zza(serviceConnection)) {
                String string4 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(76 + String.valueOf(string4).length()).append("Trying to unbind a GmsServiceConnection  that was not bound before.  config=").append(string4).toString());
            }
            zzb2.zzb(serviceConnection, string2);
            if (zzb2.zzasv()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zzb2);
                this.mHandler.sendMessageDelayed(message, this.yD);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                zzb zzb2 = (zzb)message.obj;
                HashMap<zza, zzb> hashMap = this.yB;
                synchronized (hashMap) {
                    if (zzb2.zzasv()) {
                        if (zzb2.isBound()) {
                            zzb2.zzho("GmsClientSupervisor");
                        }
                        this.yB.remove(zzb2.yJ);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static final class zza {
        private final String zzcvf;
        private final String yE;
        private final ComponentName yF;

        public zza(String string2, String string3) {
            this.zzcvf = zzab.zzhs(string2);
            this.yE = zzab.zzhs(string3);
            this.yF = null;
        }

        public zza(ComponentName componentName) {
            this.zzcvf = null;
            this.yE = null;
            this.yF = zzab.zzaa(componentName);
        }

        public String toString() {
            return this.zzcvf == null ? this.yF.flattenToString() : this.zzcvf;
        }

        public Intent zzasu() {
            Intent intent = this.zzcvf != null ? new Intent(this.zzcvf).setPackage(this.yE) : new Intent().setComponent(this.yF);
            return intent;
        }

        public int hashCode() {
            return zzaa.hashCode(this.zzcvf, this.yF);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)object;
            return zzaa.equal(this.zzcvf, zza2.zzcvf) && zzaa.equal(this.yF, zza2.yF);
        }
    }

    private final class zzb {
        private final zza yG;
        private final Set<ServiceConnection> yH;
        private int mState;
        private boolean yI;
        private IBinder xA;
        private final com.google.android.gms.common.internal.zzn$zza yJ;
        private ComponentName yF;

        public zzb(com.google.android.gms.common.internal.zzn$zza zza2) {
            this.yJ = zza2;
            this.yG = new zza();
            this.yH = new HashSet<ServiceConnection>();
            this.mState = 2;
        }

        @TargetApi(value=14)
        public void zzhn(String string2) {
            this.mState = 3;
            this.yI = zzn.this.yC.zza(zzn.this.zzaqj, string2, this.yJ.zzasu(), this.yG, 129);
            if (!this.yI) {
                this.mState = 2;
                try {
                    zzn.this.yC.zza(zzn.this.zzaqj, this.yG);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public void zzho(String string2) {
            zzn.this.yC.zza(zzn.this.zzaqj, this.yG);
            this.yI = false;
            this.mState = 2;
        }

        public void zza(ServiceConnection serviceConnection, String string2) {
            zzn.this.yC.zza(zzn.this.zzaqj, serviceConnection, string2, this.yJ.zzasu());
            this.yH.add(serviceConnection);
        }

        public void zzb(ServiceConnection serviceConnection, String string2) {
            zzn.this.yC.zzb(zzn.this.zzaqj, serviceConnection);
            this.yH.remove(serviceConnection);
        }

        public boolean isBound() {
            return this.yI;
        }

        public int getState() {
            return this.mState;
        }

        public boolean zza(ServiceConnection serviceConnection) {
            return this.yH.contains(serviceConnection);
        }

        public boolean zzasv() {
            return this.yH.isEmpty();
        }

        public IBinder getBinder() {
            return this.xA;
        }

        public ComponentName getComponentName() {
            return this.yF;
        }

        public class zza
        implements ServiceConnection {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                HashMap hashMap = zzn.this.yB;
                synchronized (hashMap) {
                    zzb.this.xA = iBinder;
                    zzb.this.yF = componentName;
                    for (ServiceConnection serviceConnection : zzb.this.yH) {
                        serviceConnection.onServiceConnected(componentName, iBinder);
                    }
                    zzb.this.mState = 1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName componentName) {
                HashMap hashMap = zzn.this.yB;
                synchronized (hashMap) {
                    zzb.this.xA = null;
                    zzb.this.yF = componentName;
                    for (ServiceConnection serviceConnection : zzb.this.yH) {
                        serviceConnection.onServiceDisconnected(componentName);
                    }
                    zzb.this.mState = 2;
                }
            }
        }
    }
}

