/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzf;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;

public final class Status
extends AbstractSafeParcelable
implements Result {
    public static final Status sg = new Status(0);
    public static final Status sh = new Status(14);
    public static final Status si = new Status(8);
    public static final Status sj = new Status(15);
    public static final Status sk = new Status(16);
    public static final Status sl = new Status(17);
    public static final Status sm = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zzf();
    private final int mVersionCode;
    private final int ob;
    private final String qS;
    private final PendingIntent mPendingIntent;

    Status(int n, int n2, String string2, PendingIntent pendingIntent) {
        this.mVersionCode = n;
        this.ob = n2;
        this.qS = string2;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int n) {
        this(n, null);
    }

    public Status(int n, String string2) {
        this(1, n, string2, null);
    }

    public Status(int n, String string2, PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), n, null, 0, 0, 0);
    }

    PendingIntent zzaoi() {
        return this.mPendingIntent;
    }

    @Nullable
    public String getStatusMessage() {
        return this.qS;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.ob <= 0;
    }

    public boolean isCanceled() {
        return this.ob == 16;
    }

    public boolean isInterrupted() {
        return this.ob == 14;
    }

    public int getStatusCode() {
        return this.ob;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return zzaa.hashCode(this.mVersionCode, this.ob, this.qS, this.mPendingIntent);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.mVersionCode == status.mVersionCode && this.ob == status.ob && zzaa.equal(this.qS, status.qS) && zzaa.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String zzaoj() {
        if (this.qS != null) {
            return this.qS;
        }
        return CommonStatusCodes.getStatusCodeString(this.ob);
    }

    public String toString() {
        return zzaa.zzz(this).zzg("statusCode", this.zzaoj()).zzg("resolution", this.mPendingIntent).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzf.zza(this, parcel, n);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

