/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzamj;
import com.google.android.gms.internal.zzamm;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzamc {
    private final ByteBuffer zzbZZ;

    private zzamc(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzamc(ByteBuffer byteBuffer) {
        this.zzbZZ = byteBuffer;
        this.zzbZZ.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzamc zzO(byte[] byArray) {
        return zzamc.zzb(byArray, 0, byArray.length);
    }

    public static zzamc zzb(byte[] byArray, int n, int n2) {
        return new zzamc(byArray, n, n2);
    }

    public void zza(int n, double d) throws IOException {
        this.zzI(n, 1);
        this.zzp(d);
    }

    public void zzb(int n, float f) throws IOException {
        this.zzI(n, 5);
        this.zzi(f);
    }

    public void zza(int n, long l) throws IOException {
        this.zzI(n, 0);
        this.zzaP(l);
    }

    public void zzb(int n, long l) throws IOException {
        this.zzI(n, 0);
        this.zzaQ(l);
    }

    public void zzE(int n, int n2) throws IOException {
        this.zzI(n, 0);
        this.zzoa(n2);
    }

    public void zzc(int n, long l) throws IOException {
        this.zzI(n, 1);
        this.zzaR(l);
    }

    public void zzj(int n, boolean bl) throws IOException {
        this.zzI(n, 0);
        this.zzbc(bl);
    }

    public void zzq(int n, String string2) throws IOException {
        this.zzI(n, 2);
        this.zziY(string2);
    }

    public void zza(int n, zzamj zzamj2) throws IOException {
        this.zzI(n, 2);
        this.zzc(zzamj2);
    }

    public void zza(int n, byte[] byArray) throws IOException {
        this.zzI(n, 2);
        this.zzP(byArray);
    }

    public void zzF(int n, int n2) throws IOException {
        this.zzI(n, 0);
        this.zzob(n2);
    }

    public void zzd(int n, long l) throws IOException {
        this.zzI(n, 0);
        this.zzaS(l);
    }

    public void zzp(double d) throws IOException {
        this.zzaZ(Double.doubleToLongBits(d));
    }

    public void zzi(float f) throws IOException {
        this.zzoi(Float.floatToIntBits(f));
    }

    public void zzaP(long l) throws IOException {
        this.zzaX(l);
    }

    public void zzaQ(long l) throws IOException {
        this.zzaX(l);
    }

    public void zzoa(int n) throws IOException {
        if (n >= 0) {
            this.zzog(n);
        } else {
            this.zzaX(n);
        }
    }

    public void zzaR(long l) throws IOException {
        this.zzaZ(l);
    }

    public void zzbc(boolean bl) throws IOException {
        this.zzoe(bl ? 1 : 0);
    }

    public void zziY(String string2) throws IOException {
        try {
            int n = zzamc.zzoh(string2.length());
            int n2 = zzamc.zzoh(string2.length() * 3);
            if (n == n2) {
                int n3 = this.zzbZZ.position();
                if (this.zzbZZ.remaining() < n) {
                    throw new zza(n3 + n, this.zzbZZ.limit());
                }
                this.zzbZZ.position(n3 + n);
                zzamc.zza((CharSequence)string2, this.zzbZZ);
                int n4 = this.zzbZZ.position();
                this.zzbZZ.position(n3);
                this.zzog(n4 - n3 - n);
                this.zzbZZ.position(n4);
            } else {
                this.zzog(zzamc.zzd(string2));
                zzamc.zza((CharSequence)string2, this.zzbZZ);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            zza zza2 = new zza(this.zzbZZ.position(), this.zzbZZ.limit());
            zza2.initCause(bufferOverflowException);
            throw zza2;
        }
    }

    private static int zzd(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += zzamc.zza(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static int zza(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                int n5 = i;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n5).toString());
            }
            ++i;
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zzamc.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        } else {
            zzamc.zzb(charSequence, byteBuffer);
        }
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                n2 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n2).toString());
            }
            n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n + n4;
        }
        n5 = n + n3;
        while (n3 < n4) {
            int n7;
            char c2;
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c;
            } else if (c < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if (n5 <= n6 - 4) {
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    n7 = n3 - 1;
                    throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                }
                n7 = Character.toCodePoint(c, c2);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                c2 = c;
                n7 = n5;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n7).toString());
            }
            ++n3;
        }
        return n5;
    }

    public void zzb(zzamj zzamj2) throws IOException {
        zzamj2.writeTo(this);
    }

    public void zzc(zzamj zzamj2) throws IOException {
        this.zzog(zzamj2.getCachedSize());
        zzamj2.writeTo(this);
    }

    public void zzP(byte[] byArray) throws IOException {
        this.zzog(byArray.length);
        this.zzR(byArray);
    }

    public void zzob(int n) throws IOException {
        this.zzog(zzamc.zzoj(n));
    }

    public void zzaS(long l) throws IOException {
        this.zzaX(zzamc.zzba(l));
    }

    public static int zzb(int n, double d) {
        return zzamc.zzof(n) + zzamc.zzq(d);
    }

    public static int zzc(int n, float f) {
        return zzamc.zzof(n) + zzamc.zzj(f);
    }

    public static int zze(int n, long l) {
        return zzamc.zzof(n) + zzamc.zzaU(l);
    }

    public static int zzG(int n, int n2) {
        return zzamc.zzof(n) + zzamc.zzoc(n2);
    }

    public static int zzf(int n, long l) {
        return zzamc.zzof(n) + zzamc.zzaV(l);
    }

    public static int zzk(int n, boolean bl) {
        return zzamc.zzof(n) + zzamc.zzbd(bl);
    }

    public static int zzr(int n, String string2) {
        return zzamc.zzof(n) + zzamc.zziZ(string2);
    }

    public static int zzb(int n, zzamj zzamj2) {
        return zzamc.zzof(n) * 2 + zzamc.zzd(zzamj2);
    }

    public static int zzc(int n, zzamj zzamj2) {
        return zzamc.zzof(n) + zzamc.zze(zzamj2);
    }

    public static int zzb(int n, byte[] byArray) {
        return zzamc.zzof(n) + zzamc.zzQ(byArray);
    }

    public static int zzH(int n, int n2) {
        return zzamc.zzof(n) + zzamc.zzod(n2);
    }

    public static int zzg(int n, long l) {
        return zzamc.zzof(n) + zzamc.zzaW(l);
    }

    public static int zzq(double d) {
        return 8;
    }

    public static int zzj(float f) {
        return 4;
    }

    public static int zzaT(long l) {
        return zzamc.zzaY(l);
    }

    public static int zzaU(long l) {
        return zzamc.zzaY(l);
    }

    public static int zzoc(int n) {
        if (n >= 0) {
            return zzamc.zzoh(n);
        }
        return 10;
    }

    public static int zzaV(long l) {
        return 8;
    }

    public static int zzbd(boolean bl) {
        return 1;
    }

    public static int zziZ(String string2) {
        int n = zzamc.zzd(string2);
        return zzamc.zzoh(n) + n;
    }

    public static int zzd(zzamj zzamj2) {
        return zzamj2.getSerializedSize();
    }

    public static int zze(zzamj zzamj2) {
        int n = zzamj2.getSerializedSize();
        return zzamc.zzoh(n) + n;
    }

    public static int zzQ(byte[] byArray) {
        return zzamc.zzoh(byArray.length) + byArray.length;
    }

    public static int zzod(int n) {
        return zzamc.zzoh(zzamc.zzoj(n));
    }

    public static int zzaW(long l) {
        return zzamc.zzaY(zzamc.zzba(l));
    }

    public int zzWT() {
        return this.zzbZZ.remaining();
    }

    public void zzWU() {
        if (this.zzWT() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void zzc(byte by) throws IOException {
        if (!this.zzbZZ.hasRemaining()) {
            throw new zza(this.zzbZZ.position(), this.zzbZZ.limit());
        }
        this.zzbZZ.put(by);
    }

    public void zzoe(int n) throws IOException {
        this.zzc((byte)n);
    }

    public void zzR(byte[] byArray) throws IOException {
        this.zzc(byArray, 0, byArray.length);
    }

    public void zzc(byte[] byArray, int n, int n2) throws IOException {
        if (this.zzbZZ.remaining() < n2) {
            throw new zza(this.zzbZZ.position(), this.zzbZZ.limit());
        }
        this.zzbZZ.put(byArray, n, n2);
    }

    public void zzI(int n, int n2) throws IOException {
        this.zzog(zzamm.zzJ(n, n2));
    }

    public static int zzof(int n) {
        return zzamc.zzoh(zzamm.zzJ(n, 0));
    }

    public void zzog(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzoe(n);
                return;
            }
            this.zzoe(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzoh(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void zzaX(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzoe((int)l);
                return;
            }
            this.zzoe((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzaY(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void zzoi(int n) throws IOException {
        if (this.zzbZZ.remaining() < 4) {
            throw new zza(this.zzbZZ.position(), this.zzbZZ.limit());
        }
        this.zzbZZ.putInt(n);
    }

    public void zzaZ(long l) throws IOException {
        if (this.zzbZZ.remaining() < 8) {
            throw new zza(this.zzbZZ.position(), this.zzbZZ.limit());
        }
        this.zzbZZ.putLong(l);
    }

    public static int zzoj(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long zzba(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class zza
    extends IOException {
        zza(int n, int n2) {
            super(new StringBuilder(108).append("CodedOutputStream was writing to a flat byte array and ran out of space (pos ").append(n).append(" limit ").append(n2).append(").").toString());
        }
    }
}

