/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.BinderThread;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzd<T extends IInterface> {
    private int zzaqr;
    private long zzaqs;
    private long zzaqt;
    private int zzaqu;
    private long zzaqv;
    private final Context mContext;
    private final Looper zzakW;
    private final zzm zzaqw;
    private final com.google.android.gms.common.zzc zzamE;
    final Handler mHandler;
    private final Object zzpp = new Object();
    private final Object zzaqx = new Object();
    private zzu zzaqy;
    private zzf zzaqz;
    private T zzaqA;
    private final ArrayList<zze<?>> zzaqB = new ArrayList();
    private zzh zzaqC;
    private int zzaqD = 1;
    private final zzb zzaqE;
    private final zzc zzaqF;
    private final int zzaqG;
    private final String zzaqH;
    protected AtomicInteger zzaqI = new AtomicInteger(0);
    public static final String[] zzaqJ = new String[]{"service_esmobile", "service_googleme"};

    protected zzd(Context context, Looper looper, int n, zzb zzb2, zzc zzc2, String string2) {
        this(context, looper, zzm.zzav(context), com.google.android.gms.common.zzc.zzqV(), n, zzaa.zzz(zzb2), zzaa.zzz(zzc2), string2);
    }

    protected zzd(Context context, Looper looper, zzm zzm2, com.google.android.gms.common.zzc zzc2, int n, zzb zzb2, zzc zzc3, String string2) {
        this.mContext = zzaa.zzb(context, (Object)"Context must not be null");
        this.zzakW = zzaa.zzb(looper, (Object)"Looper must not be null");
        this.zzaqw = zzaa.zzb(zzm2, (Object)"Supervisor must not be null");
        this.zzamE = zzaa.zzb(zzc2, (Object)"API availability must not be null");
        this.mHandler = new zzd(looper);
        this.zzaqG = n;
        this.zzaqE = zzb2;
        this.zzaqF = zzc3;
        this.zzaqH = string2;
    }

    @NonNull
    protected abstract String zzhT();

    protected String zztf() {
        return "com.google.android.gms";
    }

    @NonNull
    protected abstract String zzhU();

    @Nullable
    protected final String zztg() {
        return this.zzaqH == null ? this.mContext.getClass().getName() : this.zzaqH;
    }

    @Nullable
    protected abstract T zzab(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.zzaqt = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionSuspended(int n) {
        this.zzaqr = n;
        this.zzaqs = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzaqu = connectionResult.getErrorCode();
        this.zzaqv = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(int n, T t) {
        zzaa.zzaj(n == 3 == (t != null));
        Object object = this.zzpp;
        synchronized (object) {
            this.zzaqD = n;
            this.zzaqA = t;
            this.zzc(n, t);
            switch (n) {
                case 2: {
                    this.zzth();
                    break;
                }
                case 3: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    this.zzti();
                }
            }
        }
    }

    void zzc(int n, T t) {
    }

    private void zzth() {
        String string2;
        if (this.zzaqC != null) {
            String string3 = String.valueOf(this.zzhT());
            string2 = String.valueOf(this.zztf());
            Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
            this.zzaqw.zzb(this.zzhT(), this.zztf(), this.zzaqC, this.zztg());
            this.zzaqI.incrementAndGet();
        }
        this.zzaqC = new zzh(this.zzaqI.get());
        boolean bl = this.zzaqw.zza(this.zzhT(), this.zztf(), this.zzaqC, this.zztg());
        if (!bl) {
            string2 = String.valueOf(this.zzhT());
            String string4 = String.valueOf(this.zztf());
            Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string4).toString());
            this.zza(16, null, this.zzaqI.get());
        }
    }

    private void zzti() {
        if (this.zzaqC != null) {
            this.zzaqw.zzb(this.zzhT(), this.zztf(), this.zzaqC, this.zztg());
            this.zzaqC = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, int n2, T t) {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzaqD != n) {
                return false;
            }
            this.zzb(n2, t);
            return true;
        }
    }

    public void zztj() {
        int n = this.zzamE.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zzb(1, null);
            this.zzaqz = new zzi();
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzaqI.get(), n));
            return;
        }
        this.zza(new zzi());
    }

    public void zza(@NonNull zzf zzf2) {
        this.zzaqz = zzaa.zzb(zzf2, (Object)"Connection progress callbacks cannot be null.");
        this.zzb(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzaqD == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.zzpp;
        synchronized (object) {
            return this.zzaqD == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.zzaqI.incrementAndGet();
        Object object = this.zzaqB;
        synchronized (object) {
            int n = this.zzaqB.size();
            for (int i = 0; i < n; ++i) {
                this.zzaqB.get(i).zzts();
            }
            this.zzaqB.clear();
        }
        object = this.zzaqx;
        synchronized (object) {
            this.zzaqy = null;
        }
        this.zzb(1, null);
    }

    public void zzbZ(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, this.zzaqI.get(), n));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzakW;
    }

    public Account getAccount() {
        return null;
    }

    public final Account zztk() {
        return this.getAccount() != null ? this.getAccount() : new Account("<<default account>>", "com.google");
    }

    protected Bundle zzoO() {
        return new Bundle();
    }

    @BinderThread
    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzj(n, iBinder, bundle)));
    }

    protected void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n2, -1, (Object)new zzk(n, bundle)));
    }

    protected final void zztl() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzqr() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zztm() throws DeadObjectException {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzaqD == 4) {
                throw new DeadObjectException();
            }
            this.zztl();
            zzaa.zza(this.zzaqA != null, (Object)"Client is connected but service is null");
            return this.zzaqA;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zza(zzq zzq2, Set<Scope> set) {
        try {
            Bundle bundle = this.zzoO();
            GetServiceRequest getServiceRequest = new GetServiceRequest(this.zzaqG).zzdf(this.mContext.getPackageName()).zzl(bundle);
            if (set != null) {
                getServiceRequest.zzd(set);
            }
            if (this.zzpd()) {
                getServiceRequest.zzc(this.zztk()).zzb(zzq2);
            } else if (this.zztn()) {
                getServiceRequest.zzc(this.getAccount());
            }
            Object object = this.zzaqx;
            synchronized (object) {
                if (this.zzaqy != null) {
                    this.zzaqy.zza((zzt)new zzg(this, this.zzaqI.get()), getServiceRequest);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzbZ(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    public boolean zzpd() {
        return false;
    }

    public boolean zztn() {
        return false;
    }

    public boolean zzrg() {
        return true;
    }

    public boolean zzps() {
        return false;
    }

    public Intent zzpt() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzto() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        T t;
        int n;
        Object object = this.zzpp;
        synchronized (object) {
            n = this.zzaqD;
            t = this.zzaqA;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("CONNECTED");
                break;
            }
            case 4: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.println("null");
        } else {
            printWriter.append(this.zzhU()).append("@").println(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzaqt > 0L) {
            l = this.zzaqt;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaqt)));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzaqs > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzaqr) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzaqr));
                }
            }
            l = this.zzaqs;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaqs)));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzaqv > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzaqu));
            l = this.zzaqv;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.zzaqv)));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IBinder zzrh() {
        Object object = this.zzaqx;
        synchronized (object) {
            if (this.zzaqy == null) {
                return null;
            }
            return this.zzaqy.asBinder();
        }
    }

    public static final class zzg
    extends zzt.zza {
        private zzd zzaqN;
        private final int zzaqO;

        public zzg(@NonNull zzd zzd2, int n) {
            this.zzaqN = zzd2;
            this.zzaqO = n;
        }

        @Override
        @BinderThread
        public void zzb(int n, @Nullable Bundle bundle) {
            Log.wtf((String)"GmsClient", (String)"received deprecated onAccountValidationComplete callback, ignoring", (Throwable)new Exception());
        }

        @Override
        @BinderThread
        public void zza(int n, @NonNull IBinder iBinder, @Nullable Bundle bundle) {
            zzaa.zzb(this.zzaqN, (Object)"onPostInitComplete can be called only once per call to getRemoteService");
            this.zzaqN.zza(n, iBinder, bundle, this.zzaqO);
            this.zztt();
        }

        private void zztt() {
            this.zzaqN = null;
        }
    }

    private abstract class zza
    extends zze<Boolean> {
        public final int statusCode;
        public final Bundle zzaqK;

        @BinderThread
        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.zzaqK = bundle;
        }

        protected abstract boolean zztp();

        protected abstract void zzl(ConnectionResult var1);

        protected void zzc(Boolean bl) {
            if (bl == null) {
                zzd.this.zzb(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.zztp()) break;
                    zzd.this.zzb(1, null);
                    this.zzl(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    zzd.this.zzb(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    zzd.this.zzb(1, null);
                    PendingIntent pendingIntent = null;
                    if (this.zzaqK != null) {
                        pendingIntent = (PendingIntent)this.zzaqK.getParcelable("pendingIntent");
                    }
                    this.zzl(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void zztq() {
        }

        @Override
        protected /* synthetic */ void zzw(Object object) {
            this.zzc((Boolean)object);
        }
    }

    protected final class zzj
    extends zza {
        public final IBinder zzaqP;

        @BinderThread
        public zzj(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zzaqP = iBinder;
        }

        @Override
        protected void zzl(ConnectionResult connectionResult) {
            if (zzd.this.zzaqF != null) {
                zzd.this.zzaqF.onConnectionFailed(connectionResult);
            }
            zzd.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zztp() {
            String string2;
            try {
                string2 = this.zzaqP.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!zzd.this.zzhU().equals(string2)) {
                String string3 = String.valueOf(zzd.this.zzhU());
                Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("service descriptor mismatch: ").append(string3).append(" vs. ").append(string2).toString());
                return false;
            }
            Object t = zzd.this.zzab(this.zzaqP);
            if (t != null && zzd.this.zza(2, 3, t)) {
                Bundle bundle = zzd.this.zzqr();
                if (zzd.this.zzaqE != null) {
                    zzd.this.zzaqE.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzk
    extends zza {
        @BinderThread
        public zzk(int n, @Nullable Bundle bundle) {
            super(n, bundle);
        }

        @Override
        protected void zzl(ConnectionResult connectionResult) {
            zzd.this.zzaqz.zzh(connectionResult);
            zzd.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zztp() {
            zzd.this.zzaqz.zzh(ConnectionResult.zzakj);
            return true;
        }
    }

    protected class zzi
    implements zzf {
        @Override
        public void zzh(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                zzd.this.zza(null, zzd.this.zzto());
            } else if (zzd.this.zzaqF != null) {
                zzd.this.zzaqF.onConnectionFailed(connectionResult);
            }
        }
    }

    protected abstract class zze<TListener> {
        private TListener mListener;
        private boolean zzaqM;

        public zze(TListener TListener) {
            this.mListener = TListener;
            this.zzaqM = false;
        }

        protected abstract void zzw(TListener var1);

        protected abstract void zztq();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zztr() {
            TListener TListener;
            zze zze2 = this;
            synchronized (zze2) {
                TListener = this.mListener;
                if (this.zzaqM) {
                    String string2 = String.valueOf(this);
                    Log.w((String)"GmsClient", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Callback proxy ").append(string2).append(" being reused. This is not safe.").toString());
                }
            }
            if (TListener != null) {
                try {
                    this.zzw(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zztq();
                    throw runtimeException;
                }
            } else {
                this.zztq();
            }
            zze2 = this;
            synchronized (zze2) {
                this.zzaqM = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.zzts();
            ArrayList arrayList = zzd.this.zzaqB;
            synchronized (arrayList) {
                zzd.this.zzaqB.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzts() {
            zze zze2 = this;
            synchronized (zze2) {
                this.mListener = null;
            }
        }
    }

    final class zzd
    extends Handler {
        public zzd(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            if (zzd.this.zzaqI.get() != message.arg1) {
                if (this.zzb(message)) {
                    this.zza(message);
                }
                return;
            }
            if (!(message.what != 1 && message.what != 5 || zzd.this.isConnecting())) {
                this.zza(message);
                return;
            }
            if (message.what == 3) {
                PendingIntent pendingIntent = message.obj instanceof PendingIntent ? (PendingIntent)message.obj : null;
                ConnectionResult connectionResult = new ConnectionResult(message.arg2, pendingIntent);
                zzd.this.zzaqz.zzh(connectionResult);
                zzd.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 4) {
                zzd.this.zzb(4, null);
                if (zzd.this.zzaqE != null) {
                    zzd.this.zzaqE.onConnectionSuspended(message.arg2);
                }
                zzd.this.onConnectionSuspended(message.arg2);
                zzd.this.zza(4, 1, null);
                return;
            }
            if (message.what == 2 && !zzd.this.isConnected()) {
                this.zza(message);
                return;
            }
            if (this.zzb(message)) {
                zze zze2 = (zze)message.obj;
                zze2.zztr();
                return;
            }
            int n = message.what;
            Log.wtf((String)"GmsClient", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        private void zza(Message message) {
            zze zze2 = (zze)message.obj;
            zze2.zztq();
            zze2.unregister();
        }

        private boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 5;
        }
    }

    public static interface zzf {
        public void zzh(@NonNull ConnectionResult var1);
    }

    public static interface zzc {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface zzb {
        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }

    public final class zzh
    implements ServiceConnection {
        private final int zzaqO;

        public zzh(int n) {
            this.zzaqO = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzaa.zzb(iBinder, (Object)"Expecting a valid IBinder");
            Object object = zzd.this.zzaqx;
            synchronized (object) {
                zzd.this.zzaqy = zzu.zza.zzaW(iBinder);
            }
            zzd.this.zza(0, null, this.zzaqO);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName componentName) {
            Object object = zzd.this.zzaqx;
            synchronized (object) {
                zzd.this.zzaqy = null;
            }
            zzd.this.mHandler.sendMessage(zzd.this.mHandler.obtainMessage(4, this.zzaqO, 1));
        }
    }
}

