/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.phenotype;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.phenotype.zzb;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;

public class Flag
extends AbstractSafeParcelable
implements Comparable<Flag> {
    public static final Parcelable.Creator<Flag> CREATOR = new zzb();
    final int mVersionCode;
    public final String name;
    final long zzbkF;
    final boolean zzaTF;
    final double zzaTH;
    final String zzasH;
    final byte[] zzbkG;
    public final int zzbkH;
    public final int zzbkI;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final zza zzbkJ = new zza();

    Flag(int n, String string2, long l, boolean bl, double d, String string3, byte[] byArray, int n2, int n3) {
        this.mVersionCode = n;
        this.name = string2;
        this.zzbkF = l;
        this.zzaTF = bl;
        this.zzaTH = d;
        this.zzasH = string3;
        this.zzbkG = byArray;
        this.zzbkH = n2;
        this.zzbkI = n3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Flag(");
        stringBuilder.append(this.mVersionCode);
        stringBuilder.append(", ");
        stringBuilder.append(this.name);
        stringBuilder.append(", ");
        switch (this.zzbkH) {
            case 1: {
                stringBuilder.append(this.zzbkF);
                break;
            }
            case 2: {
                stringBuilder.append(this.zzaTF);
                break;
            }
            case 3: {
                stringBuilder.append(this.zzaTH);
                break;
            }
            case 4: {
                stringBuilder.append("'");
                stringBuilder.append(this.zzasH);
                stringBuilder.append("'");
                break;
            }
            case 5: {
                if (this.zzbkG == null) {
                    stringBuilder.append("null");
                    break;
                }
                stringBuilder.append("'");
                stringBuilder.append(new String(this.zzbkG, UTF_8));
                stringBuilder.append("'");
                break;
            }
            default: {
                int n = this.zzbkH;
                throw new AssertionError((Object)new StringBuilder(31).append("Invalid enum value: ").append(n).toString());
            }
        }
        stringBuilder.append(", ");
        stringBuilder.append(this.zzbkH);
        stringBuilder.append(", ");
        stringBuilder.append(this.zzbkI);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Flag) {
            Flag flag = (Flag)object;
            if (this.mVersionCode != flag.mVersionCode || !zzz.equal(this.name, flag.name) || this.zzbkH != flag.zzbkH || this.zzbkI != flag.zzbkI) {
                return false;
            }
            switch (this.zzbkH) {
                case 1: {
                    return this.zzbkF == flag.zzbkF;
                }
                case 2: {
                    return this.zzaTF == flag.zzaTF;
                }
                case 3: {
                    return this.zzaTH == flag.zzaTH;
                }
                case 4: {
                    return zzz.equal(this.zzasH, flag.zzasH);
                }
                case 5: {
                    return Arrays.equals(this.zzbkG, flag.zzbkG);
                }
            }
            int n = this.zzbkH;
            throw new AssertionError((Object)new StringBuilder(31).append("Invalid enum value: ").append(n).toString());
        }
        return false;
    }

    public int zza(Flag flag) {
        int n = this.name.compareTo(flag.name);
        if (n != 0) {
            return n;
        }
        n = Flag.compare(this.zzbkH, flag.zzbkH);
        if (n != 0) {
            return n;
        }
        switch (this.zzbkH) {
            case 1: {
                return Flag.compare(this.zzbkF, flag.zzbkF);
            }
            case 2: {
                return Flag.compare(this.zzaTF, flag.zzaTF);
            }
            case 3: {
                return Double.compare(this.zzaTH, flag.zzaTH);
            }
            case 4: {
                return Flag.compare(this.zzasH, flag.zzasH);
            }
            case 5: {
                if (this.zzbkG == flag.zzbkG) {
                    return 0;
                }
                if (this.zzbkG == null) {
                    return -1;
                }
                if (flag.zzbkG == null) {
                    return 1;
                }
                for (int i = 0; i < Math.min(this.zzbkG.length, flag.zzbkG.length); ++i) {
                    n = Flag.compare(this.zzbkG[i], flag.zzbkG[i]);
                    if (n == 0) continue;
                    return n;
                }
                return Flag.compare(this.zzbkG.length, flag.zzbkG.length);
            }
        }
        int n2 = this.zzbkH;
        throw new AssertionError((Object)new StringBuilder(31).append("Invalid enum value: ").append(n2).toString());
    }

    private static int compare(String string2, String string3) {
        if (string2 == string3) {
            return 0;
        }
        if (string2 == null) {
            return -1;
        }
        if (string3 == null) {
            return 1;
        }
        return string2.compareTo(string3);
    }

    private static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    private static int compare(long l, long l2) {
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    private static int compare(boolean bl, boolean bl2) {
        return bl == bl2 ? 0 : (bl ? 1 : -1);
    }

    private static int compare(byte by, byte by2) {
        return by - by2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zza((Flag)object);
    }

    public static class zza
    implements Comparator<Flag> {
        public int zza(Flag flag, Flag flag2) {
            if (flag.zzbkI == flag2.zzbkI) {
                return flag.name.compareTo(flag2.name);
            }
            return flag.zzbkI - flag2.zzbkI;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Flag)object, (Flag)object2);
        }
    }
}

