/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.android.gms.internal.zzb;
import com.google.android.gms.internal.zzd;
import com.google.android.gms.internal.zzi;
import com.google.android.gms.internal.zzl;
import com.google.android.gms.internal.zzm;
import com.google.android.gms.internal.zzo;
import com.google.android.gms.internal.zzr;
import com.google.android.gms.internal.zzs;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;

public abstract class zzk<T>
implements Comparable<zzk<T>> {
    private final zzs.zza zzC = zzs.zza.zzaj ? new zzs.zza() : null;
    private final int zzD;
    private final String zzE;
    private final int zzF;
    private final zzm.zza zzG;
    private Integer zzH;
    private zzl zzI;
    private boolean zzJ = true;
    private boolean zzK = false;
    private boolean zzL = false;
    private long zzM = 0L;
    private zzo zzN;
    private zzb.zza zzO = null;

    public zzk(int n, String string2, zzm.zza zza2) {
        this.zzD = n;
        this.zzE = string2;
        this.zzG = zza2;
        this.zza(new zzd());
        this.zzF = zzk.zzb(string2);
    }

    public int getMethod() {
        return this.zzD;
    }

    public int zzf() {
        return this.zzF;
    }

    private static int zzb(String string2) {
        String string3;
        Uri uri;
        if (!TextUtils.isEmpty((CharSequence)string2) && (uri = Uri.parse((String)string2)) != null && (string3 = uri.getHost()) != null) {
            return string3.hashCode();
        }
        return 0;
    }

    public zzk<?> zza(zzo zzo2) {
        this.zzN = zzo2;
        return this;
    }

    public void zzc(String string2) {
        if (zzs.zza.zzaj) {
            this.zzC.zza(string2, Thread.currentThread().getId());
        } else if (this.zzM == 0L) {
            this.zzM = SystemClock.elapsedRealtime();
        }
    }

    void zzd(final String string2) {
        if (this.zzI != null) {
            this.zzI.zzf(this);
        }
        if (zzs.zza.zzaj) {
            final long l = Thread.currentThread().getId();
            if (Looper.myLooper() != Looper.getMainLooper()) {
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        zzk.this.zzC.zza(string2, l);
                        zzk.this.zzC.zzd(this.toString());
                    }
                });
                return;
            }
            this.zzC.zza(string2, l);
            this.zzC.zzd(this.toString());
        } else {
            long l = SystemClock.elapsedRealtime() - this.zzM;
            if (l >= 3000L) {
                zzs.zzb("%d ms: %s", l, this.toString());
            }
        }
    }

    public zzk<?> zza(zzl zzl2) {
        this.zzI = zzl2;
        return this;
    }

    public final zzk<?> zza(int n) {
        this.zzH = n;
        return this;
    }

    public String getUrl() {
        return this.zzE;
    }

    public String zzg() {
        return this.getUrl();
    }

    public zzk<?> zza(zzb.zza zza2) {
        this.zzO = zza2;
        return this;
    }

    public zzb.zza zzh() {
        return this.zzO;
    }

    public boolean isCanceled() {
        return false;
    }

    public Map<String, String> getHeaders() throws com.google.android.gms.internal.zza {
        return Collections.emptyMap();
    }

    @Deprecated
    protected Map<String, String> zzi() throws com.google.android.gms.internal.zza {
        return this.zzm();
    }

    @Deprecated
    protected String zzj() {
        return this.zzn();
    }

    @Deprecated
    public String zzk() {
        return this.zzo();
    }

    @Deprecated
    public byte[] zzl() throws com.google.android.gms.internal.zza {
        Map<String, String> map = this.zzi();
        if (map != null && map.size() > 0) {
            return this.zza(map, this.zzj());
        }
        return null;
    }

    protected Map<String, String> zzm() throws com.google.android.gms.internal.zza {
        return null;
    }

    protected String zzn() {
        return "UTF-8";
    }

    public String zzo() {
        String string2 = String.valueOf(this.zzn());
        return string2.length() != 0 ? "application/x-www-form-urlencoded; charset=".concat(string2) : new String("application/x-www-form-urlencoded; charset=");
    }

    public byte[] zzp() throws com.google.android.gms.internal.zza {
        Map<String, String> map = this.zzm();
        if (map != null && map.size() > 0) {
            return this.zza(map, this.zzn());
        }
        return null;
    }

    private byte[] zza(Map<String, String> map, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringBuilder.append(URLEncoder.encode(entry.getKey(), string2));
                stringBuilder.append('=');
                stringBuilder.append(URLEncoder.encode(entry.getValue(), string2));
                stringBuilder.append('&');
            }
            return stringBuilder.toString().getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string3 = String.valueOf(string2);
            throw new RuntimeException(string3.length() != 0 ? "Encoding not supported: ".concat(string3) : new String("Encoding not supported: "), unsupportedEncodingException);
        }
    }

    public final boolean zzq() {
        return this.zzJ;
    }

    public zza zzr() {
        return zza.zzT;
    }

    public final int zzs() {
        return this.zzN.zzc();
    }

    public zzo zzt() {
        return this.zzN;
    }

    public void zzu() {
        this.zzL = true;
    }

    public boolean zzv() {
        return this.zzL;
    }

    protected abstract zzm<T> zza(zzi var1);

    protected zzr zzb(zzr zzr2) {
        return zzr2;
    }

    protected abstract void zza(T var1);

    public void zzc(zzr zzr2) {
        if (this.zzG != null) {
            this.zzG.zze(zzr2);
        }
    }

    public int zzc(zzk<T> zzk2) {
        zza zza2;
        zza zza3 = this.zzr();
        return zza3 == (zza2 = zzk2.zzr()) ? this.zzH - zzk2.zzH : zza2.ordinal() - zza3.ordinal();
    }

    public String toString() {
        String string2 = String.valueOf(Integer.toHexString(this.zzf()));
        String string3 = string2.length() != 0 ? "0x".concat(string2) : new String("0x");
        String string4 = "[ ] ";
        String string5 = String.valueOf(this.getUrl());
        String string6 = String.valueOf((Object)this.zzr());
        String string7 = String.valueOf(this.zzH);
        return new StringBuilder(3 + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string3).length() + String.valueOf(string6).length() + String.valueOf(string7).length()).append(string4).append(string5).append(" ").append(string3).append(" ").append(string6).append(" ").append(string7).toString();
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zzc((zzk)object);
    }

    public static final class zza
    extends Enum<zza> {
        public static final /* enum */ zza zzS = new zza();
        public static final /* enum */ zza zzT = new zza();
        public static final /* enum */ zza zzU = new zza();
        public static final /* enum */ zza zzV = new zza();
        private static final /* synthetic */ zza[] zzW;

        public static zza[] values() {
            return (zza[])zzW.clone();
        }

        static {
            zzW = new zza[]{zzS, zzT, zzU, zzV};
        }
    }
}

