/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.clearcut.LogEventParcelable;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.internal.zzlw;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzmt;
import com.google.android.gms.internal.zzsu;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class zzlv
implements com.google.android.gms.clearcut.zzc {
    private static final Object zzafn = new Object();
    private static final zze zzafo = new zze();
    private static final long zzafp = TimeUnit.MILLISECONDS.convert(2L, TimeUnit.MINUTES);
    private final zzmq zzqW;
    private final zza zzafq;
    private final Object zzafr = new Object();
    private long zzafs = 0L;
    private final long zzaft;
    private ScheduledFuture<?> zzafu = null;
    private GoogleApiClient zzaaj = null;
    private final Runnable zzafv = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = zzlv.this.zzafr;
            synchronized (object) {
                if (zzlv.this.zzafs <= zzlv.this.zzqW.elapsedRealtime() && zzlv.this.zzaaj != null) {
                    Log.i((String)"ClearcutLoggerApiImpl", (String)"disconnect managed GoogleApiClient");
                    zzlv.this.zzaaj.disconnect();
                    zzlv.this.zzaaj = null;
                }
            }
        }
    };

    public zzlv() {
        this(new zzmt(), zzafp, new zzb());
    }

    public zzlv(zzmq zzmq2, long l, zza zza2) {
        this.zzqW = zzmq2;
        this.zzaft = l;
        this.zzafq = zza2;
    }

    @Override
    public boolean zza(GoogleApiClient googleApiClient, long l, TimeUnit timeUnit) {
        try {
            return zzafo.zza(l, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"ClearcutLoggerApiImpl", (String)"flush interrupted");
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public PendingResult<Status> zza(GoogleApiClient googleApiClient, LogEventParcelable logEventParcelable) {
        zzlv.zza(logEventParcelable);
        return googleApiClient.zza(this.zzb(googleApiClient, logEventParcelable));
    }

    private zzd zzb(GoogleApiClient googleApiClient, LogEventParcelable logEventParcelable) {
        zzafo.zzoH();
        zzd zzd2 = new zzd(logEventParcelable, googleApiClient);
        zzd2.zza(new PendingResult.zza(){

            @Override
            public void zzu(Status status) {
                zzafo.zzoI();
            }
        });
        return zzd2;
    }

    private static void zza(LogEventParcelable logEventParcelable) {
        if (logEventParcelable.zzafl != null && logEventParcelable.zzafk.zzbuY.length == 0) {
            logEventParcelable.zzafk.zzbuY = logEventParcelable.zzafl.zzoF();
        }
        if (logEventParcelable.zzafm != null && logEventParcelable.zzafk.zzbvf.length == 0) {
            logEventParcelable.zzafk.zzbvf = logEventParcelable.zzafm.zzoF();
        }
        logEventParcelable.zzafi = zzsu.toByteArray(logEventParcelable.zzafk);
    }

    private static final class zze {
        private int mSize = 0;

        private zze() {
        }

        public synchronized void zzoH() {
            ++this.mSize;
        }

        public synchronized void zzoI() {
            if (this.mSize == 0) {
                throw new RuntimeException("too many decrements");
            }
            --this.mSize;
            if (this.mSize == 0) {
                this.notifyAll();
            }
        }

        public boolean zza(long l, TimeUnit timeUnit) throws InterruptedException {
            long l2 = System.currentTimeMillis();
            long l3 = TimeUnit.MILLISECONDS.convert(l, timeUnit);
            zze zze2 = this;
            synchronized (zze2) {
                while (true) {
                    if (this.mSize == 0) {
                        return true;
                    }
                    if (l3 <= 0L) {
                        return false;
                    }
                    this.wait(l3);
                    l3 -= System.currentTimeMillis() - l2;
                }
            }
        }
    }

    final class zzd
    extends zzc<Status> {
        private final LogEventParcelable zzafx;

        zzd(LogEventParcelable logEventParcelable, GoogleApiClient googleApiClient) {
            super(googleApiClient);
            this.zzafx = logEventParcelable;
        }

        @Override
        protected void zza(zzlw zzlw2) throws RemoteException {
            zzlx.zza zza2 = new zzlx.zza(){

                @Override
                public void zzv(Status status) {
                    zzd.this.zza(status);
                }
            };
            try {
                zzlv.zza(this.zzafx);
            }
            catch (Throwable throwable) {
                Log.e((String)"ClearcutLoggerApiImpl", (String)("MessageNanoProducer " + this.zzafx.zzafl.toString() + " threw: " + throwable.toString()));
                return;
            }
            zzlw2.zza(zza2, this.zzafx);
        }

        protected Status zzb(Status status) {
            return status;
        }

        public boolean equals(Object rhs) {
            if (!(rhs instanceof zzd)) {
                return false;
            }
            zzd zzd2 = (zzd)rhs;
            return this.zzafx.equals(zzd2.zzafx);
        }

        public String toString() {
            return "MethodImpl(" + this.zzafx + ")";
        }

        @Override
        protected /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    public static class zzb
    implements zza {
    }

    public static interface zza {
    }

    static abstract class zzc<R extends Result>
    extends zza.zza<R, zzlw> {
        public zzc(GoogleApiClient googleApiClient) {
            super(com.google.android.gms.clearcut.zzb.zzUI, googleApiClient);
        }
    }
}

