/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzb;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.zze;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zznc;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SafeParcelResponse
extends FastJsonResponse
implements SafeParcelable {
    private final int mVersionCode;
    private final Parcel zzana;
    private final int zzanb;
    private final FieldMappingDictionary zzamT;
    private final String mClassName;
    private int zzanc;
    private int zzand;
    public static final zze CREATOR = new zze();

    private SafeParcelResponse(SafeParcelable safeParcelable, FieldMappingDictionary dictionary, String className) {
        this.mVersionCode = 1;
        this.zzana = Parcel.obtain();
        safeParcelable.writeToParcel(this.zzana, 0);
        this.zzanb = 1;
        this.zzamT = zzx.zzz(dictionary);
        this.mClassName = zzx.zzz(className);
        this.zzanc = 2;
    }

    public static <T extends FastJsonResponse> SafeParcelResponse zza(T t) {
        String string2 = t.getClass().getCanonicalName();
        FieldMappingDictionary fieldMappingDictionary = SafeParcelResponse.zzb(t);
        return new SafeParcelResponse((SafeParcelable)((Object)t), fieldMappingDictionary, string2);
    }

    private static FieldMappingDictionary zzb(FastJsonResponse fastJsonResponse) {
        FieldMappingDictionary fieldMappingDictionary = new FieldMappingDictionary(fastJsonResponse.getClass());
        SafeParcelResponse.zza(fieldMappingDictionary, fastJsonResponse);
        fieldMappingDictionary.zzrz();
        fieldMappingDictionary.zzry();
        return fieldMappingDictionary;
    }

    private static void zza(FieldMappingDictionary fieldMappingDictionary, FastJsonResponse fastJsonResponse) {
        Class<?> clazz = fastJsonResponse.getClass();
        if (!fieldMappingDictionary.zzb(clazz)) {
            Map<String, FastJsonResponse.Field<?, ?>> map = fastJsonResponse.zzrl();
            fieldMappingDictionary.zza(clazz, map);
            for (String string2 : map.keySet()) {
                FastJsonResponse.Field<?, ?> field = map.get(string2);
                Class<FastJsonResponse> clazz2 = field.zzrt();
                if (clazz2 == null) continue;
                try {
                    FastJsonResponse fastJsonResponse2 = clazz2.newInstance();
                    SafeParcelResponse.zza(fieldMappingDictionary, fastJsonResponse2);
                }
                catch (InstantiationException instantiationException) {
                    throw new IllegalStateException("Could not instantiate an object of type " + field.zzrt().getCanonicalName(), instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException("Could not access object of type " + field.zzrt().getCanonicalName(), illegalAccessException);
                }
            }
        }
    }

    SafeParcelResponse(int versionCode, Parcel parcel, FieldMappingDictionary fieldMappingDictionary) {
        this.mVersionCode = versionCode;
        this.zzana = zzx.zzz(parcel);
        this.zzanb = 2;
        this.zzamT = fieldMappingDictionary;
        this.mClassName = this.zzamT == null ? null : this.zzamT.zzrB();
        this.zzanc = 2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zze.zza(this, out, flags);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public Parcel zzrD() {
        switch (this.zzanc) {
            case 0: {
                this.zzand = zzb.zzav(this.zzana);
                zzb.zzI(this.zzana, this.zzand);
                this.zzanc = 2;
                break;
            }
            case 1: {
                zzb.zzI(this.zzana, this.zzand);
                this.zzanc = 2;
                break;
            }
        }
        return this.zzana;
    }

    FieldMappingDictionary zzrE() {
        switch (this.zzanb) {
            case 0: {
                return null;
            }
            case 1: {
                return this.zzamT;
            }
            case 2: {
                return this.zzamT;
            }
        }
        throw new IllegalStateException("Invalid creation type: " + this.zzanb);
    }

    @Override
    public Map<String, FastJsonResponse.Field<?, ?>> zzrl() {
        if (this.zzamT == null) {
            return null;
        }
        return this.zzamT.zzcR(this.mClassName);
    }

    @Override
    protected Object zzcN(String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    @Override
    protected boolean zzcO(String string2) {
        throw new UnsupportedOperationException("Converting to JSON does not require this method.");
    }

    @Override
    public String toString() {
        zzx.zzb(this.zzamT, (Object)"Cannot convert to JSON on client side.");
        Parcel parcel = this.zzrD();
        parcel.setDataPosition(0);
        StringBuilder stringBuilder = new StringBuilder(100);
        this.zza(stringBuilder, this.zzamT.zzcR(this.mClassName), parcel);
        return stringBuilder.toString();
    }

    private void zza(StringBuilder stringBuilder, Map<String, FastJsonResponse.Field<?, ?>> map, Parcel parcel) {
        HashMap<Integer, Map.Entry<String, FastJsonResponse.Field<?, ?>>> hashMap = SafeParcelResponse.zzN(map);
        stringBuilder.append('{');
        int n = zza.zzau(parcel);
        boolean bl = false;
        while (parcel.dataPosition() < n) {
            int n2 = zza.zzat(parcel);
            int n3 = zza.zzca(n2);
            Map.Entry<String, FastJsonResponse.Field<?, ?>> entry = hashMap.get(n3);
            if (entry == null) continue;
            if (bl) {
                stringBuilder.append(",");
            }
            this.zza(stringBuilder, entry.getKey(), entry.getValue(), parcel, n2);
            bl = true;
        }
        if (parcel.dataPosition() != n) {
            throw new zza.zza("Overread allowed size end=" + n, parcel);
        }
        stringBuilder.append('}');
    }

    private static HashMap<Integer, Map.Entry<String, FastJsonResponse.Field<?, ?>>> zzN(Map<String, FastJsonResponse.Field<?, ?>> map) {
        HashMap hashMap = new HashMap();
        for (Map.Entry<String, FastJsonResponse.Field<?, ?>> entry : map.entrySet()) {
            hashMap.put(entry.getValue().zzrs(), entry);
        }
        return hashMap;
    }

    private void zza(StringBuilder stringBuilder, String string2, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        stringBuilder.append("\"").append(string2).append("\":");
        if (field.zzrv()) {
            this.zza(stringBuilder, field, parcel, n);
        } else {
            this.zzb(stringBuilder, field, parcel, n);
        }
    }

    private void zza(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        switch (field.zzrk()) {
            case 0: {
                int n2 = zza.zzg(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, n2));
                break;
            }
            case 1: {
                BigInteger bigInteger = zza.zzk(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bigInteger));
                break;
            }
            case 2: {
                long l = zza.zzi(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, l));
                break;
            }
            case 3: {
                float f = zza.zzl(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, Float.valueOf(f)));
                break;
            }
            case 4: {
                double d = zza.zzn(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, d));
                break;
            }
            case 5: {
                BigDecimal bigDecimal = zza.zzo(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bigDecimal));
                break;
            }
            case 6: {
                boolean bl = zza.zzc(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, bl));
                break;
            }
            case 7: {
                String string2 = zza.zzp(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, string2));
                break;
            }
            case 8: 
            case 9: {
                byte[] byArray = zza.zzs(parcel, n);
                this.zzb(stringBuilder, field, this.zza(field, byArray));
                break;
            }
            case 10: {
                Bundle bundle = zza.zzr(parcel, n);
                HashMap<String, String> hashMap = SafeParcelResponse.zzl(bundle);
                this.zzb(stringBuilder, field, this.zza(field, hashMap));
                break;
            }
            case 11: {
                throw new IllegalArgumentException("Method does not accept concrete type.");
            }
            default: {
                throw new IllegalArgumentException("Unknown field out type = " + field.zzrk());
            }
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Parcel parcel, int n) {
        if (field.zzrq()) {
            stringBuilder.append("[");
            switch (field.zzrk()) {
                case 0: {
                    int[] nArray = zza.zzv(parcel, n);
                    zzmn.zza(stringBuilder, nArray);
                    break;
                }
                case 1: {
                    BigInteger[] bigIntegerArray = zza.zzx(parcel, n);
                    zzmn.zza(stringBuilder, bigIntegerArray);
                    break;
                }
                case 2: {
                    long[] lArray = zza.zzw(parcel, n);
                    zzmn.zza(stringBuilder, lArray);
                    break;
                }
                case 3: {
                    float[] fArray = zza.zzy(parcel, n);
                    zzmn.zza(stringBuilder, fArray);
                    break;
                }
                case 4: {
                    double[] dArray = zza.zzz(parcel, n);
                    zzmn.zza(stringBuilder, dArray);
                    break;
                }
                case 5: {
                    BigDecimal[] bigDecimalArray = zza.zzA(parcel, n);
                    zzmn.zza(stringBuilder, bigDecimalArray);
                    break;
                }
                case 6: {
                    boolean[] blArray = zza.zzu(parcel, n);
                    zzmn.zza(stringBuilder, blArray);
                    break;
                }
                case 7: {
                    String[] stringArray = zza.zzB(parcel, n);
                    zzmn.zza(stringBuilder, stringArray);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    throw new UnsupportedOperationException("List of type BASE64, BASE64_URL_SAFE, or STRING_MAP is not supported");
                }
                case 11: {
                    Parcel[] parcelArray = zza.zzF(parcel, n);
                    int n2 = parcelArray.length;
                    for (int i = 0; i < n2; ++i) {
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        parcelArray[i].setDataPosition(0);
                        this.zza(stringBuilder, field.zzrx(), parcelArray[i]);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown field type out.");
                }
            }
            stringBuilder.append("]");
        } else {
            switch (field.zzrk()) {
                case 0: {
                    int n3 = zza.zzg(parcel, n);
                    stringBuilder.append(n3);
                    break;
                }
                case 1: {
                    BigInteger bigInteger = zza.zzk(parcel, n);
                    stringBuilder.append(bigInteger);
                    break;
                }
                case 2: {
                    long l = zza.zzi(parcel, n);
                    stringBuilder.append(l);
                    break;
                }
                case 3: {
                    float f = zza.zzl(parcel, n);
                    stringBuilder.append(f);
                    break;
                }
                case 4: {
                    double d = zza.zzn(parcel, n);
                    stringBuilder.append(d);
                    break;
                }
                case 5: {
                    BigDecimal bigDecimal = zza.zzo(parcel, n);
                    stringBuilder.append(bigDecimal);
                    break;
                }
                case 6: {
                    boolean bl = zza.zzc(parcel, n);
                    stringBuilder.append(bl);
                    break;
                }
                case 7: {
                    String string2 = zza.zzp(parcel, n);
                    stringBuilder.append("\"").append(zznb.zzcU(string2)).append("\"");
                    break;
                }
                case 8: {
                    byte[] byArray = zza.zzs(parcel, n);
                    stringBuilder.append("\"").append(zzmo.zzj(byArray)).append("\"");
                    break;
                }
                case 9: {
                    byte[] byArray = zza.zzs(parcel, n);
                    stringBuilder.append("\"").append(zzmo.zzk(byArray));
                    stringBuilder.append("\"");
                    break;
                }
                case 10: {
                    Bundle bundle = zza.zzr(parcel, n);
                    Set set = bundle.keySet();
                    int n4 = set.size();
                    stringBuilder.append("{");
                    boolean bl = true;
                    for (String string3 : set) {
                        if (!bl) {
                            stringBuilder.append(",");
                        }
                        bl = false;
                        stringBuilder.append("\"").append(string3).append("\"");
                        stringBuilder.append(":");
                        stringBuilder.append("\"").append(zznb.zzcU(bundle.getString(string3))).append("\"");
                    }
                    stringBuilder.append("}");
                    break;
                }
                case 11: {
                    Parcel parcel2 = zza.zzE(parcel, n);
                    parcel2.setDataPosition(0);
                    this.zza(stringBuilder, field.zzrx(), parcel2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown field type out");
                }
            }
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, Object object) {
        if (field.zzrp()) {
            this.zzb(stringBuilder, field, (ArrayList)object);
        } else {
            this.zza(stringBuilder, field.zzrj(), object);
        }
    }

    private void zzb(StringBuilder stringBuilder, FastJsonResponse.Field<?, ?> field, ArrayList<?> arrayList) {
        stringBuilder.append("[");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            this.zza(stringBuilder, field.zzrj(), arrayList.get(i));
        }
        stringBuilder.append("]");
    }

    private void zza(StringBuilder stringBuilder, int n, Object object) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                stringBuilder.append(object);
                break;
            }
            case 7: {
                stringBuilder.append("\"").append(zznb.zzcU(object.toString())).append("\"");
                break;
            }
            case 8: {
                stringBuilder.append("\"").append(zzmo.zzj((byte[])object)).append("\"");
                break;
            }
            case 9: {
                stringBuilder.append("\"").append(zzmo.zzk((byte[])object));
                stringBuilder.append("\"");
                break;
            }
            case 10: {
                zznc.zza(stringBuilder, (HashMap)object);
                break;
            }
            case 11: {
                throw new IllegalArgumentException("Method does not accept concrete type.");
            }
            default: {
                throw new IllegalArgumentException("Unknown type = " + n);
            }
        }
    }

    public static HashMap<String, String> zzl(Bundle bundle) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : bundle.keySet()) {
            hashMap.put(string2, bundle.getString(string2));
        }
        return hashMap;
    }
}

