/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class zzm
extends zzl
implements Handler.Callback {
    private final HashMap<zza, zzb> zzalZ = new HashMap();
    private final Context zzsa;
    private final Handler mHandler;
    private final com.google.android.gms.common.stats.zzb zzama;
    private final long zzamb;

    zzm(Context context) {
        this.zzsa = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.zzama = com.google.android.gms.common.stats.zzb.zzrP();
        this.zzamb = 5000L;
    }

    @Override
    public boolean zza(String string2, ServiceConnection serviceConnection, String string3) {
        return this.zza(new zza(string2), serviceConnection, string3);
    }

    @Override
    public boolean zza(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzx.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzalZ;
        synchronized (hashMap) {
            zzb zzb2 = this.zzalZ.get(zza2);
            if (zzb2 == null) {
                zzb2 = new zzb(zza2);
                zzb2.zza(serviceConnection, string2);
                zzb2.zzcH(string2);
                this.zzalZ.put(zza2, zzb2);
            } else {
                this.mHandler.removeMessages(0, (Object)zzb2);
                if (zzb2.zza(serviceConnection)) {
                    throw new IllegalStateException("Trying to bind a GmsServiceConnection that was already connected before.  config=" + zza2);
                }
                zzb2.zza(serviceConnection, string2);
                switch (zzb2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzb2.getComponentName(), zzb2.getBinder());
                        break;
                    }
                    case 2: {
                        zzb2.zzcH(string2);
                    }
                }
            }
            return zzb2.isBound();
        }
    }

    @Override
    public void zzb(String string2, ServiceConnection serviceConnection, String string3) {
        this.zzb(new zza(string2), serviceConnection, string3);
    }

    @Override
    public void zzb(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzx.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzalZ;
        synchronized (hashMap) {
            zzb zzb2 = this.zzalZ.get(zza2);
            if (zzb2 == null) {
                throw new IllegalStateException("Nonexistent connection status for service config: " + zza2);
            }
            if (!zzb2.zza(serviceConnection)) {
                throw new IllegalStateException("Trying to unbind a GmsServiceConnection  that was not bound before.  config=" + zza2);
            }
            zzb2.zzb(serviceConnection, string2);
            if (zzb2.zzqT()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zzb2);
                this.mHandler.sendMessageDelayed(message, this.zzamb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                zzb zzb2 = (zzb)msg.obj;
                HashMap<zza, zzb> hashMap = this.zzalZ;
                synchronized (hashMap) {
                    if (zzb2.zzqT()) {
                        if (zzb2.isBound()) {
                            zzb2.zzcI("GmsClientSupervisor");
                        }
                        this.zzalZ.remove(zzb2.zzamg);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static final class zza {
        private final String zzSU;
        private final ComponentName zzamc;

        public zza(String string2) {
            this.zzSU = zzx.zzcM(string2);
            this.zzamc = null;
        }

        public zza(ComponentName componentName) {
            this.zzSU = null;
            this.zzamc = zzx.zzz(componentName);
        }

        public String toString() {
            return this.zzSU == null ? this.zzamc.flattenToString() : this.zzSU;
        }

        public Intent zzqS() {
            Intent intent = this.zzSU != null ? new Intent(this.zzSU).setPackage("com.google.android.gms") : new Intent().setComponent(this.zzamc);
            return intent;
        }

        public int hashCode() {
            return zzw.hashCode(this.zzSU, this.zzamc);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)o;
            return zzw.equal(this.zzSU, zza2.zzSU) && zzw.equal(this.zzamc, zza2.zzamc);
        }
    }

    private final class zzb {
        private final zza zzamd;
        private final Set<ServiceConnection> zzame;
        private int mState;
        private boolean zzamf;
        private IBinder zzakD;
        private final com.google.android.gms.common.internal.zzm$zza zzamg;
        private ComponentName zzamc;

        public zzb(com.google.android.gms.common.internal.zzm$zza zza2) {
            this.zzamg = zza2;
            this.zzamd = new zza();
            this.zzame = new HashSet<ServiceConnection>();
            this.mState = 2;
        }

        @TargetApi(value=14)
        public void zzcH(String string2) {
            this.mState = 3;
            this.zzamf = zzm.this.zzama.zza(zzm.this.zzsa, string2, this.zzamg.zzqS(), this.zzamd, 129);
            if (!this.zzamf) {
                this.mState = 2;
                try {
                    zzm.this.zzama.zza(zzm.this.zzsa, this.zzamd);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public void zzcI(String string2) {
            zzm.this.zzama.zza(zzm.this.zzsa, this.zzamd);
            this.zzamf = false;
            this.mState = 2;
        }

        public void zza(ServiceConnection serviceConnection, String string2) {
            zzm.this.zzama.zza(zzm.this.zzsa, serviceConnection, string2, this.zzamg.zzqS());
            this.zzame.add(serviceConnection);
        }

        public void zzb(ServiceConnection serviceConnection, String string2) {
            zzm.this.zzama.zzb(zzm.this.zzsa, serviceConnection);
            this.zzame.remove(serviceConnection);
        }

        public boolean isBound() {
            return this.zzamf;
        }

        public int getState() {
            return this.mState;
        }

        public boolean zza(ServiceConnection serviceConnection) {
            return this.zzame.contains(serviceConnection);
        }

        public boolean zzqT() {
            return this.zzame.isEmpty();
        }

        public IBinder getBinder() {
            return this.zzakD;
        }

        public ComponentName getComponentName() {
            return this.zzamc;
        }

        public class zza
        implements ServiceConnection {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName component, IBinder binder) {
                HashMap hashMap = zzm.this.zzalZ;
                synchronized (hashMap) {
                    zzb.this.zzakD = binder;
                    zzb.this.zzamc = component;
                    for (ServiceConnection serviceConnection : zzb.this.zzame) {
                        serviceConnection.onServiceConnected(component, binder);
                    }
                    zzb.this.mState = 1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName component) {
                HashMap hashMap = zzm.this.zzalZ;
                synchronized (hashMap) {
                    zzb.this.zzakD = null;
                    zzb.this.zzamc = component;
                    for (ServiceConnection serviceConnection : zzb.this.zzame) {
                        serviceConnection.onServiceDisconnected(component);
                    }
                    zzb.this.mState = 2;
                }
            }
        }
    }
}

