/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.api.internal.zzp;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzro;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

public class zzd
implements zzp {
    private final Context mContext;
    private final zzj zzagW;
    private final Looper zzagr;
    private final zzl zzagX;
    private final zzl zzagY;
    private final Map<Api.zzc<?>, zzl> zzagZ = new ArrayMap();
    private final Set<zzu> zzaha = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zzb zzahb;
    private Bundle zzahc;
    private ConnectionResult zzahd = null;
    private ConnectionResult zzahe = null;
    private boolean zzahf = false;
    private final Lock zzXG;
    private int zzahg = 0;

    public zzd(Context context, zzj zzj2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zzb> map, zzf zzf2, Map<Api<?>, Integer> map2, Api.zza<? extends zzrn, zzro> zza2, ArrayList<com.google.android.gms.common.api.internal.zzc> arrayList) {
        Api.zzc<?> zzc3;
        Object object;
        this.mContext = context;
        this.zzagW = zzj2;
        this.zzXG = lock;
        this.zzagr = looper;
        Api.zzb zzb2 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Api.zzc<?> arrayMap4 : map.keySet()) {
            object = map.get(arrayMap4);
            if (object.zznb()) {
                zzb2 = object;
            }
            if (object.zzmE()) {
                arrayMap2.put(arrayMap4, object);
                continue;
            }
            arrayMap3.put(arrayMap4, object);
        }
        this.zzahb = zzb2;
        if (arrayMap2.isEmpty()) {
            throw new IllegalStateException("CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        }
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            zzc3 = api.zzoR();
            if (arrayMap2.containsKey(zzc3)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc3)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the apiTypeMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<com.google.android.gms.common.api.internal.zzc>();
        ArrayList<com.google.android.gms.common.api.internal.zzc> arrayList2 = new ArrayList<com.google.android.gms.common.api.internal.zzc>();
        for (com.google.android.gms.common.api.internal.zzc zzc4 : arrayList) {
            if (arrayMap5.containsKey(zzc4.zzagT)) {
                ((ArrayList)object).add(zzc4);
                continue;
            }
            if (arrayMap.containsKey(zzc4.zzagT)) {
                arrayList2.add(zzc4);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the apiTypeMap");
        }
        zzc3 = new zzp.zza(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zzi(@Nullable Bundle bundle) {
                zzd.this.zzXG.lock();
                try {
                    zzd.this.zzh(bundle);
                    zzd.this.zzahd = ConnectionResult.zzafB;
                    zzd.this.zzpm();
                }
                finally {
                    zzd.this.zzXG.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zzd(@NonNull ConnectionResult connectionResult) {
                zzd.this.zzXG.lock();
                try {
                    zzd.this.zzahd = connectionResult;
                    zzd.this.zzpm();
                }
                finally {
                    zzd.this.zzXG.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zzc(int n, boolean bl) {
                zzd.this.zzXG.lock();
                try {
                    if (zzd.this.zzahf || zzd.this.zzahe == null || !zzd.this.zzahe.isSuccess()) {
                        zzd.this.zzahf = false;
                        zzd.this.zzb(n, bl);
                        return;
                    }
                    zzd.this.zzahf = true;
                    zzd.this.zzagY.onConnectionSuspended(n);
                }
                finally {
                    zzd.this.zzXG.unlock();
                }
            }
        };
        this.zzagX = new zzl(context, this.zzagW, lock, looper, zzc2, (Map<Api.zzc<?>, Api.zzb>)arrayMap3, null, (Map<Api<?>, Integer>)arrayMap, null, arrayList2, (zzp.zza)((Object)zzc3));
        zzp.zza zza3 = new zzp.zza(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zzi(@Nullable Bundle bundle) {
                zzd.this.zzXG.lock();
                try {
                    zzd.this.zzahe = ConnectionResult.zzafB;
                    zzd.this.zzpm();
                }
                finally {
                    zzd.this.zzXG.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zzd(@NonNull ConnectionResult connectionResult) {
                zzd.this.zzXG.lock();
                try {
                    zzd.this.zzahe = connectionResult;
                    zzd.this.zzpm();
                }
                finally {
                    zzd.this.zzXG.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zzc(int n, boolean bl) {
                zzd.this.zzXG.lock();
                try {
                    if (zzd.this.zzahf) {
                        zzd.this.zzahf = false;
                        zzd.this.zzb(n, bl);
                        return;
                    }
                    zzd.this.zzahf = true;
                    zzd.this.zzagX.onConnectionSuspended(n);
                }
                finally {
                    zzd.this.zzXG.unlock();
                }
            }
        };
        this.zzagY = new zzl(context, this.zzagW, lock, looper, zzc2, (Map<Api.zzc<?>, Api.zzb>)arrayMap2, zzf2, (Map<Api<?>, Integer>)arrayMap5, zza2, (ArrayList<com.google.android.gms.common.api.internal.zzc>)object, zza3);
        for (Api.zzc zzc5 : arrayMap3.keySet()) {
            this.zzagZ.put(zzc5, this.zzagX);
        }
        for (Api.zzc zzc5 : arrayMap2.keySet()) {
            this.zzagZ.put(zzc5, this.zzagY);
        }
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zza.zza<R, A>> T zza(@NonNull T t) {
        if (this.zzc(t)) {
            if (this.zzpp()) {
                t.zzw(new Status(4, null, this.zzpq()));
                return t;
            }
            return this.zzagY.zza(t);
        }
        return this.zzagX.zza(t);
    }

    @Override
    public <A extends Api.zzb, T extends zza.zza<? extends Result, A>> T zzb(@NonNull T t) {
        if (this.zzc(t)) {
            if (this.zzpp()) {
                t.zzw(new Status(4, null, this.zzpq()));
                return t;
            }
            return this.zzagY.zzb(t);
        }
        return this.zzagX.zzb(t);
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzagZ.get(api.zzoR()).equals(this.zzagY)) {
            if (this.zzpp()) {
                return new ConnectionResult(4, this.zzpq());
            }
            return this.zzagY.getConnectionResult(api);
        }
        return this.zzagX.getConnectionResult(api);
    }

    @Override
    public void connect() {
        this.zzahg = 2;
        this.zzahf = false;
        this.zzpl();
    }

    @Override
    public ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConnectionResult blockingConnect(long timeout, @NonNull TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean disconnect() {
        this.zzahe = null;
        this.zzahd = null;
        this.zzahg = 0;
        boolean bl = this.zzagX.disconnect();
        boolean bl2 = this.zzagY.disconnect();
        this.zzpo();
        return bl && bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        this.zzXG.lock();
        try {
            boolean bl = this.zzagX.isConnected() && (this.zzpk() || this.zzpp() || this.zzahg == 1);
            return bl;
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnecting() {
        this.zzXG.lock();
        try {
            boolean bl = this.zzahg == 2;
            return bl;
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zza(zzu zzu2) {
        this.zzXG.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzpk()) {
                this.zzaha.add(zzu2);
                if (this.zzahg == 0) {
                    this.zzahg = 1;
                }
                this.zzahe = null;
                this.zzagY.connect();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.zzXG.unlock();
        }
        return false;
    }

    @Override
    public void zzpj() {
        this.zzagX.zzpj();
        this.zzagY.zzpj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzoW() {
        this.zzXG.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzagY.disconnect();
            this.zzahe = new ConnectionResult(4);
            if (bl) {
                Handler handler = new Handler(this.zzagr);
                handler.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        zzd.this.zzXG.lock();
                        try {
                            zzd.this.zzpm();
                        }
                        finally {
                            zzd.this.zzXG.unlock();
                        }
                    }
                });
            } else {
                this.zzpo();
            }
        }
        finally {
            this.zzXG.unlock();
        }
    }

    public boolean zzpk() {
        return this.zzagY.isConnected();
    }

    private void zzpl() {
        this.zzahe = null;
        this.zzahd = null;
        this.zzagX.connect();
        this.zzagY.connect();
    }

    private void zzpm() {
        if (zzd.zzc(this.zzahd)) {
            if (zzd.zzc(this.zzahe) || this.zzpp()) {
                this.zzpn();
            } else if (this.zzahe != null) {
                if (this.zzahg == 1) {
                    this.zzpo();
                } else {
                    this.zzb(this.zzahe);
                    this.zzagX.disconnect();
                }
            }
        } else if (this.zzahd != null && zzd.zzc(this.zzahe)) {
            this.zzagY.disconnect();
            this.zzb(this.zzahd);
        } else if (this.zzahd != null && this.zzahe != null) {
            ConnectionResult connectionResult = this.zzahd;
            if (this.zzagY.zzair < this.zzagX.zzair) {
                connectionResult = this.zzahe;
            }
            this.zzb(connectionResult);
        }
    }

    private void zzpn() {
        switch (this.zzahg) {
            case 2: {
                this.zzagW.zzi(this.zzahc);
            }
            case 1: {
                this.zzpo();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzahg = 0;
    }

    private void zzb(ConnectionResult connectionResult) {
        switch (this.zzahg) {
            case 2: {
                this.zzagW.zzd(connectionResult);
            }
            case 1: {
                this.zzpo();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzahg = 0;
    }

    private void zzpo() {
        for (zzu zzu2 : this.zzaha) {
            zzu2.zzna();
        }
        this.zzaha.clear();
    }

    private void zzb(int n, boolean bl) {
        this.zzagW.zzc(n, bl);
        this.zzahe = null;
        this.zzahd = null;
    }

    private boolean zzpp() {
        return this.zzahe != null && this.zzahe.getErrorCode() == 4;
    }

    private boolean zzc(zza.zza<? extends Result, ? extends Api.zzb> zza2) {
        Api.zzc<? extends Api.zzb> zzc2 = zza2.zzoR();
        zzx.zzb(this.zzagZ.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzagZ.get(zzc2).equals(this.zzagY);
    }

    @Nullable
    private PendingIntent zzpq() {
        if (this.zzahb == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.zzagW.getSessionId(), (Intent)this.zzahb.zznc(), (int)0x8000000);
    }

    private void zzh(Bundle bundle) {
        if (this.zzahc == null) {
            this.zzahc = bundle;
        } else if (bundle != null) {
            this.zzahc.putAll(bundle);
        }
    }

    private static boolean zzc(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.append(prefix).append("authClient").println(":");
        this.zzagY.dump(prefix + "  ", fd, writer, args);
        writer.append(prefix).append("anonClient").println(":");
        this.zzagX.dump(prefix + "  ", fd, writer, args);
    }
}

