/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.content.IntentSender;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;

public abstract class ResolvingResultCallbacks<R extends Result>
extends ResultCallbacks<R> {
    private final Activity mActivity;
    private final int zzagz;

    protected ResolvingResultCallbacks(@NonNull Activity activity, int requestCode) {
        this.mActivity = zzx.zzb(activity, (Object)"Activity must not be null");
        this.zzagz = requestCode;
    }

    @Override
    public final void onFailure(@NonNull Status result) {
        if (result.hasResolution()) {
            try {
                result.startResolutionForResult(this.mActivity, this.zzagz);
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                Log.e((String)"ResolvingResultCallback", (String)"Failed to start resolution", (Throwable)sendIntentException);
                this.onUnresolvableFailure(new Status(8));
            }
        } else {
            this.onUnresolvableFailure(result);
        }
    }

    @Override
    public abstract void onSuccess(@NonNull R var1);

    public abstract void onUnresolvableFailure(@NonNull Status var1);
}

