/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzr;
import com.google.android.gms.common.api.internal.zzv;
import com.google.android.gms.common.internal.zzx;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzv zzv2 = new zzv(Looper.getMainLooper());
        zzv2.zza(result);
        return zzv2;
    }

    public static PendingResult<Status> zza(Status status, GoogleApiClient googleApiClient) {
        zzx.zzb(status, (Object)"Result must not be null");
        zzv zzv2 = new zzv(googleApiClient);
        zzv2.zza(status);
        return zzv2;
    }

    public static <R extends Result> PendingResult<R> zza(R r, GoogleApiClient googleApiClient) {
        zzx.zzb(r, (Object)"Result must not be null");
        zzx.zzb(!r.getStatus().isSuccess(), (Object)"Status code must not be SUCCESS");
        zzb<R> zzb2 = new zzb<R>(googleApiClient, r);
        zzb2.zza(r);
        return zzb2;
    }

    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(R result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(null);
        zzc2.zza(result);
        return new zzr(zzc2);
    }

    public static <R extends Result> OptionalPendingResult<R> zzb(R r, GoogleApiClient googleApiClient) {
        zzx.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(googleApiClient);
        zzc2.zza(r);
        return new zzr(zzc2);
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzv zzv2 = new zzv(Looper.getMainLooper());
        zzv2.cancel();
        return zzv2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzx.zzb(result.getStatus().getStatusCode() == 16, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(result);
        zza2.cancel();
        return zza2;
    }

    private PendingResults() {
    }

    private static final class zza<R extends Result>
    extends com.google.android.gms.common.api.internal.zzb<R> {
        private final R zzagx;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.zzagx = r;
        }

        @Override
        protected R zzc(Status status) {
            if (status.getStatusCode() != this.zzagx.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.zzagx;
        }
    }

    private static final class zzb<R extends Result>
    extends com.google.android.gms.common.api.internal.zzb<R> {
        private final R zzagy;

        public zzb(GoogleApiClient googleApiClient, R r) {
            super(googleApiClient);
            this.zzagy = r;
        }

        @Override
        protected R zzc(Status status) {
            return this.zzagy;
        }
    }

    private static final class zzc<R extends Result>
    extends com.google.android.gms.common.api.internal.zzb<R> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        @Override
        protected R zzc(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

