/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.internal.zze;
import com.google.android.gms.auth.api.signin.zzc;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
implements Api.ApiOptions.Optional,
SafeParcelable {
    public static final Scope zzWW = new Scope("profile");
    public static final Scope zzWX = new Scope("email");
    public static final Scope zzWY = new Scope("openid");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zzc();
    final int versionCode;
    private final ArrayList<Scope> zzWZ;
    private Account zzTI;
    private boolean zzXa;
    private final boolean zzXb;
    private final boolean zzXc;
    private String zzXd;
    private String zzXe;
    private static Comparator<Scope> zzWV = new Comparator<Scope>(){

        public int zza(Scope scope, Scope scope2) {
            return scope.zzpb().compareTo(scope2.zzpb());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Scope)object, (Scope)object2);
        }
    };

    @Nullable
    public static GoogleSignInOptions zzbJ(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(hashSet, account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null));
    }

    GoogleSignInOptions(int versionCode, ArrayList<Scope> scopes, Account account, boolean idTokenRequested, boolean serverAuthCodeRequested, boolean forceCodeForRefreshToken, String serverClientId, String hostedDomain) {
        this.versionCode = versionCode;
        this.zzWZ = scopes;
        this.zzTI = account;
        this.zzXa = idTokenRequested;
        this.zzXb = serverAuthCodeRequested;
        this.zzXc = forceCodeForRefreshToken;
        this.zzXd = serverClientId;
        this.zzXe = hostedDomain;
    }

    private GoogleSignInOptions(Set<Scope> scopes, Account account, boolean idTokenRequested, boolean serverAuthCodeRequested, boolean forceCodeForRefreshToken, String serverClientId, String hostedDomain) {
        this(2, new ArrayList<Scope>(scopes), account, idTokenRequested, serverAuthCodeRequested, forceCodeForRefreshToken, serverClientId, hostedDomain);
    }

    public ArrayList<Scope> zzmN() {
        return new ArrayList<Scope>(this.zzWZ);
    }

    public Scope[] getScopeArray() {
        return this.zzWZ.toArray(new Scope[this.zzWZ.size()]);
    }

    public Account getAccount() {
        return this.zzTI;
    }

    public boolean zzmO() {
        return this.zzXa;
    }

    public boolean zzmP() {
        return this.zzXb;
    }

    public boolean zzmQ() {
        return this.zzXc;
    }

    public String zzmR() {
        return this.zzXd;
    }

    public String zzmS() {
        return this.zzXe;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzc.zza(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)obj;
            if (this.zzWZ.size() != googleSignInOptions.zzmN().size() || !this.zzWZ.containsAll(googleSignInOptions.zzmN())) {
                return false;
            }
            return (this.zzTI == null ? googleSignInOptions.getAccount() == null : this.zzTI.equals((Object)googleSignInOptions.getAccount())) && (TextUtils.isEmpty((CharSequence)this.zzXd) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzmR()) : this.zzXd.equals(googleSignInOptions.zzmR())) && this.zzXc == googleSignInOptions.zzmQ() && this.zzXa == googleSignInOptions.zzmO() && this.zzXb == googleSignInOptions.zzmP();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Scope scope : this.zzWZ) {
            arrayList.add(scope.zzpb());
        }
        Collections.sort(arrayList);
        return new zze().zzp(arrayList).zzp(this.zzTI).zzp(this.zzXd).zzP(this.zzXc).zzP(this.zzXa).zzP(this.zzXb).zzne();
    }

    public String zzmI() {
        return this.zzmJ().toString();
    }

    private JSONObject zzmJ() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzWZ, zzWV);
            for (Scope scope : this.zzWZ) {
                jSONArray.put((Object)scope.zzpb());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzTI != null) {
                jSONObject.put("accountName", (Object)this.zzTI.name);
            }
            jSONObject.put("idTokenRequested", this.zzXa);
            jSONObject.put("forceCodeForRefreshToken", this.zzXc);
            jSONObject.put("serverAuthRequested", this.zzXb);
            if (!TextUtils.isEmpty((CharSequence)this.zzXd)) {
                jSONObject.put("serverClientId", (Object)this.zzXd);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzXe)) {
                jSONObject.put("hostedDomain", (Object)this.zzXe);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public static final class Builder {
        private Set<Scope> zzXf = new HashSet<Scope>();
        private boolean zzXb;
        private boolean zzXc;
        private boolean zzXa;
        private String zzXd;
        private Account zzTI;
        private String zzXe;

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzx.zzz(googleSignInOptions);
            this.zzXf = new HashSet<Scope>(googleSignInOptions.zzWZ);
            this.zzXb = googleSignInOptions.zzXb;
            this.zzXc = googleSignInOptions.zzXc;
            this.zzXa = googleSignInOptions.zzXa;
            this.zzXd = googleSignInOptions.zzXd;
            this.zzTI = googleSignInOptions.zzTI;
            this.zzXe = googleSignInOptions.zzXe;
        }

        public Builder requestId() {
            this.zzXf.add(zzWY);
            return this;
        }

        public Builder requestEmail() {
            this.zzXf.add(zzWX);
            return this;
        }

        public Builder requestProfile() {
            this.zzXf.add(zzWW);
            return this;
        }

        public Builder requestScopes(Scope scope, Scope ... scopes) {
            this.zzXf.add(scope);
            this.zzXf.addAll(Arrays.asList(scopes));
            return this;
        }

        public Builder requestIdToken(String serverClientId) {
            this.zzXa = true;
            this.zzXd = this.zzbK(serverClientId);
            return this;
        }

        public Builder requestServerAuthCode(String serverClientId) {
            return this.requestServerAuthCode(serverClientId, false);
        }

        public Builder requestServerAuthCode(String serverClientId, boolean forceCodeForRefreshToken) {
            this.zzXb = true;
            this.zzXd = this.zzbK(serverClientId);
            this.zzXc = forceCodeForRefreshToken;
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.zzTI = new Account(zzx.zzcM(accountName), "com.google");
            return this;
        }

        public Builder setHostedDomain(String hostedDomain) {
            this.zzXe = zzx.zzcM(hostedDomain);
            return this;
        }

        public GoogleSignInOptions build() {
            if (this.zzXa && (this.zzTI == null || !this.zzXf.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(this.zzXf, this.zzTI, this.zzXa, this.zzXb, this.zzXc, this.zzXd, this.zzXe);
        }

        private String zzbK(String string2) {
            zzx.zzcM(string2);
            zzx.zzb(this.zzXd == null || this.zzXd.equals(string2), (Object)"two different server client ids provided");
            return string2;
        }
    }
}

