/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.AuthAccountRequest;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.ResolveAccountRequest;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzsd;
import com.google.android.gms.signin.internal.AuthAccountResult;
import com.google.android.gms.signin.internal.CheckServerAuthResult;
import com.google.android.gms.signin.internal.zzd;
import com.google.android.gms.signin.internal.zze;
import com.google.android.gms.signin.internal.zzf;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class zzi
extends zzj<zzf>
implements zzsc {
    private final boolean zzbbX;
    private final com.google.android.gms.common.internal.zzf zzafT;
    private final Bundle zzbbG;
    private Integer zzajt;

    public zzi(Context context, Looper looper, boolean bl, com.google.android.gms.common.internal.zzf zzf2, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 44, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.zzbbX = bl;
        this.zzafT = zzf2;
        this.zzbbG = bundle;
        this.zzajt = zzf2.zzqh();
    }

    public zzi(Context context, Looper looper, boolean bl, com.google.android.gms.common.internal.zzf zzf2, zzsd zzsd2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, ExecutorService executorService) {
        this(context, looper, bl, zzf2, zzi.zza(zzsd2, zzf2.zzqh(), executorService), connectionCallbacks, onConnectionFailedListener);
    }

    @Override
    public boolean zzmn() {
        return this.zzbbX;
    }

    @Override
    public void zza(zzt zzt2) {
        zzx.zzb(zzt2, (Object)"Expecting a valid IResolveAccountCallbacks");
        try {
            Account account = this.zzafT.zzpY();
            GoogleSignInAccount googleSignInAccount = null;
            if ("<<default account>>".equals(account.name)) {
                googleSignInAccount = zzn.zzae(this.getContext()).zzmW();
            }
            ResolveAccountRequest resolveAccountRequest = new ResolveAccountRequest(account, this.zzajt, googleSignInAccount);
            ((zzf)this.zzqs()).zza(resolveAccountRequest, zzt2);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when resolveAccount is called");
            try {
                zzt2.zzb(new ResolveAccountResponse(8));
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"IResolveAccountCallbacks#onAccountResolutionComplete should be executed from the same process, unexpected RemoteException.", (Throwable)remoteException);
            }
        }
    }

    @Override
    public void zza(zzp zzp2, boolean bl) {
        try {
            ((zzf)this.zzqs()).zza(zzp2, this.zzajt, bl);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
        }
    }

    @Override
    public void zzDL() {
        try {
            ((zzf)this.zzqs()).zzjL(this.zzajt);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
        }
    }

    @Override
    public void zza(zzp zzp2, Set<Scope> set, zze zze2) {
        zzx.zzb(zze2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            ((zzf)this.zzqs()).zza(new AuthAccountRequest(zzp2, set), zze2);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when authAccount is called");
            try {
                zze2.zza(new ConnectionResult(8, null), new AuthAccountResult(8, null));
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onAuthAccount should be executed from the same process, unexpected RemoteException.", (Throwable)remoteException);
            }
        }
    }

    @Override
    protected String zzgh() {
        return "com.google.android.gms.signin.service.START";
    }

    @Override
    protected String zzgi() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    protected zzf zzdX(IBinder iBinder) {
        return zzf.zza.zzdW(iBinder);
    }

    @Override
    protected Bundle zzlU() {
        String string = this.zzafT.zzqd();
        if (!this.getContext().getPackageName().equals(string)) {
            this.zzbbG.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zzafT.zzqd());
        }
        return this.zzbbG;
    }

    @Override
    public void connect() {
        this.zza(new zzj.zzf(this));
    }

    public static Bundle zza(zzsd zzsd2, Integer n, ExecutorService executorService) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", zzsd2.zzDM());
        bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", zzsd2.zzmy());
        bundle.putString("com.google.android.gms.signin.internal.serverClientId", zzsd2.zzmB());
        if (zzsd2.zzDN() != null) {
            IBinder iBinder = new zza(zzsd2, executorService).asBinder();
            bundle.putParcelable("com.google.android.gms.signin.internal.signInCallbacks", (Parcelable)new BinderWrapper(iBinder));
        }
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        bundle.putBoolean("com.google.android.gms.signin.internal.usePromptModeForAuthCode", zzsd2.zzDO());
        bundle.putBoolean("com.google.android.gms.signin.internal.forceCodeForRefreshToken", zzsd2.zzmA());
        bundle.putBoolean("com.google.android.gms.signin.internal.waitForAccessTokenRefresh", zzsd2.zzDP());
        return bundle;
    }

    @Override
    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzdX(iBinder);
    }

    private static class zza
    extends zzd.zza {
        private final zzsd zzaeP;
        private final ExecutorService zzbbY;

        public zza(zzsd zzsd2, ExecutorService executorService) {
            this.zzaeP = zzsd2;
            this.zzbbY = executorService;
        }

        @Override
        public void zza(final String string, final List<Scope> list, final zzf zzf2) throws RemoteException {
            this.zzbbY.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        GoogleApiClient.ServerAuthCodeCallbacks serverAuthCodeCallbacks = zza.this.zzDN();
                        Set<Scope> set = Collections.unmodifiableSet(new HashSet(list));
                        GoogleApiClient.ServerAuthCodeCallbacks.CheckResult checkResult = serverAuthCodeCallbacks.onCheckServerAuthorization(string, set);
                        CheckServerAuthResult checkServerAuthResult = new CheckServerAuthResult(checkResult.zzoJ(), checkResult.zzoK());
                        zzf2.zza(checkServerAuthResult);
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"SignInClientImpl", (String)"RemoteException thrown when processing checkServerAuthorization callback", (Throwable)remoteException);
                    }
                }
            });
        }

        @Override
        public void zza(final String string, final String string2, final zzf zzf2) throws RemoteException {
            this.zzbbY.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean bl = zza.this.zzDN().onUploadServerAuthCode(string, string2);
                        zzf2.zzat(bl);
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"SignInClientImpl", (String)"RemoteException thrown when processing uploadServerAuthCode callback", (Throwable)remoteException);
                    }
                }
            });
        }

        private GoogleApiClient.ServerAuthCodeCallbacks zzDN() throws RemoteException {
            return this.zzaeP.zzDN();
        }
    }
}

