/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.WorkSource;
import android.util.Log;
import com.google.android.gms.internal.zznx;
import com.google.android.gms.internal.zzob;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class zzoc {
    private static final Method zzamr = zzoc.zzrZ();
    private static final Method zzams = zzoc.zzsa();
    private static final Method zzamt = zzoc.zzsb();
    private static final Method zzamu = zzoc.zzsc();
    private static final Method zzamv = zzoc.zzsd();

    public static WorkSource zzh(int n, String string2) {
        WorkSource workSource = new WorkSource();
        zzoc.zza(workSource, n, string2);
        return workSource;
    }

    public static WorkSource zzk(Context context, String string2) {
        if (context == null || context.getPackageManager() == null) {
            return null;
        }
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(string2, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)"WorkSourceUtil", (String)("Could not find package: " + string2));
            return null;
        }
        if (applicationInfo == null) {
            Log.e((String)"WorkSourceUtil", (String)("Could not get applicationInfo from package: " + string2));
            return null;
        }
        return zzoc.zzh(applicationInfo.uid, string2);
    }

    public static void zza(WorkSource workSource, int n, String string2) {
        if (zzams != null) {
            if (string2 == null) {
                string2 = "";
            }
            try {
                zzams.invoke((Object)workSource, n, string2);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
            return;
        }
        if (zzamr != null) {
            try {
                zzamr.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
    }

    public static int zza(WorkSource workSource) {
        if (zzamt != null) {
            try {
                return (Integer)zzamt.invoke((Object)workSource, new Object[0]);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return 0;
    }

    public static String zza(WorkSource workSource, int n) {
        if (zzamv != null) {
            try {
                return (String)zzamv.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return null;
    }

    public static List<String> zzb(WorkSource workSource) {
        int n;
        int n2 = n = workSource == null ? 0 : zzoc.zza(workSource);
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            string2 = zzoc.zza(workSource, i);
            if (zzob.zzcP(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean zzaz(Context context) {
        if (context == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            return false;
        }
        int n = packageManager.checkPermission("android.permission.UPDATE_DEVICE_STATS", context.getPackageName());
        return n == 0;
    }

    private static Method zzrZ() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("add", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzsa() {
        Method method = null;
        if (zznx.zzrT()) {
            try {
                method = WorkSource.class.getMethod("add", Integer.TYPE, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }

    private static Method zzsb() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("size", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzsc() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("get", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzsd() {
        Method method = null;
        if (zznx.zzrT()) {
            try {
                method = WorkSource.class.getMethod("getName", Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }
}

