/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzlz;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmf;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmh;
import com.google.android.gms.internal.zzmm;
import com.google.android.gms.internal.zzmp;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzsd;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class zzmi
implements zzmm {
    private final Lock zzafz;
    private final Condition zzagH;
    private final Context mContext;
    private final GoogleApiAvailability zzaeL;
    private final zzb zzagI;
    final Map<Api.zzc<?>, Api.zzb> zzagp;
    final Map<Api.zzc<?>, ConnectionResult> zzagJ = new HashMap();
    final zzf zzafT;
    final Map<Api<?>, Integer> zzafU;
    final Api.zza<? extends zzsc, zzsd> zzaeM;
    private volatile zzmh zzagK;
    private ConnectionResult zzagL = null;
    int zzagM;
    final zzmg zzafp;
    final zzmm.zza zzagN;

    public zzmi(Context context, zzmg zzmg2, Lock lock, Looper looper, GoogleApiAvailability googleApiAvailability, Map<Api.zzc<?>, Api.zzb> map, zzf zzf2, Map<Api<?>, Integer> map2, Api.zza<? extends zzsc, zzsd> zza2, ArrayList<zzlz> arrayList, zzmm.zza zza3) {
        this.mContext = context;
        this.zzafz = lock;
        this.zzaeL = googleApiAvailability;
        this.zzagp = map;
        this.zzafT = zzf2;
        this.zzafU = map2;
        this.zzaeM = zza2;
        this.zzafp = zzmg2;
        this.zzagN = zza3;
        for (zzlz zzlz2 : arrayList) {
            zzlz2.zza(this);
        }
        this.zzagI = new zzb(looper);
        this.zzagH = lock.newCondition();
        this.zzagK = new zzmf(this);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzlx.zza<R, A>> T zza(T t) {
        return this.zzagK.zza(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzlx.zza<? extends Result, A>> T zzb(T t) {
        return this.zzagK.zzb(t);
    }

    @Override
    public void connect() {
        this.zzagK.connect();
    }

    @Override
    public ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzagH.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzadR;
        }
        if (this.zzagL != null) {
            return this.zzagL;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        this.connect();
        long l = unit.toNanos(timeout);
        while (this.isConnecting()) {
            try {
                if (l <= 0L) {
                    return new ConnectionResult(14, null);
                }
                l = this.zzagH.awaitNanos(l);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzadR;
        }
        if (this.zzagL != null) {
            return this.zzagL;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public void disconnect() {
        this.zzagJ.clear();
        this.zzagK.disconnect();
    }

    @Override
    public ConnectionResult getConnectionResult(Api<?> api) {
        Api.zzc<?> zzc2 = api.zzoA();
        if (this.zzagp.containsKey(zzc2)) {
            if (this.zzagp.get(zzc2).isConnected()) {
                return ConnectionResult.zzadR;
            }
            if (this.zzagJ.containsKey(zzc2)) {
                return this.zzagJ.get(zzc2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzpw() {
        this.zzafz.lock();
        try {
            this.zzagK = new zzme(this, this.zzafT, this.zzafU, this.zzaeL, this.zzaeM, this.zzafz, this.mContext);
            this.zzagK.begin();
            this.zzagH.signalAll();
        }
        finally {
            this.zzafz.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzpx() {
        this.zzafz.lock();
        try {
            this.zzafp.zzps();
            this.zzagK = new zzmd(this);
            this.zzagK.begin();
            this.zzagH.signalAll();
        }
        finally {
            this.zzafz.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzj(ConnectionResult connectionResult) {
        this.zzafz.lock();
        try {
            this.zzagL = connectionResult;
            this.zzagK = new zzmf(this);
            this.zzagK.begin();
            this.zzagH.signalAll();
        }
        finally {
            this.zzafz.unlock();
        }
    }

    void zzpy() {
        for (Api.zzb zzb2 : this.zzagp.values()) {
            zzb2.disconnect();
        }
    }

    @Override
    public boolean isConnected() {
        return this.zzagK instanceof zzmd;
    }

    @Override
    public boolean isConnecting() {
        return this.zzagK instanceof zzme;
    }

    @Override
    public boolean zza(zzmp zzmp2) {
        return false;
    }

    @Override
    public void zzoF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(ConnectionResult connectionResult, Api<?> api, int n) {
        this.zzafz.lock();
        try {
            this.zzagK.zza(connectionResult, api, n);
        }
        finally {
            this.zzafz.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected(Bundle connectionHint) {
        this.zzafz.lock();
        try {
            this.zzagK.onConnected(connectionHint);
        }
        finally {
            this.zzafz.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionSuspended(int cause) {
        this.zzafz.lock();
        try {
            this.zzagK.onConnectionSuspended(cause);
        }
        finally {
            this.zzafz.unlock();
        }
    }

    void zza(zza zza2) {
        Message message = this.zzagI.obtainMessage(1, zza2);
        this.zzagI.sendMessage(message);
    }

    void zza(RuntimeException runtimeException) {
        Message message = this.zzagI.obtainMessage(2, runtimeException);
        this.zzagI.sendMessage(message);
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        String string = prefix + "  ";
        for (Api<?> api : this.zzafU.keySet()) {
            writer.append(prefix).append(api.getName()).println(":");
            Api.zzb zzb2 = this.zzagp.get(api.zzoA());
            zzb2.dump(string, fd, writer, args);
        }
    }

    static abstract class zza {
        private final zzmh zzagO;

        protected zza(zzmh zzmh2) {
            this.zzagO = zzmh2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void zzd(zzmi zzmi2) {
            zzmi2.zzafz.lock();
            try {
                if (zzmi2.zzagK != this.zzagO) {
                    return;
                }
                this.zzpc();
            }
            finally {
                zzmi2.zzafz.unlock();
            }
        }

        protected abstract void zzpc();
    }

    final class zzb
    extends Handler {
        zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    zza zza2 = (zza)msg.obj;
                    zza2.zzd(zzmi.this);
                    break;
                }
                case 2: {
                    throw (RuntimeException)msg.obj;
                }
                default: {
                    Log.w((String)"GACStateManager", (String)("Unknown message id: " + msg.what));
                }
            }
        }
    }
}

